/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.GitLineHandlerListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMessageWithFilesDetector
implements GitLineHandlerListener {
    private static final Logger LOG = Logger.getInstance(GitMessageWithFilesDetector.class);
    @NotNull
    private final Event myEvent;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    protected final Set<String> myAffectedFiles = new HashSet<String>();
    protected boolean myMessageDetected;
    @Nullable
    private Key myMessageOutputType;

    public GitMessageWithFilesDetector(@NotNull Event event, @NotNull VirtualFile root) {
        this.myEvent = event;
        this.myRoot = root;
    }

    @Override
    public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
        if (line.contains(this.myEvent.messageStartMarker)) {
            LOG.debug("|" + this.myEvent.name + "| message start marker detected in [" + line + "]of type " + outputType);
            this.myMessageDetected = true;
            this.myMessageOutputType = outputType;
        } else if (line.contains(this.myEvent.messageEndMarker)) {
            LOG.debug("|" + this.myEvent.name + "| message end marker detected in [" + line + "]of type " + outputType);
            this.myMessageOutputType = null;
        } else if (outputType.equals((Object)this.myMessageOutputType)) {
            LOG.debug("|" + this.myEvent.name + "| Treating as a file: [" + line + "]of type " + outputType);
            this.myAffectedFiles.add(line.trim());
        } else {
            LOG.debug("|" + this.myEvent.name + "| Plain message: [" + line + "]of type " + outputType);
        }
    }

    public boolean wasMessageDetected() {
        return this.myMessageDetected;
    }

    @NotNull
    public Set<String> getRelativeFilePaths() {
        return this.myAffectedFiles;
    }

    @NotNull
    public Collection<VirtualFile> getFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myAffectedFiles.size());
        for (String affectedFile : this.myAffectedFiles) {
            VirtualFile file = this.myRoot.findFileByRelativePath(FileUtil.toSystemIndependentName((String)affectedFile));
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    public static class Event {
        @NotNull
        @NonNls
        private final String name;
        @NotNull
        @NonNls
        private final String messageStartMarker;
        @NotNull
        @NonNls
        private final String messageEndMarker;

        Event(@NotNull @NonNls String eventName, @NotNull @NonNls String messageStartMarker, @NotNull @NonNls String messageEndMarker) {
            this.name = eventName;
            this.messageStartMarker = messageStartMarker;
            this.messageEndMarker = messageEndMarker;
        }
    }
}

