/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsException;
import git4idea.commands.GitHandler;
import git4idea.commands.GitImplBase;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.util.GitUIUtil;
import java.awt.EventQueue;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class GitHandlerUtil {
    private GitHandlerUtil() {
    }

    @Deprecated(forRemoval=true)
    public static int doSynchronously(final @NotNull GitLineHandler handler, final @NotNull @NlsContexts.ProgressTitle String operationTitle, final @NotNull @Nls String operationName) {
        ProgressManager.getInstance().run((Task)new Task.Modal(handler.project(), operationTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                handler.addLineListener(new GitLineHandlerListenerProgress(indicator, handler, operationName, true));
                GitHandlerUtil.runInCurrentThread(handler, indicator, true, operationTitle);
            }
        });
        return handler.getExitCode();
    }

    @Deprecated(forRemoval=true)
    public static void runInCurrentThread(@NotNull GitHandler handler, @Nullable ProgressIndicator indicator, boolean setIndeterminateFlag, @Nullable @Nls String operationName) {
        GitHandlerUtil.runInCurrentThread(handler, () -> {
            if (indicator != null) {
                indicator.setText(operationName == null ? GitBundle.message("git.running", handler.printableCommandLine()) : operationName);
                indicator.setText2("");
                if (setIndeterminateFlag) {
                    indicator.setIndeterminate(true);
                }
            }
        });
    }

    @Deprecated
    public static void runInCurrentThread(@NotNull GitHandler handler, @Nullable Runnable postStartAction) {
        handler.runInCurrentThread(postStartAction);
    }

    static boolean isErrorLine(@NotNull String text) {
        for (String prefix : GitImplBase.ERROR_INDICATORS) {
            if (!text.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true)
    public static class GitLineHandlerListenerProgress
    implements GitLineHandlerListener {
        @NotNull
        protected final GitHandler myHandler;
        @NotNull
        @Nls
        protected final String myOperationName;
        @Nullable
        private final ProgressIndicator myProgressIndicator;
        protected boolean myShowErrors;

        public GitLineHandlerListenerProgress(@Nullable ProgressIndicator indicator, @NotNull GitHandler handler, @NotNull @Nls String operationName, boolean showErrors) {
            this.myHandler = handler;
            this.myOperationName = operationName;
            this.myShowErrors = showErrors;
            this.myProgressIndicator = indicator;
        }

        public void processTerminated(int exitCode) {
            if (exitCode != 0) {
                this.ensureError(exitCode);
                if (this.myShowErrors) {
                    EventQueue.invokeLater(() -> GitUIUtil.showOperationErrors(this.myHandler.project(), this.myHandler.errors(), this.myOperationName));
                }
            }
        }

        private void ensureError(int exitCode) {
            if (this.myHandler.errors().isEmpty()) {
                this.myHandler.addError(new VcsException(GitBundle.message("git.error.exit", exitCode)));
            }
        }

        public void startFailed(@NotNull Throwable exception) {
            this.myHandler.addError(new VcsException(GitBundle.message("git.executable.unknown.error.message", exception.getMessage()), exception));
            if (this.myShowErrors) {
                EventQueue.invokeLater(() -> GitUIUtil.showOperationError(this.myHandler.project(), this.myOperationName, exception.getMessage()));
            }
        }

        @Override
        public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
            if (GitHandlerUtil.isErrorLine(line.trim())) {
                this.myHandler.addError(new VcsException(line));
            }
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setText2(line);
            }
        }
    }
}

