/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitCommandResult {
    private final boolean myStartFailed;
    private final int myExitCode;
    private final boolean myAuthenticationFailed;
    private final List<String> myErrorOutput;
    private final List<String> myOutput;

    public GitCommandResult(boolean startFailed, int exitCode, @NotNull List<String> errorOutput, @NotNull List<String> output) {
        this(startFailed, exitCode, false, errorOutput, output);
    }

    private GitCommandResult(boolean startFailed, int exitCode, boolean authenticationFailed, @NotNull List<String> errorOutput, @NotNull List<String> output) {
        this.myExitCode = exitCode;
        this.myStartFailed = startFailed;
        this.myAuthenticationFailed = authenticationFailed;
        this.myErrorOutput = errorOutput;
        this.myOutput = output;
    }

    @NotNull
    static GitCommandResult withAuthentication(@NotNull GitCommandResult result2, boolean authenticationFailed) {
        return new GitCommandResult(result2.myStartFailed, result2.myExitCode, authenticationFailed, result2.myErrorOutput, result2.myOutput);
    }

    public boolean success() {
        return this.success(new int[0]);
    }

    public boolean success(int ... ignoredErrorCodes) {
        return !this.myStartFailed && (Arrays.stream(ignoredErrorCodes).anyMatch(i -> i == this.myExitCode) || this.myExitCode == 0);
    }

    @NotNull
    public List<String> getOutput() {
        return Collections.unmodifiableList(this.myOutput);
    }

    public int getExitCode() {
        return this.myExitCode;
    }

    public boolean isAuthenticationFailed() {
        return this.myAuthenticationFailed;
    }

    @NotNull
    public List<String> getErrorOutput() {
        return Collections.unmodifiableList(this.myErrorOutput);
    }

    @NonNls
    public String toString() {
        return String.format("{%d} %nOutput: %n%s %nError output: %n%s", this.myExitCode, this.myOutput, this.myErrorOutput);
    }

    @NotNull
    @NlsSafe
    @NlsContexts.NotificationContent
    public String getErrorOutputAsHtmlString() {
        return StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), XmlStringUtil::escapeString, (String)"<br/>");
    }

    @NotNull
    @NlsSafe
    public String getErrorOutputAsJoinedString() {
        return StringUtil.join(GitCommandResult.cleanup(this.getErrorOrStdOutput()), (String)"\n");
    }

    @NotNull
    @NlsSafe
    private List<String> getErrorOrStdOutput() {
        if (!this.myErrorOutput.isEmpty()) {
            return this.myErrorOutput;
        }
        if (this.success()) {
            return Collections.emptyList();
        }
        if (!this.myOutput.isEmpty()) {
            return this.myOutput;
        }
        return Collections.singletonList(GitBundle.message("git.error.exit", this.myExitCode));
    }

    @NotNull
    @NlsSafe
    public String getOutputAsJoinedString() {
        return StringUtil.join(this.myOutput, (String)"\n");
    }

    @NotNull
    @NlsSafe
    public String getOutputOrThrow(int ... ignoredErrorCodes) throws VcsException {
        this.throwOnError(ignoredErrorCodes);
        return this.getOutputAsJoinedString();
    }

    public void throwOnError(int ... ignoredErrorCodes) throws VcsException {
        if (!this.success(ignoredErrorCodes)) {
            throw new VcsException(this.getErrorOutputAsJoinedString());
        }
    }

    @NotNull
    static GitCommandResult startError(@NotNull @Nls String error) {
        return new GitCommandResult(true, -1, Collections.singletonList(error), Collections.emptyList());
    }

    @NotNull
    public static GitCommandResult error(@NotNull @Nls String error) {
        return new GitCommandResult(false, 1, Collections.singletonList(error), Collections.emptyList());
    }

    public boolean cancelled() {
        return false;
    }

    @NotNull
    private static Collection<String> cleanup(@NotNull Collection<String> errorOutput) {
        return ContainerUtil.map(errorOutput, errorMessage -> GitUtil.cleanupErrorPrefixes(errorMessage));
    }

    protected boolean hasStartFailed() {
        return this.myStartFailed;
    }
}

