/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CheckoutProviderEx;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.ui.GitCloneDialogComponent;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitCheckoutProvider
extends CheckoutProviderEx {
    private static final Logger LOG = Logger.getInstance(GitCheckoutProvider.class);
    private static final List<@NonNls String> NON_ERROR_LINE_PREFIXES = Arrays.asList("Cloning into", "remote:", "submodule");

    public String getVcsName() {
        return "_Git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener, @Nullable String predefinedRepositoryUrl) {
        FileDocumentManager.getInstance().saveAllDocuments();
        GitCloneDialog dialog2 = new GitCloneDialog(project, predefinedRepositoryUrl);
        if (!dialog2.showAndGet()) {
            return;
        }
        dialog2.rememberSettings();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parent = new File(dialog2.getParentDirectory());
        VirtualFile destinationParent = lfs.findFileByIoFile(parent);
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog2.getSourceRepositoryURL();
        String directoryName = dialog2.getDirectoryName();
        String parentDirectory = dialog2.getParentDirectory();
        GitCheckoutProvider.clone(project, Git.getInstance(), listener, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
    }

    public static void clone(final @NotNull Project project, final @NotNull Git git, final CheckoutProvider.Listener listener, final VirtualFile destinationParent, final String sourceRepositoryURL, final String directoryName, final String parentDirectory) {
        String projectAbsolutePath = Paths.get(parentDirectory, directoryName).toAbsolutePath().toString();
        String projectPath = FileUtilRt.toSystemIndependentName((String)projectAbsolutePath);
        CloneableProjectsService.CloneTask cloneTask = new CloneableProjectsService.CloneTask(){

            @NotNull
            public CloneableProjectsService.CloneTaskInfo taskInfo() {
                return new CloneableProjectsService.CloneTaskInfo(DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL}), DvcsBundle.message((String)"cloning.repository.cancel", (Object[])new Object[]{sourceRepositoryURL}), DvcsBundle.message((String)"clone.repository", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.tooltip", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.failed", (Object[])new Object[0]), DvcsBundle.message((String)"clone.repository.canceled", (Object[])new Object[0]), DvcsBundle.message((String)"clone.stop.message.title", (Object[])new Object[0]), DvcsBundle.message((String)"clone.stop.message.description", (Object[])new Object[]{sourceRepositoryURL}));
            }

            @NotNull
            public CloneableProjectsService.CloneStatus run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(false);
                GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
                GitCommandResult result2 = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, progressListener);
                if (result2.success()) {
                    File directory = new File(parentDirectory, directoryName);
                    LOG.debug(String.format("Cloned into %s with success=%s", directory, result2));
                    ApplicationManager.getApplication().invokeLater(() -> DvcsUtil.addMappingIfSubRoot((Project)project, (String)directory.getPath(), (String)"Git"));
                    destinationParent.refresh(true, true);
                    listener.directoryCheckedOut(directory, GitVcs.getKey());
                    listener.checkoutCompleted();
                    return CloneableProjectsService.CloneStatus.SUCCESS;
                }
                GitCheckoutProvider.notifyError(project, result2, sourceRepositoryURL);
                return CloneableProjectsService.CloneStatus.FAILURE;
            }
        };
        CloneableProjectsService.getInstance().runCloneTask(projectPath, cloneTask);
    }

    public static boolean doClone(@NotNull Project project, @NotNull Git git, @NotNull String directoryName, @NotNull String parentDirectory, @NotNull String sourceRepositoryURL) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
        GitCommandResult result2 = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, progressListener);
        if (result2.success()) {
            return true;
        }
        GitCheckoutProvider.notifyError(project, result2, sourceRepositoryURL);
        return false;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void notifyError(@NotNull Project project, @NotNull GitCommandResult commandResult, @NotNull String sourceRepositoryURL) {
        String description2;
        @NlsSafe List errorLines = ContainerUtil.filter(commandResult.getErrorOutput(), line -> !ContainerUtil.exists(NON_ERROR_LINE_PREFIXES, prefix -> StringUtil.startsWithIgnoreCase((String)line, (String)prefix)));
        if (errorLines.isEmpty()) {
            description2 = DvcsBundle.message((String)"error.description.cloning.repository.failed", (Object[])new Object[]{sourceRepositoryURL});
        } else {
            List displayErrorLines = ContainerUtil.map((Collection)errorLines, msg -> HtmlChunk.text((String)GitUtil.cleanupErrorPrefixes(msg)));
            description2 = new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)displayErrorLines).toString();
        }
        VcsNotifier.getInstance((Project)project).notifyError("git.clone.failed", DvcsBundle.message((String)"error.title.cloning.repository.failed", (Object[])new Object[0]), description2, true);
    }

    @NotNull
    public String getVcsId() {
        return "git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        this.doCheckout(project, listener, null);
    }

    @NotNull
    public VcsCloneComponent buildVcsCloneComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        return new GitCloneDialogComponent(project, modalityState, dialogStateListener);
    }
}

