/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitUserNameNotDefinedDialog
extends DialogWrapper {
    @NotNull
    private final Collection<? extends VirtualFile> myRootsWithUndefinedProps;
    @NotNull
    private final Collection<? extends VirtualFile> myAllRootsAffectedByCommit;
    @Nullable
    private final Couple<String> myProposedValues;
    @NotNull
    private final GitVcsSettings mySettings;
    private JTextField myNameTextField;
    private JTextField myEmailTextField;
    private JBCheckBox myGlobalCheckbox;

    GitUserNameNotDefinedDialog(@NotNull Project project, @NotNull Collection<? extends VirtualFile> rootsWithUndefinedProps, @NotNull Collection<? extends VirtualFile> allRootsAffectedByCommit, @NotNull Map<VirtualFile, Couple<String>> rootsWithDefinedProps) {
        super(project, false);
        this.myRootsWithUndefinedProps = rootsWithUndefinedProps;
        this.myAllRootsAffectedByCommit = allRootsAffectedByCommit;
        this.mySettings = GitVcsSettings.getInstance(project);
        this.myProposedValues = GitUserNameNotDefinedDialog.calcProposedValues(rootsWithDefinedProps);
        this.setTitle(GitBundle.message("title.user.name.email.not.specified", new Object[0]));
        this.setOKButtonText(GitBundle.message("button.set.name.and.commit", new Object[0]));
        this.init();
    }

    protected ValidationInfo doValidate() {
        String message = GitBundle.message("validation.warning.set.name.email.for.git", new Object[0]);
        if (StringUtil.isEmptyOrSpaces((String)this.getUserName())) {
            return new ValidationInfo(message, (JComponent)this.myNameTextField);
        }
        String email = this.getUserEmail();
        if (StringUtil.isEmptyOrSpaces((String)email)) {
            return new ValidationInfo(message, (JComponent)this.myEmailTextField);
        }
        if (!email.contains("@")) {
            return new ValidationInfo(GitBundle.message("validation.error.email.no.at", new Object[0]), (JComponent)this.myEmailTextField);
        }
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    @Nullable
    private static Couple<String> calcProposedValues(Map<VirtualFile, Couple<String>> rootsWithDefinedProps) {
        if (rootsWithDefinedProps.isEmpty()) {
            return null;
        }
        Iterator<Map.Entry<VirtualFile, Couple<String>>> iterator = rootsWithDefinedProps.entrySet().iterator();
        Couple<String> firstValue = iterator.next().getValue();
        while (iterator.hasNext()) {
            if (firstValue.equals(iterator.next().getValue())) continue;
            return null;
        }
        return firstValue;
    }

    protected JComponent createCenterPanel() {
        JLabel icon = new JLabel(UIUtil.getWarningIcon(), 2);
        JLabel description2 = new JLabel(this.getMessageText());
        this.myNameTextField = new JTextField(20);
        JBLabel nameLabel = new JBLabel(GitBundle.message("label.user.name", new Object[0]) + " ");
        nameLabel.setDisplayedMnemonic('n');
        nameLabel.setLabelFor((Component)this.myNameTextField);
        this.myEmailTextField = new JTextField(20);
        JBLabel emailLabel = new JBLabel(GitBundle.message("label.user.email", new Object[0]) + " ");
        emailLabel.setDisplayedMnemonic('e');
        emailLabel.setLabelFor((Component)this.myEmailTextField);
        if (this.myProposedValues != null) {
            this.myNameTextField.setText((String)this.myProposedValues.getFirst());
            this.myEmailTextField.setText((String)this.myProposedValues.getSecond());
        } else {
            this.myNameTextField.setText(SystemProperties.getUserName());
        }
        this.myGlobalCheckbox = new JBCheckBox(GitBundle.message("checkbox.set.config.property.globally", new Object[0]), this.mySettings.shouldSetUserNameGlobally());
        this.myGlobalCheckbox.setMnemonic('g');
        JPanel rootPanel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag().setDefaultInsets((Insets)JBUI.insets((int)0, (int)0, (int)4, (int)10)).setDefaultAnchor(21).setDefaultFill(2);
        rootPanel.add((Component)description2, g.nextLine().next().coverLine(3).pady(10));
        rootPanel.add((Component)icon, g.nextLine().next().coverColumn(3));
        rootPanel.add((Component)nameLabel, g.next().fillCellNone().insets((Insets)JBUI.insets((int)0, (int)6, (int)4, (int)10)));
        rootPanel.add((Component)this.myNameTextField, g.next());
        rootPanel.add((Component)emailLabel, g.nextLine().next().next().fillCellNone().insets((Insets)JBUI.insets((int)0, (int)6, (int)4, (int)10)));
        rootPanel.add((Component)this.myEmailTextField, g.next());
        rootPanel.add((Component)this.myGlobalCheckbox, g.nextLine().next().next().coverLine(2));
        return rootPanel;
    }

    protected JComponent createNorthPanel() {
        return null;
    }

    @NlsContexts.Label
    @NotNull
    private String getMessageText() {
        if (this.myAllRootsAffectedByCommit.size() == this.myRootsWithUndefinedProps.size()) {
            return "";
        }
        HtmlBuilder sb = new HtmlBuilder().append(GitBundle.message("label.name.email.not.defined.in.n.roots", this.myRootsWithUndefinedProps.size()));
        for (VirtualFile virtualFile : this.myRootsWithUndefinedProps) {
            sb.br().append(virtualFile.getPresentableUrl());
        }
        return sb.wrapWithHtmlBody().toString();
    }

    public String getUserName() {
        return this.myNameTextField.getText();
    }

    public String getUserEmail() {
        return this.myEmailTextField.getText();
    }

    public boolean isGlobal() {
        return this.myGlobalCheckbox.isSelected();
    }
}

