/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import git4idea.DialogManager;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.ui.ChangesBrowserWithRollback;
import git4idea.util.GitSimplePathsBrowser;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitSmartOperationDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(GitSmartOperationDialog.class);
    private static final int FORCE_EXIT_CODE = 2;
    @NotNull
    private final JComponent myFileBrowser;
    @NotNull
    @Nls
    private final String myOperationTitle;
    @NotNull
    private final GitSaveChangesPolicy mySaveMethod;
    @Nullable
    @Nls
    private final String myForceButton;

    @NotNull
    static Choice show(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull Collection<String> paths, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String operationTitle, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String forceButtonTitle) {
        Object fileBrowser = !changes.isEmpty() ? new ChangesBrowserWithRollback(project, changes) : new GitSimplePathsBrowser(project, paths);
        GitSmartOperationDialog dialog2 = new GitSmartOperationDialog(project, (JComponent)fileBrowser, operationTitle, forceButtonTitle);
        if (fileBrowser instanceof Disposable) {
            Disposer.register((Disposable)dialog2.getDisposable(), (Disposable)fileBrowser);
        }
        DialogManager.show(dialog2);
        return Choice.fromDialogExitCode(dialog2.getExitCode());
    }

    private GitSmartOperationDialog(@NotNull Project project, @NotNull JComponent fileBrowser, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String operationTitle, @Nullable @Nls(capitalization=Nls.Capitalization.Title) String forceButton) {
        super(project);
        this.myFileBrowser = fileBrowser;
        this.myOperationTitle = operationTitle;
        this.myForceButton = forceButton;
        this.mySaveMethod = GitVcsSettings.getInstance(project).getSaveChangesPolicy();
        String capitalizedOperation = StringUtil.capitalize((String)this.myOperationTitle);
        this.setTitle(GitBundle.message("smart.operation.dialog.git.operation.name.problem", capitalizedOperation));
        this.setOKButtonText(GitBundle.message("smart.operation.dialog.smart.operation.name", capitalizedOperation));
        String description2 = this.mySaveMethod.selectBundleMessage(GitBundle.message("smart.operation.dialog.ok.action.stash.description", operationTitle), GitBundle.message("smart.operation.dialog.ok.action.shelf.description", operationTitle));
        this.getOKAction().putValue("ShortDescription", description2);
        this.setCancelButtonText(GitBundle.message("smart.operation.dialog.don.t.operation.name", capitalizedOperation));
        this.getCancelAction().putValue("FocusedAction", Boolean.TRUE);
        this.init();
    }

    protected Action @NotNull [] createLeftSideActions() {
        if (this.myForceButton != null) {
            return new Action[]{new ForceCheckoutAction(this.myForceButton, this.myOperationTitle)};
        }
        return new Action[0];
    }

    protected JComponent createNorthPanel() {
        String labelText = this.mySaveMethod.selectBundleMessage(GitBundle.message("smart.operation.dialog.north.panel.label.stash.text", this.myOperationTitle, ApplicationNamesInfo.getInstance().getFullProductName()), GitBundle.message("smart.operation.dialog.north.panel.label.shelf.text", this.myOperationTitle, ApplicationNamesInfo.getInstance().getFullProductName()));
        return new JBLabel(labelText).withBorder((Border)JBUI.Borders.emptyBottom((int)10));
    }

    protected JComponent createCenterPanel() {
        return this.myFileBrowser;
    }

    protected String getDimensionServiceKey() {
        return GitSmartOperationDialog.class.getName();
    }

    private class ForceCheckoutAction
    extends AbstractAction {
        ForceCheckoutAction(@NotNull @Nls(capitalization=Nls.Capitalization.Title) String buttonTitle, String operationTitle) {
            super(buttonTitle);
            String description2 = GitBundle.message("smart.operation.dialog.operation.name.and.overwrite.local.changes", StringUtil.capitalize((String)operationTitle));
            this.putValue("ShortDescription", description2);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GitSmartOperationDialog.this.close(2);
        }
    }

    public static enum Choice {
        SMART,
        FORCE,
        CANCEL;


        @NotNull
        private static Choice fromDialogExitCode(int exitCode) {
            if (exitCode == 0) {
                return SMART;
            }
            if (exitCode == 2) {
                return FORCE;
            }
            if (exitCode == 1) {
                return CANCEL;
            }
            LOG.error("Unexpected exit code: " + exitCode);
            return CANCEL;
        }
    }
}

