/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import git4idea.GitUtil;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class GitMergeOperation
extends GitBranchOperation {
    private static final Logger LOG = Logger.getInstance(GitMergeOperation.class);
    @NotNull
    private static final String DELETE_HREF_ATTRIBUTE = "delete";
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    @NlsSafe
    private final String myBranchToMerge;
    private final GitBrancher.DeleteOnMergeOption myDeleteOnMerge;
    @NotNull
    private final Map<GitRepository, Boolean> myConflictedRepositories = new HashMap<GitRepository, Boolean>();
    private GitPreservingProcess myPreservingProcess;

    GitMergeOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull Collection<? extends GitRepository> repositories, @NotNull String branchToMerge, GitBrancher.DeleteOnMergeOption deleteOnMerge) {
        super(project, git, uiHandler, repositories);
        this.myBranchToMerge = branchToMerge;
        this.myDeleteOnMerge = deleteOnMerge;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
    }

    @Override
    protected void execute() {
        LOG.info("starting");
        GitMergeOperation.saveAllDocuments();
        boolean fatalErrorHappened = false;
        int alreadyUpToDateRepositories = 0;
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)this.getOperationName());){
            while (this.hasMoreRepositories() && !fatalErrorHappened) {
                GitRepository repository = this.next();
                LOG.info("next repository: " + repository);
                VirtualFile root = repository.getRoot();
                Hash startHash = GitUtil.getHead(repository);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                GitSimpleEventDetector unmergedFiles = new GitSimpleEventDetector(GitSimpleEventDetector.Event.UNMERGED_PREVENTING_MERGE);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedOverwrittenByMerge = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
                GitSimpleEventDetector alreadyUpToDateDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.ALREADY_UP_TO_DATE);
                GitCommandResult result2 = this.myGit.merge(repository, this.myBranchToMerge, Collections.emptyList(), localChangesDetector, unmergedFiles, untrackedOverwrittenByMerge, mergeConflict, alreadyUpToDateDetector);
                if (result2.success()) {
                    LOG.info("Merged successfully");
                    GitUtil.updateAndRefreshChangedVfs(repository, startHash);
                    this.markSuccessful(repository);
                    if (!alreadyUpToDateDetector.hasHappened()) continue;
                    ++alreadyUpToDateRepositories;
                    continue;
                }
                if (unmergedFiles.hasHappened()) {
                    LOG.info("Unmerged files error!");
                    this.fatalUnmergedFilesError();
                    fatalErrorHappened = true;
                    continue;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LOG.info("Local changes would be overwritten by merge!");
                    boolean smartMergeSucceeded = this.proposeSmartMergePerformAndNotify(repository, localChangesDetector);
                    if (smartMergeSucceeded) continue;
                    fatalErrorHappened = true;
                    continue;
                }
                if (mergeConflict.hasHappened()) {
                    LOG.info("Merge conflict");
                    this.myConflictedRepositories.put(repository, Boolean.FALSE);
                    GitUtil.updateAndRefreshChangedVfs(repository, startHash);
                    this.markSuccessful(repository);
                    continue;
                }
                if (untrackedOverwrittenByMerge.wasMessageDetected()) {
                    LOG.info("Untracked files would be overwritten by merge!");
                    this.fatalUntrackedFilesError(repository.getRoot(), untrackedOverwrittenByMerge.getRelativeFilePaths());
                    fatalErrorHappened = true;
                    continue;
                }
                LOG.info("Unknown error. " + result2);
                this.fatalError(this.getCommonErrorTitle(), result2);
                fatalErrorHappened = true;
            }
            if (fatalErrorHappened) {
                this.notifyAboutRemainingConflicts();
            } else {
                boolean allConflictsResolved = this.resolveConflicts();
                if (allConflictsResolved) {
                    if (alreadyUpToDateRepositories < this.getRepositories().size()) {
                        this.notifySuccess();
                    } else {
                        this.notifySuccess(GitBundle.message("merge.operation.already.up.to.date", new Object[0]));
                    }
                }
            }
            this.restoreLocalChanges();
        }
    }

    private void notifyAboutRemainingConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            new MyMergeConflictResolver().notifyUnresolvedRemain();
        }
    }

    @Override
    protected void notifySuccess(@NotNull @Nls String message) {
        switch (this.myDeleteOnMerge) {
            case DELETE: {
                super.notifySuccess(message);
                new GitBranchWorker(this.myProject, this.myGit, this.myUiHandler).deleteBranch(this.myBranchToMerge, new ArrayList<GitRepository>(this.getRepositories()));
                break;
            }
            case PROPOSE: {
                String deleteBranch = GitBundle.message("merge.operation.delete.branch", this.myBranchToMerge);
                String description2 = new HtmlBuilder().appendRaw(message).br().appendLink(DELETE_HREF_ATTRIBUTE, deleteBranch).toString();
                VcsNotifier.getInstance((Project)this.myProject).notifySuccess("git.delete.branch.on.merge", "", description2, (NotificationListener)new DeleteMergedLocalBranchNotificationListener());
                break;
            }
            case NOTHING: {
                super.notifySuccess(message);
            }
        }
    }

    private boolean resolveConflicts() {
        if (!this.myConflictedRepositories.isEmpty()) {
            return new MyMergeConflictResolver().merge();
        }
        return true;
    }

    private boolean proposeSmartMergePerformAndNotify(@NotNull GitRepository repository, @NotNull GitMessageWithFilesDetector localChangesOverwrittenByMerge) {
        Collection<String> absolutePaths;
        Pair<List<GitRepository>, List<Change>> conflictingRepositoriesAndAffectedChanges = this.getConflictingRepositoriesAndAffectedChanges(repository, localChangesOverwrittenByMerge, (String)this.myCurrentHeads.get(repository), this.myBranchToMerge);
        List allConflictingRepositories = (List)conflictingRepositoriesAndAffectedChanges.getFirst();
        List affectedChanges = (List)conflictingRepositoriesAndAffectedChanges.getSecond();
        GitSmartOperationDialog.Choice decision = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths = GitUtil.toAbsolute(repository.getRoot(), localChangesOverwrittenByMerge.getRelativeFilePaths()), GitBundle.message("merge.operation.name", new Object[0]), null);
        if (decision == GitSmartOperationDialog.Choice.SMART) {
            return this.doSmartMerge(allConflictingRepositories);
        }
        this.fatalLocalChangesError(this.myBranchToMerge);
        return false;
    }

    private void restoreLocalChanges() {
        if (this.myPreservingProcess != null) {
            this.myPreservingProcess.load();
        }
    }

    private boolean doSmartMerge(@NotNull Collection<? extends GitRepository> repositories) {
        AtomicBoolean success = new AtomicBoolean();
        GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance(this.myProject).getSaveChangesPolicy();
        this.myPreservingProcess = new GitPreservingProcess(this.myProject, this.myGit, GitUtil.getRootsFromRepositories(repositories), GitBundle.message("merge.operation.name", new Object[0]), this.myBranchToMerge, saveMethod, this.getIndicator(), () -> success.set(this.doMerge(repositories)));
        this.myPreservingProcess.execute((Computable<Boolean>)((Computable)this.myConflictedRepositories::isEmpty));
        return success.get();
    }

    private boolean doMerge(@NotNull Collection<? extends GitRepository> repositories) {
        for (GitRepository gitRepository : repositories) {
            Hash startHash = GitUtil.getHead(gitRepository);
            GitSimpleEventDetector mergeConflict = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT);
            GitCommandResult result2 = this.myGit.merge(gitRepository, this.myBranchToMerge, Collections.emptyList(), mergeConflict);
            if (!result2.success()) {
                if (mergeConflict.hasHappened()) {
                    this.myConflictedRepositories.put(gitRepository, Boolean.TRUE);
                    GitUtil.updateAndRefreshChangedVfs(gitRepository, startHash);
                    this.markSuccessful(gitRepository);
                    continue;
                }
                this.fatalError(this.getCommonErrorTitle(), result2);
                return false;
            }
            GitUtil.updateAndRefreshChangedVfs(gitRepository, startHash);
            this.markSuccessful(gitRepository);
        }
        return true;
    }

    @NotNull
    @NlsContexts.NotificationTitle
    private String getCommonErrorTitle() {
        return GitBundle.message("merge.operation.could.not.merge.branch", this.myBranchToMerge);
    }

    @Override
    protected void rollback() {
        LOG.info("starting rollback...");
        ArrayList<GitRepository> repositoriesForSmartRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForSimpleRollback = new ArrayList<GitRepository>();
        ArrayList<GitRepository> repositoriesForMergeRollback = new ArrayList<GitRepository>();
        for (GitRepository repository : this.getSuccessfulRepositories()) {
            if (this.myConflictedRepositories.containsKey(repository)) {
                repositoriesForMergeRollback.add(repository);
                continue;
            }
            if (this.thereAreLocalChangesIn(repository)) {
                repositoriesForSmartRollback.add(repository);
                continue;
            }
            repositoriesForSimpleRollback.add(repository);
        }
        LOG.info("for smart rollback: " + DvcsUtil.getShortNames(repositoriesForSmartRollback) + "; for simple rollback: " + DvcsUtil.getShortNames(repositoriesForSimpleRollback) + "; for merge rollback: " + DvcsUtil.getShortNames(repositoriesForMergeRollback));
        GitCompoundResult result2 = this.smartRollback(repositoriesForSmartRollback);
        for (GitRepository repository : repositoriesForSimpleRollback) {
            result2.append(repository, this.rollback(repository));
        }
        for (GitRepository repository : repositoriesForMergeRollback) {
            result2.append(repository, this.rollbackMerge(repository));
        }
        this.myConflictedRepositories.clear();
        if (!result2.totalSuccess()) {
            VcsNotifier.getInstance((Project)this.myProject).notifyError("git.merge.rollback.error", GitBundle.message("merge.operation.error.during.rollback", new Object[0]), result2.getErrorOutputWithReposIndication(), true);
        }
        LOG.info("rollback finished.");
    }

    @NotNull
    private GitCompoundResult smartRollback(@NotNull Collection<? extends GitRepository> repositories) {
        LOG.info("Starting smart rollback...");
        GitCompoundResult result2 = new GitCompoundResult(this.myProject);
        Collection<VirtualFile> roots = GitUtil.getRootsFromRepositories(repositories);
        GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance(this.myProject).getSaveChangesPolicy();
        GitPreservingProcess preservingProcess = new GitPreservingProcess(this.myProject, this.myGit, roots, GitBundle.message("merge.operation.name", new Object[0]), this.myBranchToMerge, saveMethod, this.getIndicator(), () -> {
            for (GitRepository repository : repositories) {
                result2.append(repository, this.rollback(repository));
            }
        });
        preservingProcess.execute();
        LOG.info("Smart rollback completed.");
        return result2;
    }

    @NotNull
    private GitCommandResult rollback(@NotNull GitRepository repository) {
        return this.myGit.reset(repository, GitResetMode.HARD, this.getInitialRevision(repository), new GitLineHandlerListener[0]);
    }

    @NotNull
    private GitCommandResult rollbackMerge(@NotNull GitRepository repository) {
        Hash startHash = GitUtil.getHead(repository);
        GitCommandResult result2 = this.myGit.resetMerge(repository, null);
        GitUtil.updateAndRefreshChangedVfs(repository, startHash);
        return result2;
    }

    private boolean thereAreLocalChangesIn(@NotNull GitRepository repository) {
        return !this.myChangeListManager.getChangesIn(repository.getRoot()).isEmpty();
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        return GitBundle.message("merge.operation.merged.to", GitUIUtil.bold(GitUIUtil.code(this.myBranchToMerge)), GitUIUtil.bold(GitUIUtil.code(GitMergeOperation.stringifyBranchesByRepos(this.myCurrentHeads))));
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        return new HtmlBuilder().append(GitBundle.message("merge.operation.however.merge.has.succeeded.for.the.following.repositories", this.getSuccessfulRepositories().size())).br().appendRaw(this.successfulRepositoriesJoined()).br().append(GitBundle.message("merge.operation.you.may.rollback.not.to.let.branches.diverge", new Object[0])).toString();
    }

    @Override
    @NotNull
    @Nls
    protected String getOperationName() {
        return GitBundle.message("merge.operation.name", new Object[0]);
    }

    private class DeleteMergedLocalBranchNotificationListener
    extends NotificationListener.Adapter {
        private DeleteMergedLocalBranchNotificationListener() {
        }

        protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
            if (event.getDescription().equalsIgnoreCase(GitMergeOperation.DELETE_HREF_ATTRIBUTE)) {
                notification2.expire();
                GitBrancher.getInstance(GitMergeOperation.this.myProject).deleteBranch(GitMergeOperation.this.myBranchToMerge, new ArrayList<GitRepository>(GitMergeOperation.this.getRepositories()));
            }
        }
    }

    private class MyMergeConflictResolver
    extends GitMergeCommittingConflictResolver {
        MyMergeConflictResolver() {
            super(GitMergeOperation.this.myProject, GitMergeOperation.this.myGit, new GitMerger(GitMergeOperation.this.myProject), GitUtil.getRootsFromRepositories(GitMergeOperation.this.myConflictedRepositories.keySet()), new GitConflictResolver.Params(GitMergeOperation.this.myProject), true);
        }

        @Override
        protected void notifyUnresolvedRemain() {
            this.notifyWarning(GitBundle.message("merge.operation.branch.merged.with.conflicts", GitMergeOperation.this.myBranchToMerge), "");
        }
    }
}

