/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchWorker;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitCompareBranchesUi;
import git4idea.branch.GitShowDiffWithBranchPanel;
import git4idea.commands.Git;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBrancherImpl
implements GitBrancher {
    @NotNull
    private final Project myProject;

    GitBrancherImpl(@NotNull Project project) {
        this.myProject = project;
    }

    @Override
    public void checkoutNewBranch(final @NotNull String name, final @NotNull List<? extends GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.new.branch.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranch(name, repositories);
            }
        }.runInBackground();
    }

    @NotNull
    private GitBranchWorker newWorker(@NotNull ProgressIndicator indicator) {
        return new GitBranchWorker(this.myProject, Git.getInstance(), new GitBranchUiHandlerImpl(this.myProject, indicator));
    }

    @Override
    public void createBranch(@NotNull String name, @NotNull Map<GitRepository, String> startPoints) {
        this.createBranch(name, startPoints, false);
    }

    @Override
    public void createBranch(final @NotNull String name, final @NotNull Map<GitRepository, String> startPoints, final boolean force) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.creating.branch.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).createBranch(name, startPoints, force);
            }
        }.runInBackground();
    }

    @Override
    public void createNewTag(final @NotNull String name, final @NotNull String reference, final @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.new.branch.process", name), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).createNewTag(name, reference, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void checkout(final @NotNull String reference, final boolean detach, final @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.process", reference), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).checkout(reference, detach, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void checkoutNewBranchStartingFrom(@NotNull String newBranchName, @NotNull String startPoint, @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        this.checkoutNewBranchStartingFrom(newBranchName, startPoint, false, repositories, callInAwtLater);
    }

    @Override
    public void checkoutNewBranchStartingFrom(final @NotNull String newBranchName, final @NotNull String startPoint, final boolean overwriteIfNeeded, final @NotNull List<? extends GitRepository> repositories, @Nullable Runnable callInAwtLater) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.checking.out.branch.from.process", newBranchName, startPoint), callInAwtLater){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).checkoutNewBranchStartingFrom(newBranchName, startPoint, overwriteIfNeeded, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void deleteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        this.deleteBranches(Collections.singletonMap(branchName, repositories), null);
    }

    @Override
    public void deleteBranches(final @NotNull Map<String, List<? extends GitRepository>> branchesToContainingRepositories, @Nullable Runnable callInAwtAfterExecution) {
        if (branchesToContainingRepositories.isEmpty()) {
            return;
        }
        final Set<String> branchNames = branchesToContainingRepositories.keySet();
        String branchMsg = branchNames.size() == 1 ? branchNames.iterator().next() : StringUtil.join(branchNames, (String)", ");
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.branch.process", branchMsg), callInAwtAfterExecution){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBranchWorker worker = GitBrancherImpl.this.newWorker(indicator);
                for (String branchName : branchNames) {
                    worker.deleteBranch(branchName, branchesToContainingRepositories.getOrDefault(branchName, Collections.emptyList()));
                }
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteBranch(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        this.deleteRemoteBranches(Collections.singletonList(branchName), repositories);
    }

    @Override
    public void deleteRemoteBranches(final @NotNull List<String> branchNames, final @NotNull List<? extends GitRepository> repositories) {
        if (branchNames.isEmpty()) {
            return;
        }
        String branchMsg = branchNames.size() == 1 ? branchNames.iterator().next() : StringUtil.join(branchNames, (String)", ");
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.remote.branch", branchMsg), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteBranches(branchNames, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void compare(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        new GitCompareBranchesUi(this.myProject, repositories, branchName).open();
    }

    @Override
    public void compareAny(@NotNull String branchName, @NotNull String otherBranchName, @NotNull List<? extends GitRepository> repositories) {
        new GitCompareBranchesUi(this.myProject, repositories, branchName, otherBranchName).open();
    }

    @Override
    public void showDiffWithLocal(@NotNull String branchName, @NotNull List<? extends GitRepository> repositories) {
        new GitShowDiffWithBranchPanel(this.myProject, branchName, repositories, GitBranchUtil.getCurrentBranchOrRev(repositories)).showAsTab();
    }

    @Override
    public void merge(final @NotNull String branchName, final @NotNull GitBrancher.DeleteOnMergeOption deleteOnMerge, final @NotNull List<? extends GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.merging.process", branchName), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).merge(branchName, deleteOnMerge, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void rebase(final @NotNull List<? extends GitRepository> repositories, final @NotNull String branchName) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.rebasing.onto.process", branchName), null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories, branchName);
            }
        }.runInBackground();
    }

    @Override
    public void rebaseOnCurrent(@NotNull List<? extends GitRepository> repositories, @NotNull String branchName) {
        this.rebase(repositories, "HEAD", branchName);
    }

    @Override
    public void rebase(final @NotNull List<? extends GitRepository> repositories, final @NotNull String upstream, final @NotNull String branchName) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.rebasing.process", branchName), null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).rebase(repositories, upstream, branchName);
            }
        }.runInBackground();
    }

    @Override
    public void renameBranch(final @NotNull String currentName, final @NotNull String newName, final @NotNull List<? extends GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.renaming.branch.process", currentName, newName), null){

            @Override
            void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).renameBranch(currentName, newName, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void deleteTag(final @NotNull String name, final @NotNull List<? extends GitRepository> repositories) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.tag.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).deleteTag(name, repositories);
            }
        }.runInBackground();
    }

    @Override
    public void deleteRemoteTag(final @NotNull String name, final @NotNull Map<GitRepository, String> repositories) {
        new CommonBackgroundTask(this.myProject, GitBundle.message("branch.deleting.tag.on.remote.process", name), null){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                GitBrancherImpl.this.newWorker(indicator).deleteRemoteTag(name, repositories);
            }
        }.runInBackground();
    }

    private static abstract class CommonBackgroundTask
    extends Task.Backgroundable {
        @Nullable
        private final Runnable myCallInAwtAfterExecution;

        private CommonBackgroundTask(@Nullable Project project, @Nls @NotNull String title, @Nullable Runnable callInAwtAfterExecution) {
            super(project, title);
            this.myCallInAwtAfterExecution = callInAwtAfterExecution;
        }

        public final void run(@NotNull ProgressIndicator indicator) {
            this.execute(indicator);
            if (this.myCallInAwtAfterExecution != null) {
                Application application = ApplicationManager.getApplication();
                application.invokeAndWait(this.myCallInAwtAfterExecution, application.getDefaultModalityState());
            }
        }

        abstract void execute(@NotNull ProgressIndicator var1);

        void runInBackground() {
            GitVcs.runInBackground(this);
        }
    }
}

