/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitBranchUtil {
    private static final Logger LOG = Logger.getInstance(GitBranchUtil.class);
    private static final String NO_BRANCH_NAME = "(no branch)";

    private GitBranchUtil() {
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForBranch(@NotNull GitRepository repository, @NotNull GitLocalBranch branch) {
        return GitBranchUtil.getTrackInfo(repository, branch.getName());
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfo(@NotNull GitRepository repository, @NotNull @NonNls String localBranchName) {
        return repository.getBranchTrackInfo(localBranchName);
    }

    @NlsSafe
    @NotNull
    static String getCurrentBranchOrRev(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories.size() > 1) {
            GitMultiRootBranchConfig multiRootBranchConfig = new GitMultiRootBranchConfig(repositories);
            String currentBranch = multiRootBranchConfig.getCurrentBranch();
            LOG.assertTrue(currentBranch != null, (Object)("Repositories have unexpectedly diverged. " + multiRootBranchConfig));
            return currentBranch;
        }
        assert (!repositories.isEmpty()) : "No repositories passed to GitBranchOperationsProcessor.";
        GitRepository repository = repositories.iterator().next();
        return GitBranchUtil.getBranchNameOrRev(repository);
    }

    @NotNull
    public static Collection<String> convertBranchesToNames(@NotNull Collection<? extends GitBranch> branches2) {
        return ContainerUtil.map(branches2, GitReference::getName);
    }

    @NotNull
    public static List<String> getAllTags(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.TAG);
        h2.addParameters("-l");
        h2.setSilent(true);
        final ArrayList<String> tags = new ArrayList<String>();
        h2.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                if (line.length() != 0) {
                    tags.add(line);
                }
            }
        });
        GitCommandResult result2 = Git.getInstance().runCommandWithoutCollectingOutput(h2);
        result2.throwOnError(new int[0]);
        return tags;
    }

    @NotNull
    public static Collection<String> getBranchNamesWithoutRemoteHead(@NotNull Collection<? extends GitRemoteBranch> remoteBranches) {
        return ContainerUtil.filter(GitBranchUtil.convertBranchesToNames(remoteBranches), input -> !input.equals("HEAD"));
    }

    @NlsSafe
    @NotNull
    public static String stripRefsPrefix(@NotNull @NonNls String branchName) {
        if (branchName.startsWith("refs/heads/")) {
            return branchName.substring("refs/heads/".length());
        }
        if (branchName.startsWith("refs/remotes/")) {
            return branchName.substring("refs/remotes/".length());
        }
        if (branchName.startsWith("refs/tags/")) {
            return branchName.substring("refs/tags/".length());
        }
        return branchName;
    }

    @NlsSafe
    @NotNull
    public static String getBranchNameOrRev(@NotNull GitRepository repository) {
        if (repository.isOnBranch()) {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            return currentBranch.getName();
        }
        String currentRevision = repository.getCurrentRevision();
        return currentRevision != null ? currentRevision.substring(0, 7) : "";
    }

    @Nullable
    public static GitNewBranchOptions getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull @NlsContexts.DialogTitle String dialogTitle, @Nullable @NlsSafe String initialName) {
        return GitBranchUtil.getNewBranchNameFromUser(project, repositories, dialogTitle, initialName, false);
    }

    @Nullable
    public static GitNewBranchOptions getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NotNull @NlsContexts.DialogTitle String dialogTitle, @Nullable @NlsSafe String initialName, boolean showTrackingOption) {
        return new GitNewBranchDialog(project, repositories, dialogTitle, initialName, true, false, showTrackingOption).showAndGetOptions();
    }

    @Nls
    @NotNull
    public static String getDisplayableBranchText(@NotNull GitRepository repository) {
        String branchName;
        Repository.State state = repository.getState();
        if (state == Repository.State.DETACHED) {
            String currentRevision = repository.getCurrentRevision();
            if (currentRevision != null) {
                return DvcsUtil.getShortHash((String)currentRevision);
            }
            LOG.warn(String.format("Current revision is null in DETACHED state. isFresh: %s", repository.isFresh()));
            return GitBundle.message("git.status.bar.widget.text.unknown", new Object[0]);
        }
        GitLocalBranch branch = repository.getCurrentBranch();
        String string = branchName = branch == null ? "" : branch.getName();
        if (state == Repository.State.MERGING) {
            return GitBundle.message("git.status.bar.widget.text.merge", branchName);
        }
        if (state == Repository.State.REBASING) {
            return GitBundle.message("git.status.bar.widget.text.rebase", branchName);
        }
        if (state == Repository.State.GRAFTING) {
            return GitBundle.message("git.status.bar.widget.text.cherry.pick", branchName);
        }
        if (state == Repository.State.REVERTING) {
            return GitBundle.message("git.status.bar.widget.text.revert", branchName);
        }
        return branchName;
    }

    @Nullable
    @RequiresEdt
    public static GitRepository getCurrentRepository(@NotNull Project project) {
        return GitBranchUtil.getRepositoryOrGuess(project, DvcsUtil.getSelectedFile((Project)project));
    }

    @Nullable
    public static GitRepository getRepositoryOrGuess(@NotNull Project project, @Nullable VirtualFile file) {
        if (project.isDisposed()) {
            return null;
        }
        return (GitRepository)DvcsUtil.guessRepositoryForFile((Project)project, (RepositoryManager)GitUtil.getRepositoryManager(project), (VirtualFile)file, (String)GitVcsSettings.getInstance(project).getRecentRootPath());
    }

    @NotNull
    public static Collection<String> getCommonBranches(Collection<? extends GitRepository> repositories, boolean local) {
        Collection<String> names = local ? GitBranchUtil.convertBranchesToNames(GitBranchUtil.getCommonLocalBranches(repositories)) : GitBranchUtil.getBranchNamesWithoutRemoteHead(GitBranchUtil.getCommonRemoteBranches(repositories));
        return ((StreamEx)StreamEx.of(names).sorted(StringUtil::naturalCompare)).toList();
    }

    @NotNull
    public static List<GitLocalBranch> getCommonLocalBranches(@NotNull Collection<? extends GitRepository> repositories) {
        return GitBranchUtil.collectCommon(repositories.stream().map(repository -> repository.getBranches().getLocalBranches()));
    }

    @NotNull
    public static List<GitRemoteBranch> getCommonRemoteBranches(@NotNull Collection<? extends GitRepository> repositories) {
        return GitBranchUtil.collectCommon(repositories.stream().map(repository -> repository.getBranches().getRemoteBranches()));
    }

    @NotNull
    public static <T> List<T> collectCommon(@NotNull Stream<? extends Collection<T>> groups) {
        return GitBranchUtil.collectCommon(groups, null);
    }

    @NotNull
    public static <T> List<T> collectCommon(@NotNull Stream<? extends Collection<T>> groups, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Hash.Strategy<? super T> hashingStrategy) {
        ArrayList common = new ArrayList();
        boolean[] firstGroup = new boolean[]{true};
        groups.forEach(values2 -> {
            if (firstGroup[0]) {
                firstGroup[0] = false;
                common.addAll(values2);
            } else {
                HashSet c = hashingStrategy == null ? new HashSet(values2) : new ObjectOpenCustomHashSet(values2, hashingStrategy);
                common.retainAll(c);
            }
        });
        return common;
    }

    @NotNull
    public static <T extends GitReference> List<T> sortBranchesByName(@NotNull Collection<? extends T> branches2) {
        return branches2.stream().sorted(Comparator.comparing(GitReference::getFullName, NaturalComparator.INSTANCE)).collect(Collectors.toList());
    }

    @NotNull
    public static List<String> sortBranchNames(@NotNull Collection<String> branchNames) {
        return ContainerUtil.sorted(branchNames, (Comparator)NaturalComparator.INSTANCE);
    }

    @NotNull
    @RequiresBackgroundThread
    public static Collection<String> getBranches(@NotNull Project project, @NotNull VirtualFile root, boolean localWanted, boolean remoteWanted, @Nullable String containingCommit) throws VcsException {
        String[] split;
        String output;
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.BRANCH);
        handler.setSilent(true);
        handler.addParameters("--no-color");
        boolean remoteOnly = false;
        if (remoteWanted && localWanted) {
            handler.addParameters("-a");
            remoteOnly = false;
        } else if (remoteWanted) {
            handler.addParameters("-r");
            remoteOnly = true;
        }
        if (containingCommit != null) {
            handler.addParameters("--contains", containingCommit);
        }
        if ((output = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0])).trim().length() == 0) {
            try {
                File headFile = GitUtil.getRepositoryForRoot(project, root).getRepositoryFiles().getHeadFile();
                String head = FileUtil.loadFile((File)headFile, (Charset)StandardCharsets.UTF_8).trim();
                String prefix = "ref: refs/heads/";
                return head.startsWith("ref: refs/heads/") ? Collections.singletonList(head.substring("ref: refs/heads/".length())) : Collections.emptyList();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return Collections.emptyList();
            }
        }
        ArrayList<String> branches2 = new ArrayList<String>();
        for (String b : split = output.split("\n")) {
            boolean isRemote;
            if ((b = b.substring(2).trim()).equals(NO_BRANCH_NAME)) continue;
            String remotePrefix = null;
            if (b.startsWith("remotes/")) {
                remotePrefix = "remotes/";
            } else if (b.startsWith("refs/remotes/")) {
                remotePrefix = "refs/remotes/";
            }
            boolean bl = isRemote = remotePrefix != null || remoteOnly;
            if (isRemote) {
                int idx;
                if (!remoteOnly) {
                    b = b.substring(remotePrefix.length());
                }
                if ((idx = b.indexOf("HEAD ->")) > 0) continue;
            }
            branches2.add(b);
        }
        return branches2;
    }

    public static boolean equalBranches(@Nullable @NonNls String branchA, @Nullable @NonNls String branchB) {
        return StringUtilRt.equal((CharSequence)branchA, (CharSequence)branchB, (boolean)SystemInfo.isFileSystemCaseSensitive);
    }

    public static void updateBranches(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull List<String> localBranchNames) {
        GitBranchActionsUtilKt.updateBranches(project, repositories, localBranchNames);
    }
}

