/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.branch.DeepComparator;
import git4idea.repo.GitRepositoryManager;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class DeepComparatorHolder
implements Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<VcsLogUi, DeepComparator> myComparators;

    private DeepComparatorHolder(@NotNull Project project) {
        this.myProject = project;
        this.myComparators = new HashMap<VcsLogUi, DeepComparator>();
    }

    @NotNull
    public DeepComparator getInstance(@NotNull VcsLogData dataProvider, final @NotNull VcsLogUi ui) {
        DeepComparator comparator = this.myComparators.get(ui);
        if (comparator == null) {
            comparator = new DeepComparator(this.myProject, GitRepositoryManager.getInstance(this.myProject), dataProvider, ui, this);
            this.myComparators.put(ui, comparator);
            if (ui instanceof Disposable) {
                Disposer.register((Disposable)((Disposable)ui), (Disposable)new Disposable(){

                    public void dispose() {
                        DeepComparator removed = DeepComparatorHolder.this.myComparators.remove(ui);
                        if (removed != null) {
                            Disposer.dispose((Disposable)removed);
                        }
                    }
                });
            }
        }
        return comparator;
    }

    public void dispose() {
        this.myComparators.clear();
    }
}

