/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotatedLineModificationDetails;
import com.intellij.openapi.vcs.annotate.AnnotationTooltipBuilder;
import com.intellij.openapi.vcs.annotate.DefaultLineModificationDetailsProvider;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.AbstractVcsHelperImpl;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.util.VcsUserUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.changes.GitCommittedChangeList;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.log.GitCommitTooltipLinkHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitFileAnnotation
extends FileAnnotation {
    private static final Logger LOG = Logger.getInstance(GitFileAnnotation.class);
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final FilePath myFilePath;
    @NotNull
    private final GitVcs myVcs;
    @Nullable
    private final VcsRevisionNumber myBaseRevision;
    @NotNull
    private final List<LineInfo> myLines;
    @Nullable
    private List<VcsFileRevision> myRevisions;
    @Nullable
    private Object2IntMap<VcsRevisionNumber> myRevisionMap;
    @NotNull
    private final Map<VcsRevisionNumber, String> myCommitMessageMap = new HashMap<VcsRevisionNumber, String>();
    private final LineAnnotationAspect DATE_ASPECT = new GitAnnotationAspect("Date", VcsBundle.message((String)"line.annotation.aspect.date", (Object[])new Object[0]), true){

        @Override
        public String doGetValue(LineInfo info) {
            Date date = GitFileAnnotation.getDate(info);
            return FileAnnotation.formatDate((Date)date);
        }
    };
    private final LineAnnotationAspect REVISION_ASPECT = new GitAnnotationAspect("Revision", VcsBundle.message((String)"line.annotation.aspect.revision", (Object[])new Object[0]), false){

        @Override
        protected String doGetValue(LineInfo lineInfo) {
            return lineInfo.getRevisionNumber().getShortRev();
        }
    };
    private final LineAnnotationAspect AUTHOR_ASPECT = new GitAnnotationAspect("Author", VcsBundle.message((String)"line.annotation.aspect.author", (Object[])new Object[0]), true){

        @Override
        protected String doGetValue(LineInfo lineInfo) {
            return VcsUserUtil.toExactString((VcsUser)lineInfo.getAuthorUser());
        }
    };

    public GitFileAnnotation(@NotNull Project project, @NotNull VirtualFile file, @Nullable VcsRevisionNumber revision, @NotNull List<LineInfo> lines) {
        super(project);
        this.myProject = project;
        this.myFile = file;
        this.myFilePath = VcsUtil.getFilePath((VirtualFile)file);
        this.myVcs = GitVcs.getInstance(this.myProject);
        this.myBaseRevision = revision;
        this.myLines = lines;
    }

    public LineAnnotationAspect @NotNull [] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    @NotNull
    private static Date getDate(LineInfo info) {
        VcsLogApplicationSettings logSettings = (VcsLogApplicationSettings)ApplicationManager.getApplication().getService(VcsLogApplicationSettings.class);
        return Boolean.TRUE.equals(logSettings.get(CommonUiProperties.PREFER_COMMIT_DATE)) ? info.getCommitterDate() : info.getAuthorDate();
    }

    @Nullable
    public String getAnnotatedContent() {
        try {
            ContentRevision revision = GitContentRevision.createRevision(this.myFilePath, this.myBaseRevision, this.myProject);
            return revision.getContent();
        }
        catch (VcsException e) {
            return null;
        }
    }

    @Nullable
    public List<VcsFileRevision> getRevisions() {
        return this.myRevisions;
    }

    public void setRevisions(@NotNull List<VcsFileRevision> revisions) {
        this.myRevisions = revisions;
        this.myRevisionMap = new Object2IntOpenHashMap();
        for (int i = 0; i < this.myRevisions.size(); ++i) {
            this.myRevisionMap.put((Object)this.myRevisions.get(i).getRevisionNumber(), i);
        }
    }

    public void setCommitMessage(@NotNull VcsRevisionNumber revisionNumber, @NotNull String message) {
        this.myCommitMessageMap.put(revisionNumber, message);
    }

    public int getLineCount() {
        return this.myLines.size();
    }

    @Nullable
    public LineInfo getLineInfo(int lineNumber) {
        if (this.lineNumberCheck(lineNumber)) {
            return null;
        }
        return this.myLines.get(lineNumber);
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, false);
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getHtmlToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, true);
    }

    @NlsContexts.Tooltip
    @Nullable
    private String getToolTip(int lineNumber, boolean asHtml) {
        Object commitMessage;
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        if (lineInfo == null) {
            return null;
        }
        AnnotationTooltipBuilder atb = new AnnotationTooltipBuilder(this.myProject, asHtml);
        GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
        atb.appendRevisionLine((VcsRevisionNumber)revisionNumber, it -> GitCommitTooltipLinkHandler.createLink(it.asString(), it));
        atb.appendLine(VcsBundle.message((String)"commit.description.tooltip.author", (Object[])new Object[]{VcsUserUtil.toExactString((VcsUser)lineInfo.getAuthorUser())}));
        atb.appendLine(VcsBundle.message((String)"commit.description.tooltip.date", (Object[])new Object[]{DateFormatUtil.formatDateTime((Date)GitFileAnnotation.getDate(lineInfo))}));
        if (!this.myFilePath.equals(lineInfo.getFilePath())) {
            String path = FileUtil.getLocationRelativeToUserHome((String)lineInfo.getFilePath().getPresentableUrl());
            atb.appendLine(VcsBundle.message((String)"commit.description.tooltip.path", (Object[])new Object[]{path}));
        }
        if ((commitMessage = this.getCommitMessage((VcsRevisionNumber)revisionNumber)) == null) {
            commitMessage = lineInfo.getSubject() + "\n...";
        }
        atb.appendCommitMessageBlock((String)commitMessage);
        return atb.toString();
    }

    @NlsSafe
    @Nullable
    public String getCommitMessage(@NotNull VcsRevisionNumber revisionNumber) {
        if (this.myRevisions != null && this.myRevisionMap != null && this.myRevisionMap.containsKey((Object)revisionNumber)) {
            VcsFileRevision fileRevision = this.myRevisions.get(this.myRevisionMap.getInt((Object)revisionNumber));
            return fileRevision.getCommitMessage();
        }
        return this.myCommitMessageMap.get(revisionNumber);
    }

    @Nullable
    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? lineInfo.getRevisionNumber() : null;
    }

    @Nullable
    public Date getLineDate(int lineNumber) {
        LineInfo lineInfo = this.getLineInfo(lineNumber);
        return lineInfo != null ? GitFileAnnotation.getDate(lineInfo) : null;
    }

    private boolean lineNumberCheck(int lineNumber) {
        return this.myLines.size() <= lineNumber || lineNumber < 0;
    }

    @NotNull
    public List<LineInfo> getLines() {
        return this.myLines;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    public VcsKey getVcsKey() {
        return GitVcs.getKey();
    }

    public boolean isBaseRevisionChanged(@NotNull VcsRevisionNumber number) {
        if (!this.myFile.isInLocalFileSystem()) {
            return false;
        }
        VcsRevisionNumber currentCurrentRevision = this.myVcs.getDiffProvider().getCurrentRevision(this.myFile);
        return this.myBaseRevision != null && !this.myBaseRevision.equals(currentCurrentRevision);
    }

    @NotNull
    public FileAnnotation.CurrentFileRevisionProvider getCurrentFileRevisionProvider() {
        return new GitCurrentFileRevisionProvider();
    }

    @NotNull
    public FileAnnotation.PreviousFileRevisionProvider getPreviousFileRevisionProvider() {
        return new GitPreviousFileRevisionProvider();
    }

    @NotNull
    public FileAnnotation.AuthorsMappingProvider getAuthorsMappingProvider() {
        return new GitAuthorsMappingProvider();
    }

    @NotNull
    public FileAnnotation.RevisionsOrderProvider getRevisionsOrderProvider() {
        return new GitRevisionsOrderProvider();
    }

    @NotNull
    public FileAnnotation.RevisionChangesProvider getRevisionsChangesProvider() {
        return new GitRevisionChangesProvider();
    }

    @NotNull
    public FileAnnotation.LineModificationDetailsProvider getLineModificationDetailsProvider() {
        return new GitLineModificationDetailsProvider();
    }

    private class GitLineModificationDetailsProvider
    implements FileAnnotation.LineModificationDetailsProvider {
        private GitLineModificationDetailsProvider() {
        }

        @Nullable
        public AnnotatedLineModificationDetails getDetails(int lineNumber) throws VcsException {
            LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
            if (lineInfo == null) {
                return null;
            }
            String afterContent = DefaultLineModificationDetailsProvider.loadRevision((Project)GitFileAnnotation.this.myProject, (VcsFileRevision)lineInfo.getFileRevision(), (FilePath)GitFileAnnotation.this.myFilePath);
            if (afterContent == null) {
                return null;
            }
            String beforeContent = DefaultLineModificationDetailsProvider.loadRevision((Project)GitFileAnnotation.this.myProject, (VcsFileRevision)lineInfo.getPreviousFileRevision(), (FilePath)GitFileAnnotation.this.myFilePath);
            int originalLineNumber = lineInfo.getOriginalLineNumber() - 1;
            return DefaultLineModificationDetailsProvider.createDetailsFor((String)beforeContent, (String)afterContent, (int)originalLineNumber);
        }
    }

    private class GitRevisionChangesProvider
    implements FileAnnotation.RevisionChangesProvider {
        private GitRevisionChangesProvider() {
        }

        @Nullable
        public Pair<? extends CommittedChangeList, FilePath> getChangesIn(int lineNumber) throws VcsException {
            LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
            if (lineInfo == null) {
                return null;
            }
            GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(GitFileAnnotation.this.myProject).getRepositoryForFile(lineInfo.getFilePath());
            if (repository == null) {
                return null;
            }
            GitCommittedChangeList changeList = GitCommittedChangeListProvider.getCommittedChangeList(GitFileAnnotation.this.myProject, repository.getRoot(), lineInfo.getRevisionNumber());
            return Pair.create((Object)((Object)changeList), (Object)lineInfo.getFilePath());
        }
    }

    private class GitRevisionsOrderProvider
    implements FileAnnotation.RevisionsOrderProvider {
        private final List<List<VcsRevisionNumber>> myOrderedRevisions = new ArrayList<List<VcsRevisionNumber>>();

        GitRevisionsOrderProvider() {
            ContainerUtil.KeyOrderedMultiMap dates = new ContainerUtil.KeyOrderedMultiMap();
            for (int i = 0; i < GitFileAnnotation.this.getLineCount(); ++i) {
                LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(i);
                if (lineInfo == null) continue;
                GitRevisionNumber number = lineInfo.getRevisionNumber();
                Date date = lineInfo.getCommitterDate();
                dates.putValue((Object)date, (Object)number);
            }
            NavigableSet orderedDates = dates.navigableKeySet();
            for (Date date : orderedDates.descendingSet()) {
                Collection revisionNumbers = dates.get((Object)date);
                this.myOrderedRevisions.add(new ArrayList(revisionNumbers));
            }
        }

        @NotNull
        public List<List<VcsRevisionNumber>> getOrderedRevisions() {
            return this.myOrderedRevisions;
        }
    }

    private class GitAuthorsMappingProvider
    implements FileAnnotation.AuthorsMappingProvider {
        private final Map<VcsRevisionNumber, String> myAuthorsMap = new HashMap<VcsRevisionNumber, String>();

        GitAuthorsMappingProvider() {
            for (int i = 0; i < GitFileAnnotation.this.getLineCount(); ++i) {
                LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(i);
                if (lineInfo == null || this.myAuthorsMap.containsKey(lineInfo.getRevisionNumber())) continue;
                this.myAuthorsMap.put((VcsRevisionNumber)lineInfo.getRevisionNumber(), lineInfo.getAuthor());
            }
        }

        @NotNull
        public Map<VcsRevisionNumber, String> getAuthors() {
            return this.myAuthorsMap;
        }
    }

    private class GitPreviousFileRevisionProvider
    implements FileAnnotation.PreviousFileRevisionProvider {
        private GitPreviousFileRevisionProvider() {
        }

        @Nullable
        public VcsFileRevision getPreviousRevision(int lineNumber) {
            int index;
            LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
            if (lineInfo == null) {
                return null;
            }
            VcsFileRevision previousFileRevision = lineInfo.getPreviousFileRevision();
            if (previousFileRevision != null) {
                return previousFileRevision;
            }
            GitRevisionNumber revisionNumber = lineInfo.getRevisionNumber();
            if (GitFileAnnotation.this.myRevisions != null && GitFileAnnotation.this.myRevisionMap != null && GitFileAnnotation.this.myRevisionMap.containsKey((Object)revisionNumber) && (index = GitFileAnnotation.this.myRevisionMap.getInt((Object)revisionNumber)) + 1 < GitFileAnnotation.this.myRevisions.size()) {
                return GitFileAnnotation.this.myRevisions.get(index + 1);
            }
            return null;
        }

        @Nullable
        public VcsFileRevision getLastRevision() {
            if (GitFileAnnotation.this.myBaseRevision instanceof GitRevisionNumber) {
                return new GitFileRevision(GitFileAnnotation.this.myProject, GitFileAnnotation.this.myFilePath, (GitRevisionNumber)GitFileAnnotation.this.myBaseRevision);
            }
            return (VcsFileRevision)ContainerUtil.getFirstItem(GitFileAnnotation.this.getRevisions());
        }
    }

    private class GitCurrentFileRevisionProvider
    implements FileAnnotation.CurrentFileRevisionProvider {
        private GitCurrentFileRevisionProvider() {
        }

        @Nullable
        public VcsFileRevision getRevision(int lineNumber) {
            LineInfo lineInfo = GitFileAnnotation.this.getLineInfo(lineNumber);
            return lineInfo != null ? lineInfo.getFileRevision() : null;
        }
    }

    public static class LineInfo {
        @NotNull
        private final CommitInfo myCommitInfo;
        private final int myLineNumber;
        private final int myOriginalLineNumber;

        LineInfo(@NotNull CommitInfo commitInfo, int lineNumber, int originalLineNumber) {
            this.myCommitInfo = commitInfo;
            this.myLineNumber = lineNumber;
            this.myOriginalLineNumber = originalLineNumber;
        }

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public int getOriginalLineNumber() {
            return this.myOriginalLineNumber;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            return this.myCommitInfo.getRevisionNumber();
        }

        @NotNull
        public FilePath getFilePath() {
            return this.myCommitInfo.getFilePath();
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            return this.myCommitInfo.getFileRevision();
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            return this.myCommitInfo.getPreviousFileRevision();
        }

        @NotNull
        public Date getCommitterDate() {
            return this.myCommitInfo.getCommitterDate();
        }

        @NotNull
        public Date getAuthorDate() {
            return this.myCommitInfo.getAuthorDate();
        }

        @NotNull
        @Nls
        public String getAuthor() {
            return this.myCommitInfo.getAuthor();
        }

        @NotNull
        public VcsUser getAuthorUser() {
            return this.myCommitInfo.getAuthorUser();
        }

        @NlsSafe
        @NotNull
        public String getSubject() {
            return this.myCommitInfo.getSubject();
        }
    }

    static class CommitInfo {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitRevisionNumber myRevision;
        @NotNull
        private final FilePath myFilePath;
        @Nullable
        private final GitRevisionNumber myPreviousRevision;
        @Nullable
        private final FilePath myPreviousFilePath;
        @NotNull
        private final Date myCommitterDate;
        @NotNull
        private final Date myAuthorDate;
        @NotNull
        private final VcsUser myAuthor;
        @NotNull
        @NlsSafe
        private final String mySubject;

        CommitInfo(@NotNull Project project, @NotNull GitRevisionNumber revision, @NotNull FilePath path, @NotNull Date committerDate, @NotNull Date authorDate, @NotNull VcsUser author, @NotNull @NlsSafe String subject, @Nullable GitRevisionNumber previousRevision, @Nullable FilePath previousPath) {
            this.myProject = project;
            this.myRevision = revision;
            this.myFilePath = path;
            this.myPreviousRevision = previousRevision;
            this.myPreviousFilePath = previousPath;
            this.myCommitterDate = committerDate;
            this.myAuthorDate = authorDate;
            this.myAuthor = author;
            this.mySubject = subject;
        }

        @NotNull
        public GitRevisionNumber getRevisionNumber() {
            return this.myRevision;
        }

        @NotNull
        public FilePath getFilePath() {
            return this.myFilePath;
        }

        @NotNull
        public VcsFileRevision getFileRevision() {
            return new GitFileRevision(this.myProject, this.myFilePath, this.myRevision);
        }

        @Nullable
        public VcsFileRevision getPreviousFileRevision() {
            if (this.myPreviousRevision == null || this.myPreviousFilePath == null) {
                return null;
            }
            return new GitFileRevision(this.myProject, this.myPreviousFilePath, this.myPreviousRevision);
        }

        @NotNull
        public Date getCommitterDate() {
            return this.myCommitterDate;
        }

        @NotNull
        public Date getAuthorDate() {
            return this.myAuthorDate;
        }

        @NotNull
        @Nls
        public String getAuthor() {
            return this.myAuthor.getName();
        }

        @NotNull
        public VcsUser getAuthorUser() {
            return this.myAuthor;
        }

        @NotNull
        @Nls
        public String getSubject() {
            return this.mySubject;
        }
    }

    private abstract class GitAnnotationAspect
    extends LineAnnotationAspectAdapter {
        GitAnnotationAspect(@NlsContexts.ListItem String id, String displayName, boolean showByDefault) {
            super(id, displayName, showByDefault);
        }

        public String getValue(int lineNumber) {
            if (GitFileAnnotation.this.lineNumberCheck(lineNumber)) {
                return "";
            }
            return this.doGetValue(GitFileAnnotation.this.myLines.get(lineNumber));
        }

        protected abstract String doGetValue(LineInfo var1);

        protected void showAffectedPaths(int lineNum) {
            if (lineNum >= 0 && lineNum < GitFileAnnotation.this.myLines.size()) {
                CompletableFuture shownInLog;
                LineInfo info = GitFileAnnotation.this.myLines.get(lineNum);
                VirtualFile root = ProjectLevelVcsManager.getInstance((Project)GitFileAnnotation.this.myProject).getVcsRootFor(GitFileAnnotation.this.myFilePath);
                if (root == null) {
                    return;
                }
                if (ModalityState.current() == ModalityState.NON_MODAL && Registry.is((String)"vcs.blame.show.affected.files.in.log")) {
                    Hash hash = HashImpl.build((String)info.getRevisionNumber().asString());
                    shownInLog = VcsLogNavigationUtil.jumpToRevisionAsync((Project)GitFileAnnotation.this.myProject, (VirtualFile)root, (Hash)hash, (FilePath)info.getFilePath());
                } else {
                    shownInLog = CompletableFuture.completedFuture(false);
                }
                shownInLog.whenCompleteAsync((success, ex) -> {
                    if (ex instanceof CancellationException) {
                        return;
                    }
                    if (ex != null) {
                        LOG.error(ex);
                    }
                    if (!Boolean.TRUE.equals(success)) {
                        AbstractVcsHelperImpl.loadAndShowCommittedChangesDetails((Project)GitFileAnnotation.this.myProject, (VcsRevisionNumber)info.getRevisionNumber(), (FilePath)GitFileAnnotation.this.myFilePath, (boolean)false, () -> GitFileAnnotation.this.getRevisionsChangesProvider().getChangesIn(lineNum));
                    }
                }, (Executor)EdtExecutorService.getInstance());
            }
        }
    }
}

