/*
 * Decompiled with CFR 0.152.
 */
package git4idea.annotate;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import git4idea.actions.GitToggleAnnotationOptionsActionProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import org.jetbrains.annotations.NotNull;

public final class GitAnnotationsListener {
    public static void registerListener(final @NotNull Project project, @NotNull Disposable disposable) {
        project.getMessageBus().connect(disposable).subscribe(GitRepository.GIT_REPO_CHANGE, (Object)new GitRepositoryChangeListener(){

            @Override
            public void repositoryChanged(@NotNull GitRepository repository) {
                VcsAnnotationRefresher refresher = (VcsAnnotationRefresher)BackgroundTaskUtil.syncPublisher((Project)project, (Topic)VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED);
                refresher.dirtyUnder(repository.getRoot());
            }
        });
        VcsLogApplicationSettings logSettings = (VcsLogApplicationSettings)ApplicationManager.getApplication().getService(VcsLogApplicationSettings.class);
        VcsLogUiProperties.PropertiesChangeListener logSettingsListener = new VcsLogUiProperties.PropertiesChangeListener(){

            public <T> void onPropertyChanged(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                if (property.equals((Object)CommonUiProperties.PREFER_COMMIT_DATE)) {
                    GitToggleAnnotationOptionsActionProvider.resetAllAnnotations(project, false);
                }
            }
        };
        logSettings.addChangeListener(logSettingsListener);
        Disposer.register((Disposable)disposable, () -> logSettings.removeChangeListener(logSettingsListener));
    }
}

