/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.actions.GitRepositoryAction;
import git4idea.i18n.GitBundle;
import git4idea.ui.GitUnstashDialog;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitUnstash
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        return GitBundle.message("unstash.action.name", new Object[0]);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        AnActionEvent newEvent;
        AnAction showStashAction = ActionManager.getInstance().getAction("Git.Show.Stash");
        if (ActionUtil.lastUpdateAndCheckDumb((AnAction)showStashAction, (AnActionEvent)(newEvent = AnActionEvent.createFromDataContext((String)e.getPlace(), (Presentation)showStashAction.getTemplatePresentation().clone(), (DataContext)e.getDataContext())), (boolean)true)) {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)showStashAction, (AnActionEvent)newEvent);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager.isFreezedWithNotification(GitBundle.message("unstash.error.can.not.unstash.changes.now", new Object[0]))) {
            return;
        }
        GitUnstashDialog.showUnstashDialog(project, gitRoots, defaultRoot);
    }
}

