/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.actions.GitMergeAction;
import git4idea.branch.GitBranchPair;
import git4idea.commands.GitCommand;
import git4idea.commands.GitImpl;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVersionSpecialty;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.pull.GitPullDialog;
import git4idea.pull.GitPullOption;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateExecutionProcess;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitPull
extends GitMergeAction {
    private static final Logger LOG = Logger.getInstance(GitPull.class);
    @NonNls
    private static final String INTERACTIVE = "interactive";

    @Override
    @NotNull
    protected String getActionName() {
        return GitBundle.message("pull.action.name", new Object[0]);
    }

    @Override
    protected GitMergeAction.DialogState displayDialog(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        GitPullDialog dialog2 = new GitPullDialog(project, gitRoots, defaultRoot);
        if (!dialog2.showAndGet()) {
            return null;
        }
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRootQuick(dialog2.gitRoot());
        assert (repository != null) : "Repository can't be null for root " + dialog2.gitRoot();
        return new GitMergeAction.DialogState(dialog2.gitRoot(), GitBundle.message("pulling.title", dialog2.getSelectedRemote().getName()), this.getHandlerProvider(project, dialog2), dialog2.getSelectedBranch(), dialog2.isCommitAfterMerge(), ContainerUtil.map(dialog2.getSelectedOptions(), option -> option.getOption()));
    }

    @Override
    protected String getNotificationErrorDisplayId() {
        return "git.pull.failed";
    }

    @Override
    protected void perform(@NotNull GitMergeAction.DialogState dialogState, @NotNull Project project) {
        if (!dialogState.selectedOptions.contains(GitPullOption.REBASE.getOption())) {
            super.perform(dialogState, project);
        } else {
            GitPull.performRebase(project, dialogState);
        }
    }

    private static void performRebase(@NotNull Project project, GitMergeAction.DialogState dialogState) {
        VirtualFile selectedRoot = dialogState.selectedRoot;
        GitRemoteBranch selectedBranch = (GitRemoteBranch)dialogState.selectedBranch;
        GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRootQuick(selectedRoot);
        if (repository == null) {
            LOG.error("Unable to find git repository for root: " + selectedRoot.getPresentableUrl());
            return;
        }
        if (repository.getCurrentBranch() == null) {
            LOG.error("Unable to rebase operation since repository is not on a branch");
            return;
        }
        new GitUpdateExecutionProcess(project, Collections.singletonList(repository), Map.of(repository, new GitBranchPair(repository.getCurrentBranch(), selectedBranch)), UpdateMethod.REBASE, false).execute();
    }

    @Override
    protected boolean shouldSetupRebaseEditor(@NotNull Project project, VirtualFile selectedRoot) {
        String value = null;
        try {
            value = GitConfigUtil.getValue(project, selectedRoot, "pull.rebase");
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
        }
        return INTERACTIVE.equals(value);
    }

    @NotNull
    protected Supplier<GitLineHandler> getHandlerProvider(Project project, GitPullDialog dialog2) {
        GitRemote remote = dialog2.getSelectedRemote();
        String remoteName = remote.getName();
        VirtualFile root = dialog2.gitRoot();
        Set<GitPullOption> selectedOptions = dialog2.getSelectedOptions();
        GitRemoteBranch selectedBranch = dialog2.getSelectedBranch();
        return () -> {
            List<String> urls = remote.getUrls();
            GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.PULL, GitImpl.REBASE_CONFIG_PARAMS);
            h2.setUrls(urls);
            h2.addParameters("--no-stat");
            for (GitPullOption option : selectedOptions) {
                h2.addParameters(option.getOption());
            }
            h2.addParameters("-v");
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(project)) {
                h2.addParameters("--progress");
            }
            h2.addParameters(remoteName);
            h2.addParameters(selectedBranch.getNameForRemoteOperations());
            return h2;
        };
    }
}

