/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import org.jetbrains.annotations.NotNull;

public class GitFetch
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            e.getPresentation().setEnabled(GitBranchActionsUtilKt.hasRemotes(project));
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitVcs.runInBackground(new Task.Backgroundable(project, GitBundle.message("fetching", new Object[0]), true){
            GitFetchResult result;

            public void run(@NotNull ProgressIndicator indicator) {
                this.result = GitFetchSupport.fetchSupport(project).fetchAllRemotes(GitUtil.getRepositories(project));
            }

            public void onFinished() {
                if (this.result != null) {
                    GitFetch.this.onFetchFinished(this.result);
                }
            }
        });
    }

    @RequiresEdt
    protected void onFetchFinished(@NotNull GitFetchResult result2) {
        result2.showNotification();
    }
}

