/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.BlobIndexUtil;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import java.util.Date;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitRevisionNumber
implements ShortVcsRevisionNumber {
    public static final String NOT_COMMITTED_HASH = BlobIndexUtil.NOT_COMMITTED_HASH;
    public static final GitRevisionNumber HEAD = new GitRevisionNumber("HEAD");
    @NotNull
    private final String myRevisionHash;
    @NotNull
    private final Date myTimestamp;
    private static final Logger LOG = Logger.getInstance(GitRevisionNumber.class);

    public GitRevisionNumber(@NonNls @NotNull String version) {
        this.myRevisionHash = version;
        this.myTimestamp = new Date();
    }

    public GitRevisionNumber(@NotNull String version, @NotNull Date timeStamp) {
        this.myTimestamp = timeStamp;
        this.myRevisionHash = version;
    }

    @NotNull
    public String asString() {
        return this.myRevisionHash;
    }

    public String toShortString() {
        return DvcsUtil.getShortHash((String)this.myRevisionHash);
    }

    @NotNull
    public Date getTimestamp() {
        return this.myTimestamp;
    }

    @NotNull
    public String getRev() {
        return this.myRevisionHash;
    }

    @NotNull
    public String getShortRev() {
        return this.toShortString();
    }

    public int compareTo(VcsRevisionNumber crev) {
        if (this == crev) {
            return 0;
        }
        if (crev instanceof GitRevisionNumber) {
            int tildeIndex;
            GitRevisionNumber other = (GitRevisionNumber)crev;
            if (this.myRevisionHash.equals(other.myRevisionHash)) {
                return 0;
            }
            if (other.myRevisionHash.indexOf("[") > 0) {
                return this.myTimestamp.compareTo(other.myTimestamp);
            }
            String otherName = null;
            String thisName = null;
            int otherParents = -1;
            int thisParent = -1;
            if (other.myRevisionHash.contains("~")) {
                tildeIndex = other.myRevisionHash.indexOf(126);
                otherName = other.myRevisionHash.substring(0, tildeIndex);
                otherParents = Integer.parseInt(other.myRevisionHash.substring(tildeIndex));
            }
            if (this.myRevisionHash.contains("~")) {
                tildeIndex = this.myRevisionHash.indexOf(126);
                thisName = this.myRevisionHash.substring(0, tildeIndex);
                thisParent = Integer.parseInt(this.myRevisionHash.substring(tildeIndex));
            }
            if (otherName == null && thisName == null) {
                int result2 = this.myTimestamp.compareTo(other.myTimestamp);
                if (result2 == 0) {
                    return this.myRevisionHash.compareTo(other.myRevisionHash);
                }
                return result2;
            }
            if (otherName == null) {
                return 1;
            }
            if (thisName == null) {
                return -1;
            }
            return thisParent - otherParents;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitRevisionNumber test = (GitRevisionNumber)obj;
        return this.myRevisionHash.equals(test.myRevisionHash);
    }

    public int hashCode() {
        return this.myRevisionHash.hashCode();
    }

    @NotNull
    public static GitRevisionNumber resolve(Project project, VirtualFile vcsRoot, @NonNls String rev) throws VcsException {
        GitLineHandler h2 = new GitLineHandler(project, vcsRoot, GitCommand.REV_LIST);
        h2.setSilent(true);
        h2.addParameters("--timestamp", "--max-count=1", rev);
        h2.endOptions();
        String output = Git.getInstance().runCommand(h2).getOutputOrThrow(new int[0]);
        return GitRevisionNumber.parseRevlistOutputAsRevisionNumber(h2, output);
    }

    @NotNull
    public static GitRevisionNumber parseRevlistOutputAsRevisionNumber(@NotNull GitHandler h2, @NotNull String output) throws VcsException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(output, "\n\r \t", false);
            LOG.assertTrue(tokenizer.hasMoreTokens(), (Object)("No required tokens in the output: \n" + output));
            Date timestamp = GitUtil.parseTimestampWithNFEReport(tokenizer.nextToken(), h2, output);
            return new GitRevisionNumber(tokenizer.nextToken(), timestamp);
        }
        catch (Exception e) {
            throw new VcsException(GitBundle.message("revision.number.cannot.parse.output", output), (Throwable)e);
        }
    }

    public String toString() {
        return this.myRevisionHash;
    }
}

