/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.diff.GitSubmoduleContentRevision;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitContentRevision
implements ByteBackedContentRevision {
    @NotNull
    protected final FilePath myFile;
    @NotNull
    private final GitRevisionNumber myRevision;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Charset myCharset;

    protected GitContentRevision(@NotNull FilePath file, @NotNull GitRevisionNumber revision, @NotNull Project project, @Nullable Charset charset) {
        this.myProject = project;
        this.myFile = file;
        this.myRevision = revision;
        this.myCharset = charset;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    @Nullable
    public String getContent() throws VcsException {
        byte[] bytes = this.getContentAsBytes();
        if (bytes == null) {
            return null;
        }
        return ContentRevisionCache.getAsString((byte[])bytes, (FilePath)this.myFile, (Charset)this.myCharset);
    }

    public byte @Nullable [] getContentAsBytes() throws VcsException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        try {
            if (!GitUtil.isHashString(this.myRevision.getRev())) {
                return ContentRevisionCache.loadAsBytes((FilePath)this.myFile, this::loadContent);
            }
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myProject, (FilePath)this.myFile, (VcsRevisionNumber)this.myRevision, (VcsKey)GitVcs.getKey(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, this::loadContent);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private byte @NotNull [] loadContent() throws VcsException {
        VirtualFile root = GitUtil.getRootForFile(this.myProject, this.myFile);
        return GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myFile));
    }

    @NotNull
    public FilePath getFile() {
        return this.myFile;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevision;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitContentRevision test = (GitContentRevision)obj;
        return this.myFile.equals(test.myFile) && this.myRevision.equals(test.myRevision);
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myRevision.hashCode();
    }

    @Nullable
    public static GitSubmodule getRepositoryIfSubmodule(@NotNull Project project, @NotNull FilePath path) {
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        GitRepository candidate = (GitRepository)repositoryManager.getRepositoryForRootQuick(path);
        if (candidate == null) {
            return null;
        }
        return GitSubmoduleKt.asSubmodule(candidate);
    }

    @NotNull
    public static ContentRevision createRevisionForTypeChange(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project) {
        if (revisionNumber == null) {
            File file = filePath.getIOFile();
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (virtualFile != null) {
                filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
            }
        }
        return GitContentRevision.createRevision(filePath, revisionNumber, project);
    }

    @NotNull
    public static FilePath createPathFromEscaped(@NotNull VirtualFile vcsRoot, @NotNull String path) throws VcsException {
        return GitContentRevision.createPathFromEscaped(vcsRoot, path, false);
    }

    @NotNull
    public static FilePath createPathFromEscaped(@NotNull VirtualFile vcsRoot, @NotNull String path, boolean isDirectory) throws VcsException {
        String absolutePath = GitContentRevision.makeAbsolutePath(vcsRoot, GitUtil.unescapePath(path));
        return VcsUtil.getFilePath((String)absolutePath, (boolean)isDirectory);
    }

    @NotNull
    public static FilePath createPath(@NotNull VirtualFile vcsRoot, @NotNull String unescapedPath) {
        return GitContentRevision.createPath(vcsRoot, unescapedPath, false);
    }

    @NotNull
    public static FilePath createPath(@NotNull VirtualFile vcsRoot, @NotNull String unescapedPath, boolean isDirectory) {
        String absolutePath = GitContentRevision.makeAbsolutePath(vcsRoot, unescapedPath);
        return VcsUtil.getFilePath((String)absolutePath, (boolean)isDirectory);
    }

    @NotNull
    private static String makeAbsolutePath(@NotNull VirtualFile vcsRoot, @NotNull String unescapedPath) {
        return vcsRoot.getPath() + "/" + unescapedPath;
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project) {
        return GitContentRevision.createRevision(filePath, revisionNumber, project, null);
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project, @Nullable Charset charset) {
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, filePath);
        if (revisionNumber != null && revisionNumber != VcsRevisionNumber.NULL) {
            if (submodule != null) {
                return GitSubmoduleContentRevision.createRevision(submodule, revisionNumber);
            }
            return new GitContentRevision(filePath, (GitRevisionNumber)revisionNumber, project, charset);
        }
        if (submodule != null) {
            return GitSubmoduleContentRevision.createCurrentRevision(submodule.getRepository());
        }
        return new CurrentContentRevision(filePath);
    }

    public String toString() {
        return this.myFile.getPath();
    }
}

