/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.annotation.SystemApi;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.reflect.Method;
import java.util.Locale;
import libcore.icu.DecimalFormatData;
import libcore.icu.ICU;
import libcore.icu.SimpleDateFormatData;
import sun.util.locale.BaseLocale;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
public class ZygoteHooks {
    private static long token;
    private static Method enableMemoryMappedDataMethod;
    private static boolean inZygoteProcess;

    private ZygoteHooks() {
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void startZygoteNoThreadCreation() {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#startZygoteNoThreadCreation()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void onBeginPreload() {
        com.android.i18n.system.ZygoteHooks.onBeginPreload();
        ICU.initializeCacheInZygote();
        DecimalFormatData.initializeCacheInZygote();
        SimpleDateFormatData.initializeCacheInZygote();
        try {
            Class<?> jacocoOfflineClass = Class.forName("org.jacoco.agent.rt.internal.Offline");
            enableMemoryMappedDataMethod = jacocoOfflineClass.getMethod("enableMemoryMappedData", new Class[0]);
        }
        catch (ClassNotFoundException jacocoOfflineClass) {
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void onEndPreload() {
        com.android.i18n.system.ZygoteHooks.onEndPreload();
        FileDescriptor.in.cloneForFork();
        FileDescriptor.out.cloneForFork();
        FileDescriptor.err.cloneForFork();
    }

    private static void cleanLocaleCaches() {
        BaseLocale.cleanCache();
        Locale.cleanCache();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void gcAndFinalize() {
        VMRuntime runtime = VMRuntime.getRuntime();
        System.gc();
        runtime.runFinalizationSync();
        ZygoteHooks.cleanLocaleCaches();
        System.gc();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void stopZygoteNoThreadCreation() {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#stopZygoteNoThreadCreation()V", true, null);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void preFork() {
        Daemons.stop();
        token = ZygoteHooks.nativePreFork();
        ZygoteHooks.waitUntilAllThreadsStopped();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void postForkSystemServer(int runtimeFlags) {
        ZygoteHooks.nativePostForkSystemServer(runtimeFlags);
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void postForkChild(int runtimeFlags, boolean isSystemServer, boolean isChildZygote, String instructionSet) {
        ZygoteHooks.nativePostForkChild(token, runtimeFlags, isSystemServer, isChildZygote, instructionSet);
        if (!isChildZygote) {
            inZygoteProcess = false;
        }
        Math.setRandomSeedInternal((long)System_Delegate.currentTimeMillis());
        if (!isSystemServer && enableMemoryMappedDataMethod != null) {
            try {
                enableMemoryMappedDataMethod.invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static void postForkCommon() {
        ZygoteHooks.nativePostZygoteFork();
        Daemons.startPostZygoteFork();
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static boolean isIndefiniteThreadSuspensionSafe() {
        return ZygoteHooks.nativeZygoteLongSuspendOk();
    }

    public static boolean inZygote() {
        return inZygoteProcess;
    }

    private static void nativePostForkSystemServer(int n) {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#nativePostForkSystemServer(I)V", true, null);
    }

    private static long nativePreFork() {
        return OverrideMethod.invokeL("dalvik.system.ZygoteHooks#nativePreFork()J", true, null);
    }

    private static void nativePostZygoteFork() {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#nativePostZygoteFork()V", true, null);
    }

    private static void nativePostForkChild(long l, int n, boolean bl, boolean bl2, String string2) {
        OverrideMethod.invokeV("dalvik.system.ZygoteHooks#nativePostForkChild(JIZZLjava/lang/String;)V", true, null);
    }

    private static boolean nativeZygoteLongSuspendOk() {
        return OverrideMethod.invokeI("dalvik.system.ZygoteHooks#nativeZygoteLongSuspendOk()Z", true, null) != 0;
    }

    private static void waitUntilAllThreadsStopped() {
        File tasks = new File("/proc/self/task");
        while (tasks.list().length > 1) {
            Thread.yield();
        }
    }

    static {
        inZygoteProcess = true;
    }
}

