/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.ocr;

import com.google.android.apps.common.testing.accessibility.framework.ocr.TextComponent;
import com.google.android.apps.common.testing.accessibility.framework.proto.AccessibilityEvaluationProtos;
import com.google.common.collect.ImmutableList;
import org.checkerframework.checker.nullness.qual.Nullable;

public class OcrResult {
    public static final OcrResult EMPTY_RESULT = new OcrResult((ImmutableList<TextComponent>)ImmutableList.of());
    private final ImmutableList<TextComponent> texts;

    public OcrResult(ImmutableList<TextComponent> texts) {
        this.texts = texts;
    }

    public OcrResult(AccessibilityEvaluationProtos.OcrResultProto ocrResultProto) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int i = 0; i < ocrResultProto.getTextsCount(); ++i) {
            builder.add((Object)new TextComponent(ocrResultProto.getTexts(i)));
        }
        this.texts = builder.build();
    }

    public ImmutableList<TextComponent> getTexts() {
        return this.texts;
    }

    public AccessibilityEvaluationProtos.OcrResultProto toProto() {
        AccessibilityEvaluationProtos.OcrResultProto.Builder builder = AccessibilityEvaluationProtos.OcrResultProto.newBuilder();
        for (TextComponent text : this.texts) {
            builder.addTexts(text.toProto());
        }
        return (AccessibilityEvaluationProtos.OcrResultProto)builder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OcrResult)) {
            return false;
        }
        OcrResult that = (OcrResult)o;
        return this.texts.equals(that.getTexts());
    }

    public int hashCode() {
        return this.texts.hashCode();
    }
}

