/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.integrations.espresso;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultDescriptor;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Locale;

public class AccessibilityViewCheckException
extends com.google.android.apps.common.testing.accessibility.framework.integrations.AccessibilityViewCheckException {
    private final AccessibilityCheckResultDescriptor resultDescriptor;

    public AccessibilityViewCheckException(List<AccessibilityViewCheckResult> results) {
        this(results, new AccessibilityCheckResultDescriptor());
    }

    public AccessibilityViewCheckException(List<AccessibilityViewCheckResult> results, AccessibilityCheckResultDescriptor resultDescriptor) {
        super(results);
        Preconditions.checkArgument((results != null && !results.isEmpty() ? 1 : 0) != 0, (Object)"AccessibilityViewCheckException requires at least 1 AccessibilityViewCheckResult");
        this.resultDescriptor = (AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)resultDescriptor);
    }

    @Override
    public String getMessage() {
        List<AccessibilityViewCheckResult> results = this.getResults();
        StringBuilder exceptionMessage = new StringBuilder();
        String resultCountMessage = results.size() == 1 ? "There was 1 accessibility result:\n" : String.format(Locale.US, "There were %d accessibility results:\n", results.size());
        exceptionMessage.append(resultCountMessage);
        for (int i = 0; i < results.size(); ++i) {
            if (i > 0) {
                exceptionMessage.append(",\n");
            }
            exceptionMessage.append(this.resultDescriptor.describeResult(results.get(i)));
        }
        return exceptionMessage.toString();
    }
}

