/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework;

import com.android.layoutlib.protobuf.ByteString;
import com.google.android.apps.common.testing.accessibility.framework.ResultMetadata;
import com.google.android.apps.common.testing.accessibility.framework.proto.AccessibilityEvaluationProtos;
import com.google.common.base.Preconditions;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class HashMapResultMetadata
implements ResultMetadata {
    protected final Map<String, TypedValue> map;

    public HashMapResultMetadata() {
        this.map = new HashMap<String, TypedValue>();
    }

    protected HashMapResultMetadata(HashMapResultMetadata metadata) {
        this.map = new HashMap<String, TypedValue>(metadata.map);
    }

    @Override
    public HashMapResultMetadata clone() {
        return new HashMapResultMetadata(this);
    }

    @Override
    public boolean getBoolean(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.BOOLEAN != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.BOOLEAN, tv.type);
        }
        return (Boolean)tv.value;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.BOOLEAN != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.BOOLEAN, tv.type);
        }
        return (Boolean)tv.value;
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.map.put(key, new TypedValue(TypedValue.Type.BOOLEAN, value));
    }

    @Override
    public byte getByte(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.BYTE != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.BYTE, tv.type);
        }
        return (Byte)tv.value;
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.BYTE != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.BYTE, tv.type);
        }
        return (Byte)tv.value;
    }

    @Override
    public void putByte(String key, byte value) {
        this.map.put(key, new TypedValue(TypedValue.Type.BYTE, value));
    }

    @Override
    public short getShort(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.SHORT != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.SHORT, tv.type);
        }
        return (Short)tv.value;
    }

    @Override
    public short getShort(String key, short defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.SHORT != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.SHORT, tv.type);
        }
        return (Short)tv.value;
    }

    @Override
    public void putShort(String key, short value) {
        this.map.put(key, new TypedValue(TypedValue.Type.SHORT, value));
    }

    @Override
    public char getChar(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.CHAR != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.CHAR, tv.type);
        }
        return ((Character)tv.value).charValue();
    }

    @Override
    public char getChar(String key, char defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.CHAR != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.CHAR, tv.type);
        }
        return ((Character)tv.value).charValue();
    }

    @Override
    public void putChar(String key, char value) {
        this.map.put(key, new TypedValue(TypedValue.Type.CHAR, Character.valueOf(value)));
    }

    @Override
    public int getInt(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.INT != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.INT, tv.type);
        }
        return (Integer)tv.value;
    }

    @Override
    public int getInt(String key, int defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.INT != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.INT, tv.type);
        }
        return (Integer)tv.value;
    }

    @Override
    public void putInt(String key, int value) {
        this.map.put(key, new TypedValue(TypedValue.Type.INT, value));
    }

    @Override
    public float getFloat(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.FLOAT != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.FLOAT, tv.type);
        }
        return ((Float)tv.value).floatValue();
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.FLOAT != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.FLOAT, tv.type);
        }
        return ((Float)tv.value).floatValue();
    }

    @Override
    public void putFloat(String key, float value) {
        this.map.put(key, new TypedValue(TypedValue.Type.FLOAT, Float.valueOf(value)));
    }

    @Override
    public long getLong(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.LONG != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.LONG, tv.type);
        }
        return (Long)tv.value;
    }

    @Override
    public long getLong(String key, long defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.LONG != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.LONG, tv.type);
        }
        return (Long)tv.value;
    }

    @Override
    public void putLong(String key, long value) {
        this.map.put(key, new TypedValue(TypedValue.Type.LONG, value));
    }

    @Override
    public double getDouble(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.DOUBLE != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.DOUBLE, tv.type);
        }
        return (Double)tv.value;
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.DOUBLE != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.DOUBLE, tv.type);
        }
        return (Double)tv.value;
    }

    @Override
    public void putDouble(String key, double value) {
        this.map.put(key, new TypedValue(TypedValue.Type.DOUBLE, value));
    }

    @Override
    public String getString(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.STRING != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.STRING, tv.type);
        }
        return (String)tv.value;
    }

    @Override
    public String getString(String key, String defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.STRING != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.STRING, tv.type);
        }
        return (String)tv.value;
    }

    @Override
    public void putString(String key, String value) {
        this.map.put(key, new TypedValue(TypedValue.Type.STRING, value));
    }

    @Override
    public ImmutableList<String> getStringList(String key) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (TypedValue.Type.STRING_LIST != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.STRING_LIST, tv.type);
        }
        return (ImmutableList)tv.value;
    }

    @Override
    public ImmutableList<String> getStringList(String key, ImmutableList<String> defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            return defaultValue;
        }
        if (TypedValue.Type.STRING_LIST != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, TypedValue.Type.STRING_LIST, tv.type);
        }
        return (ImmutableList)tv.value;
    }

    @Override
    public void putStringList(String key, List<String> value) {
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0);
        this.map.put(key, new TypedValue(TypedValue.Type.STRING_LIST, ImmutableList.copyOf(value)));
    }

    @Override
    public ImmutableList<Integer> getIntegerList(String key) {
        return this.getValue(key, TypedValue.Type.INTEGER_LIST, null);
    }

    @Override
    public ImmutableList<Integer> getIntegerList(String key, ImmutableList<Integer> defaultValue) {
        return this.getValue(key, TypedValue.Type.INTEGER_LIST, defaultValue);
    }

    @Override
    public void putIntegerList(String key, List<Integer> value) {
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0);
        this.map.put(key, new TypedValue(TypedValue.Type.INTEGER_LIST, ImmutableList.copyOf(value)));
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public static HashMapResultMetadata fromProto(AccessibilityEvaluationProtos.MetadataProto proto) {
        HashMapResultMetadata metadata = new HashMapResultMetadata();
        for (Map.Entry<String, AccessibilityEvaluationProtos.TypedValueProto> entry : proto.getMetadataMapMap().entrySet()) {
            metadata.map.put(entry.getKey(), new TypedValue(entry.getValue()));
        }
        return metadata;
    }

    public AccessibilityEvaluationProtos.MetadataProto toProto() {
        AccessibilityEvaluationProtos.MetadataProto.Builder builder = AccessibilityEvaluationProtos.MetadataProto.newBuilder();
        for (Map.Entry<String, TypedValue> entry : this.map.entrySet()) {
            builder.putMetadataMap(entry.getKey(), entry.getValue().toProto());
        }
        return (AccessibilityEvaluationProtos.MetadataProto)builder.build();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashMapResultMetadata)) {
            return false;
        }
        HashMapResultMetadata metadata = (HashMapResultMetadata)o;
        return this.map.equals(metadata.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return new TreeMap<String, TypedValue>(this.map).toString();
    }

    private <T> T getValue(String key, TypedValue.Type type, @Nullable T defaultValue) {
        TypedValue tv = this.map.get(key);
        if (tv == null) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw HashMapResultMetadata.invalidKeyException(key);
        }
        if (type != tv.type) {
            throw HashMapResultMetadata.invalidTypeException(key, type, tv.type);
        }
        return (T)tv.value;
    }

    private static NoSuchElementException invalidKeyException(String key) {
        return new NoSuchElementException("No HashMapResultMetadata element found for key '" + key + "'.");
    }

    private static ClassCastException invalidTypeException(String key, TypedValue.Type requestedType, TypedValue.Type foundType) {
        return new ClassCastException("Invalid type '" + requestedType.name() + "' requested from HashMapResultMetadata for key '" + key + "'.  Found type '" + foundType.name() + "' instead.");
    }

    protected static class TypedValue {
        private static final EnumBiMap<Type, AccessibilityEvaluationProtos.TypedValueProto.TypeProto> TYPE_MAP = EnumBiMap.create((Map)ImmutableMap.builder().put((Object)Type.BOOLEAN, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.BOOLEAN).put((Object)Type.BYTE, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.BYTE).put((Object)Type.SHORT, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.SHORT).put((Object)Type.CHAR, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.CHAR).put((Object)Type.INT, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.INT).put((Object)Type.FLOAT, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.FLOAT).put((Object)Type.LONG, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.LONG).put((Object)Type.DOUBLE, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.DOUBLE).put((Object)Type.STRING, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.STRING).put((Object)Type.STRING_LIST, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.STRING_LIST).put((Object)Type.INTEGER_LIST, (Object)AccessibilityEvaluationProtos.TypedValueProto.TypeProto.INT_LIST).buildOrThrow());
        public Type type;
        public Object value;

        public TypedValue(Type type, Object value) {
            this.type = type;
            this.value = value;
        }

        public TypedValue(AccessibilityEvaluationProtos.TypedValueProto proto) {
            this.type = Type.fromProto(proto.getType());
            switch (this.type) {
                case BOOLEAN: {
                    this.value = proto.getBooleanValue();
                    break;
                }
                case BYTE: {
                    this.value = proto.getByteValue().asReadOnlyByteBuffer().get();
                    break;
                }
                case SHORT: {
                    this.value = proto.getShortValue().asReadOnlyByteBuffer().getShort();
                    break;
                }
                case CHAR: {
                    this.value = Character.valueOf(proto.getCharValue().asReadOnlyByteBuffer().getChar());
                    break;
                }
                case INT: {
                    this.value = proto.getIntValue();
                    break;
                }
                case FLOAT: {
                    this.value = Float.valueOf(proto.getFloatValue());
                    break;
                }
                case LONG: {
                    this.value = proto.getLongValue();
                    break;
                }
                case DOUBLE: {
                    this.value = proto.getDoubleValue();
                    break;
                }
                case STRING: {
                    this.value = proto.getStringValue();
                    break;
                }
                case STRING_LIST: {
                    this.value = ImmutableList.copyOf(proto.getStringListValue().getValuesList());
                    break;
                }
                case INTEGER_LIST: {
                    this.value = ImmutableList.copyOf(proto.getIntListValue().getValuesList());
                }
            }
        }

        public AccessibilityEvaluationProtos.TypedValueProto toProto() {
            AccessibilityEvaluationProtos.TypedValueProto.Builder builder = AccessibilityEvaluationProtos.TypedValueProto.newBuilder();
            builder.setType(this.type.toProto());
            switch (this.type) {
                case BOOLEAN: {
                    builder.setBooleanValue((Boolean)this.value);
                    break;
                }
                case BYTE: {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(1);
                    byteBuffer.put((Byte)this.value).flip();
                    builder.setByteValue(ByteString.copyFrom(byteBuffer));
                    break;
                }
                case SHORT: {
                    ByteBuffer shortBuffer = ByteBuffer.allocate(2);
                    shortBuffer.putShort((Short)this.value).flip();
                    builder.setShortValue(ByteString.copyFrom(shortBuffer));
                    break;
                }
                case CHAR: {
                    ByteBuffer charBuffer = ByteBuffer.allocate(2);
                    charBuffer.putChar(((Character)this.value).charValue()).flip();
                    builder.setCharValue(ByteString.copyFrom(charBuffer));
                    break;
                }
                case INT: {
                    builder.setIntValue((Integer)this.value);
                    break;
                }
                case FLOAT: {
                    builder.setFloatValue(((Float)this.value).floatValue());
                    break;
                }
                case LONG: {
                    builder.setLongValue((Long)this.value);
                    break;
                }
                case DOUBLE: {
                    builder.setDoubleValue((Double)this.value);
                    break;
                }
                case STRING: {
                    builder.setStringValue((String)this.value);
                    break;
                }
                case STRING_LIST: {
                    builder.setStringListValue((AccessibilityEvaluationProtos.StringListProto)AccessibilityEvaluationProtos.StringListProto.newBuilder().addAllValues((Iterable<String>)((ImmutableList)this.value)).build());
                    break;
                }
                case INTEGER_LIST: {
                    builder.setIntListValue((AccessibilityEvaluationProtos.IntListProto)AccessibilityEvaluationProtos.IntListProto.newBuilder().addAllValues((Iterable<? extends Integer>)((ImmutableList)this.value)).build());
                }
            }
            return (AccessibilityEvaluationProtos.TypedValueProto)builder.build();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TypedValue)) {
                return false;
            }
            TypedValue that = (TypedValue)o;
            if (this.type != that.type) {
                return false;
            }
            return this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static enum Type {
            BOOLEAN,
            BYTE,
            SHORT,
            CHAR,
            INT,
            FLOAT,
            LONG,
            DOUBLE,
            STRING,
            STRING_LIST,
            INTEGER_LIST;


            public static Type fromProto(AccessibilityEvaluationProtos.TypedValueProto.TypeProto proto) {
                return (Type)((Object)Preconditions.checkNotNull((Object)((Object)((Type)((Object)TYPE_MAP.inverse().get((Object)proto))))));
            }

            public AccessibilityEvaluationProtos.TypedValueProto.TypeProto toProto() {
                return (AccessibilityEvaluationProtos.TypedValueProto.TypeProto)Preconditions.checkNotNull((Object)((AccessibilityEvaluationProtos.TypedValueProto.TypeProto)TYPE_MAP.get((Object)this)));
            }
        }
    }
}

