/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.app.WallpaperColors;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.internal.graphics.ColorUtils;
import com.android.resources.ResourceType;
import com.android.systemui.monet.ColorScheme;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynamicRenderResources
extends RenderResources {
    private final RenderResources mBaseResources;
    private Map<String, Integer> mDynamicColorMap;

    public DynamicRenderResources(RenderResources baseResources) {
        this.mBaseResources = baseResources;
    }

    public void setLogger(ILayoutLog logger) {
        this.mBaseResources.setLogger(logger);
    }

    public StyleResourceValue getDefaultTheme() {
        return this.mBaseResources.getDefaultTheme();
    }

    public void applyStyle(StyleResourceValue theme, boolean useAsPrimary) {
        this.mBaseResources.applyStyle(theme, useAsPrimary);
    }

    public void clearStyles() {
        this.mBaseResources.clearStyles();
    }

    public List<StyleResourceValue> getAllThemes() {
        return this.mBaseResources.getAllThemes();
    }

    public ResourceValue findItemInTheme(ResourceReference attr2) {
        ResourceValue baseValue = this.mBaseResources.findItemInTheme(attr2);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue findItemInStyle(StyleResourceValue style2, ResourceReference attr2) {
        ResourceValue baseValue = this.mBaseResources.findItemInStyle(style2, attr2);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue findResValue(String reference, boolean forceFrameworkOnly) {
        ResourceValue baseValue = this.mBaseResources.findResValue(reference, forceFrameworkOnly);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue dereference(ResourceValue resourceValue) {
        ResourceValue baseValue = this.mBaseResources.dereference(resourceValue);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue getUnresolvedResource(ResourceReference reference) {
        ResourceValue baseValue = this.mBaseResources.getUnresolvedResource(reference);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue getResolvedResource(ResourceReference reference) {
        ResourceValue baseValue = this.mBaseResources.getResolvedResource(reference);
        return this.resolveDynamicColors(baseValue);
    }

    public ResourceValue resolveResValue(ResourceValue value) {
        ResourceValue baseValue = this.mBaseResources.resolveResValue(value);
        return this.resolveDynamicColors(baseValue);
    }

    public StyleResourceValue getParent(StyleResourceValue style2) {
        return this.mBaseResources.getParent(style2);
    }

    public StyleResourceValue getStyle(ResourceReference reference) {
        return this.mBaseResources.getStyle(reference);
    }

    private ResourceValue resolveDynamicColors(ResourceValue baseValue) {
        if (this.hasDynamicColors() && baseValue != null && DynamicRenderResources.isDynamicColor(baseValue)) {
            int dynamicColor = this.mDynamicColorMap.get(baseValue.getName());
            String colorHex = "#" + Integer.toHexString(dynamicColor).substring(2);
            return new ResourceValueImpl(baseValue.getNamespace(), baseValue.getResourceType(), baseValue.getName(), colorHex);
        }
        return baseValue;
    }

    public void setWallpaper(String wallpaperPath, boolean isNightMode) {
        if (wallpaperPath == null) {
            this.mDynamicColorMap = null;
            return;
        }
        this.mDynamicColorMap = DynamicRenderResources.createDynamicColorMap(wallpaperPath, isNightMode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map<String, Integer> createDynamicColorMap(String wallpaperPath, boolean isNightMode) {
        try (InputStream stream = DynamicRenderResources.class.getResourceAsStream(wallpaperPath);){
            Bitmap wallpaper = BitmapFactory.decodeStream(stream);
            if (wallpaper == null) {
                Map<String, Integer> map = null;
                return map;
            }
            WallpaperColors wallpaperColors = WallpaperColors.fromBitmap(wallpaper);
            int seed = ColorScheme.getSeedColor(wallpaperColors);
            ColorScheme scheme = new ColorScheme(seed, isNightMode);
            HashMap<String, Integer> dynamicColorMap = new HashMap<String, Integer>();
            int paletteSize = scheme.getAccent1().size();
            DynamicRenderResources.extractPalette(scheme.getAllAccentColors(), "accent", paletteSize, dynamicColorMap);
            DynamicRenderResources.extractPalette(scheme.getAllNeutralColors(), "neutral", paletteSize, dynamicColorMap);
            HashMap<String, Integer> hashMap = dynamicColorMap;
            return hashMap;
        }
        catch (IOException | IllegalArgumentException ignore) {
            return null;
        }
    }

    private static void extractPalette(List<Integer> shades, String name, int paletteSize, Map<String, Integer> colorMap) {
        for (int i = 0; i < shades.size(); ++i) {
            String resourceName;
            int luminosity = i % paletteSize;
            int paletteIndex = i / paletteSize + 1;
            String baseResourceName = "system_" + name + paletteIndex;
            switch (luminosity) {
                case 0: {
                    resourceName = baseResourceName + "_0";
                    colorMap.put(resourceName, -1);
                    resourceName = baseResourceName + "_10";
                    break;
                }
                case 1: {
                    resourceName = baseResourceName + "_50";
                    break;
                }
                default: {
                    resourceName = baseResourceName + "_" + (luminosity - 1) + "00";
                }
            }
            colorMap.put(resourceName, ColorUtils.setAlphaComponent(shades.get(i), 255));
        }
    }

    private static boolean isDynamicColor(ResourceValue resourceValue) {
        if (!resourceValue.isFramework() || resourceValue.getResourceType() != ResourceType.COLOR) {
            return false;
        }
        return resourceValue.getName().startsWith("system_accent") || resourceValue.getName().startsWith("system_neutral");
    }

    public boolean hasDynamicColors() {
        return this.mDynamicColorMap != null;
    }
}

