/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.util.ArraySet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.android.internal.widget.MessagingPropertyAnimator;

public class ViewClippingUtil {
    private static final int CLIP_CLIPPING_SET = 16908880;
    private static final int CLIP_CHILDREN_TAG = 16908881;
    private static final int CLIP_TO_PADDING = 16908883;

    public static void setClippingDeactivated(View transformedView, boolean deactivated, ClippingParameters clippingParameters) {
        if (!deactivated && !clippingParameters.isClippingEnablingAllowed(transformedView)) {
            return;
        }
        if (!(transformedView.getParent() instanceof ViewGroup)) {
            return;
        }
        ViewGroup parent = (ViewGroup)transformedView.getParent();
        while (true) {
            Boolean clipToPadding;
            Boolean clipChildren;
            if (!deactivated && !clippingParameters.isClippingEnablingAllowed(transformedView)) {
                return;
            }
            ArraySet<View> clipSet = (ArraySet<View>)parent.getTag(16908880);
            if (clipSet == null) {
                clipSet = new ArraySet<View>();
                parent.setTagInternal(16908880, clipSet);
            }
            if ((clipChildren = (Boolean)parent.getTag(16908881)) == null) {
                clipChildren = parent.getClipChildren();
                parent.setTagInternal(16908881, clipChildren);
            }
            if ((clipToPadding = (Boolean)parent.getTag(16908883)) == null) {
                clipToPadding = parent.getClipToPadding();
                parent.setTagInternal(16908883, clipToPadding);
            }
            if (!deactivated) {
                clipSet.remove(transformedView);
                if (clipSet.isEmpty()) {
                    parent.setClipChildren(clipChildren);
                    parent.setClipToPadding(clipToPadding);
                    parent.setTagInternal(16908880, null);
                    clippingParameters.onClippingStateChanged(parent, true);
                }
            } else {
                clipSet.add(transformedView);
                parent.setClipChildren(false);
                parent.setClipToPadding(false);
                clippingParameters.onClippingStateChanged(parent, false);
            }
            if (clippingParameters.shouldFinish(parent)) {
                return;
            }
            ViewParent viewParent = parent.getParent();
            if (!(viewParent instanceof ViewGroup)) break;
            parent = (ViewGroup)viewParent;
        }
    }

    public static interface ClippingParameters {
        public boolean shouldFinish(View var1);

        default public boolean isClippingEnablingAllowed(View view) {
            return !MessagingPropertyAnimator.isAnimatingTranslation(view);
        }

        default public void onClippingStateChanged(View view, boolean isClipping) {
        }
    }
}

