/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.layoutlib.bridge.android.AndroidLocale;

@RemoteViews.RemoteView
public class NotificationExpandButton
extends FrameLayout {
    private View mPillView;
    private TextView mNumberView;
    private ImageView mIconView;
    private boolean mExpanded;
    private int mNumber;
    private int mDefaultPillColor;
    private int mDefaultTextColor;
    private int mHighlightPillColor;
    private int mHighlightTextColor;

    public NotificationExpandButton(Context context) {
        this(context, null, 0, 0);
    }

    public NotificationExpandButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0, 0);
    }

    public NotificationExpandButton(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationExpandButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mPillView = this.findViewById(16908987);
        this.mNumberView = (TextView)this.findViewById(16908986);
        this.mIconView = (ImageView)this.findViewById(16908985);
    }

    @Override
    public void getBoundsOnScreen(Rect outRect, boolean clipToParent) {
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null && parent.getId() == 16908988) {
            parent.getBoundsOnScreen(outRect, clipToParent);
        } else {
            super.getBoundsOnScreen(outRect, clipToParent);
        }
    }

    @Override
    public boolean pointInView(float localX, float localY, float slop) {
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent != null && parent.getId() == 16908988) {
            return true;
        }
        return super.pointInView(localX, localY, slop);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(Button.class.getName());
    }

    @RemotableViewMethod
    public void setExpanded(boolean expanded) {
        this.mExpanded = expanded;
        this.updateExpandedState();
    }

    private void updateExpandedState() {
        int contentDescriptionId;
        int drawableId;
        if (this.mExpanded) {
            drawableId = 17302386;
            contentDescriptionId = 17040222;
        } else {
            drawableId = 17302445;
            contentDescriptionId = 17040221;
        }
        this.setContentDescription(this.mContext.getText(contentDescriptionId));
        this.mIconView.setImageDrawable(this.getContext().getDrawable(drawableId));
        this.updateNumber();
    }

    private void updateNumber() {
        if (this.shouldShowNumber()) {
            String text = this.mNumber >= 100 ? this.getResources().getString(17041655, 99) : String.format(AndroidLocale.getDefault(), "%d", this.mNumber);
            this.mNumberView.setText(text);
            this.mNumberView.setVisibility(0);
        } else {
            this.mNumberView.setVisibility(8);
        }
        this.updateColors();
    }

    private void updateColors() {
        if (this.shouldShowNumber()) {
            if (this.mHighlightPillColor != 0) {
                this.mPillView.setBackgroundTintList(ColorStateList.valueOf(this.mHighlightPillColor));
            }
            this.mIconView.setColorFilter(this.mHighlightTextColor);
            if (this.mHighlightTextColor != 0) {
                this.mNumberView.setTextColor(this.mHighlightTextColor);
            }
        } else {
            if (this.mDefaultPillColor != 0) {
                this.mPillView.setBackgroundTintList(ColorStateList.valueOf(this.mDefaultPillColor));
            }
            this.mIconView.setColorFilter(this.mDefaultTextColor);
            if (this.mDefaultTextColor != 0) {
                this.mNumberView.setTextColor(this.mDefaultTextColor);
            }
        }
    }

    private boolean shouldShowNumber() {
        return !this.mExpanded && this.mNumber > 1;
    }

    @RemotableViewMethod
    public void setDefaultTextColor(int color2) {
        this.mDefaultTextColor = color2;
        this.updateColors();
    }

    @RemotableViewMethod
    public void setDefaultPillColor(int color2) {
        this.mDefaultPillColor = color2;
        this.updateColors();
    }

    @RemotableViewMethod
    public void setHighlightTextColor(int color2) {
        this.mHighlightTextColor = color2;
        this.updateColors();
    }

    @RemotableViewMethod
    public void setHighlightPillColor(int color2) {
        this.mHighlightPillColor = color2;
        this.updateColors();
    }

    @RemotableViewMethod
    public void setNumber(int number) {
        if (this.mNumber != number) {
            this.mNumber = number;
            this.updateNumber();
        }
    }
}

