/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Rect;
import android.os.CancellationSignal;
import android.util.Log;
import android.view.View;
import android.widget.ListView;
import com.android.internal.view.ScrollCaptureViewHelper;
import com.android.internal.view.ScrollCaptureViewSupport;
import java.util.function.Consumer;

public class ListViewCaptureHelper
implements ScrollCaptureViewHelper<ListView> {
    private static final String TAG = "LVCaptureHelper";
    private int mScrollDelta;
    private boolean mScrollBarWasEnabled;
    private int mOverScrollMode;

    @Override
    public boolean onAcceptSession(ListView view) {
        return view.isVisibleToUser() && (view.canScrollVertically(-1) || view.canScrollVertically(1));
    }

    @Override
    public void onPrepareForStart(ListView view, Rect scrollBounds) {
        this.mScrollDelta = 0;
        this.mOverScrollMode = view.getOverScrollMode();
        view.setOverScrollMode(2);
        this.mScrollBarWasEnabled = view.isVerticalScrollBarEnabled();
        view.setVerticalScrollBarEnabled(false);
    }

    @Override
    public void onScrollRequested(ListView listView, Rect scrollBounds, Rect requestRect, CancellationSignal signal, Consumer<ScrollCaptureViewHelper.ScrollResult> resultConsumer) {
        int scrollAmount;
        Log.d(TAG, "-----------------------------------------------------------");
        Log.d(TAG, "onScrollRequested(scrollBounds=" + scrollBounds + ", requestRect=" + requestRect + ")");
        ScrollCaptureViewHelper.ScrollResult result = new ScrollCaptureViewHelper.ScrollResult();
        result.requestedArea = new Rect(requestRect);
        result.scrollDelta = this.mScrollDelta;
        result.availableArea = new Rect();
        if (!listView.isVisibleToUser() || listView.getChildCount() == 0) {
            Log.w(TAG, "listView is empty or not visible, cannot continue");
            resultConsumer.accept(result);
            return;
        }
        Rect requestedContainerBounds = ScrollCaptureViewSupport.transformFromRequestToContainer(this.mScrollDelta, scrollBounds, requestRect);
        Rect recyclerLocalVisible = new Rect();
        listView.getLocalVisibleRect(recyclerLocalVisible);
        Rect adjustedContainerBounds = new Rect(requestedContainerBounds);
        int remainingHeight = recyclerLocalVisible.height() - requestedContainerBounds.height();
        if (remainingHeight > 0) {
            adjustedContainerBounds.inset(0, -remainingHeight / 2);
        }
        if ((scrollAmount = ScrollCaptureViewSupport.computeScrollAmount(recyclerLocalVisible, adjustedContainerBounds)) < 0) {
            Log.d(TAG, "About to scroll UP (content moves down within parent)");
        } else if (scrollAmount > 0) {
            Log.d(TAG, "About to scroll DOWN (content moves up within parent)");
        }
        Log.d(TAG, "scrollAmount: " + scrollAmount);
        View refView = ScrollCaptureViewSupport.findScrollingReferenceView(listView, scrollAmount);
        int refTop = refView.getTop();
        listView.scrollListBy(scrollAmount);
        int scrollDistance = refTop - refView.getTop();
        Log.d(TAG, "Parent view has scrolled vertically by " + scrollDistance + " px");
        this.mScrollDelta += scrollDistance;
        result.scrollDelta = this.mScrollDelta;
        if (scrollDistance != 0) {
            Log.d(TAG, "Scroll delta is now " + this.mScrollDelta + " px");
        }
        requestedContainerBounds = new Rect(ScrollCaptureViewSupport.transformFromRequestToContainer(this.mScrollDelta, scrollBounds, requestRect));
        listView.getLocalVisibleRect(recyclerLocalVisible);
        if (requestedContainerBounds.intersect(recyclerLocalVisible)) {
            result.availableArea = ScrollCaptureViewSupport.transformFromContainerToRequest(this.mScrollDelta, scrollBounds, requestedContainerBounds);
        }
        Log.d(TAG, "-----------------------------------------------------------");
        resultConsumer.accept(result);
    }

    @Override
    public void onPrepareForEnd(ListView listView) {
        listView.scrollListBy(-this.mScrollDelta);
        listView.setOverScrollMode(this.mOverScrollMode);
        listView.setVerticalScrollBarEnabled(this.mScrollBarWasEnabled);
    }
}

