/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseSurfaceHolder
implements SurfaceHolder {
    private static final String TAG = "BaseSurfaceHolder";
    static final boolean DEBUG = false;
    public final ArrayList<SurfaceHolder.Callback> mCallbacks = new ArrayList();
    SurfaceHolder.Callback[] mGottenCallbacks;
    boolean mHaveGottenCallbacks;
    public final ReentrantLock mSurfaceLock = new ReentrantLock();
    public Surface mSurface = new Surface();
    int mRequestedWidth = -1;
    int mRequestedHeight = -1;
    protected int mRequestedFormat = -1;
    int mRequestedType = -1;
    long mLastLockTime = 0L;
    int mType = -1;
    final Rect mSurfaceFrame = new Rect();
    Rect mTmpDirty;

    public abstract void onUpdateSurface();

    public abstract void onRelayoutContainer();

    public abstract boolean onAllowLockCanvas();

    public int getRequestedWidth() {
        return this.mRequestedWidth;
    }

    public int getRequestedHeight() {
        return this.mRequestedHeight;
    }

    public int getRequestedFormat() {
        return this.mRequestedFormat;
    }

    public int getRequestedType() {
        return this.mRequestedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            if (!this.mCallbacks.contains(callback)) {
                this.mCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCallback(SurfaceHolder.Callback callback) {
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            this.mCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceHolder.Callback[] getCallbacks() {
        if (this.mHaveGottenCallbacks) {
            return this.mGottenCallbacks;
        }
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            int N = this.mCallbacks.size();
            if (N > 0) {
                if (this.mGottenCallbacks == null || this.mGottenCallbacks.length != N) {
                    this.mGottenCallbacks = new SurfaceHolder.Callback[N];
                }
                this.mCallbacks.toArray(this.mGottenCallbacks);
            } else {
                this.mGottenCallbacks = null;
            }
            this.mHaveGottenCallbacks = true;
        }
        return this.mGottenCallbacks;
    }

    public void ungetCallbacks() {
        this.mHaveGottenCallbacks = false;
    }

    @Override
    public void setFixedSize(int width, int height) {
        if (this.mRequestedWidth != width || this.mRequestedHeight != height) {
            this.mRequestedWidth = width;
            this.mRequestedHeight = height;
            this.onRelayoutContainer();
        }
    }

    @Override
    public void setSizeFromLayout() {
        if (this.mRequestedWidth != -1 || this.mRequestedHeight != -1) {
            this.mRequestedHeight = -1;
            this.mRequestedWidth = -1;
            this.onRelayoutContainer();
        }
    }

    @Override
    public void setFormat(int format) {
        if (this.mRequestedFormat != format) {
            this.mRequestedFormat = format;
            this.onUpdateSurface();
        }
    }

    @Override
    public void setType(int type) {
        switch (type) {
            case 1: 
            case 2: {
                type = 0;
            }
        }
        switch (type) {
            case 0: 
            case 3: {
                if (this.mRequestedType == type) break;
                this.mRequestedType = type;
                this.onUpdateSurface();
            }
        }
    }

    @Override
    public Canvas lockCanvas() {
        return this.internalLockCanvas(null, false);
    }

    @Override
    public Canvas lockCanvas(Rect dirty) {
        return this.internalLockCanvas(dirty, false);
    }

    @Override
    public Canvas lockHardwareCanvas() {
        return this.internalLockCanvas(null, true);
    }

    private Canvas internalLockCanvas(Rect dirty, boolean hardware) {
        if (this.mType == 3) {
            throw new SurfaceHolder.BadSurfaceTypeException("Surface type is SURFACE_TYPE_PUSH_BUFFERS");
        }
        this.mSurfaceLock.lock();
        Canvas c = null;
        if (this.onAllowLockCanvas()) {
            if (dirty == null) {
                if (this.mTmpDirty == null) {
                    this.mTmpDirty = new Rect();
                }
                this.mTmpDirty.set(this.mSurfaceFrame);
                dirty = this.mTmpDirty;
            }
            try {
                c = hardware ? this.mSurface.lockHardwareCanvas() : this.mSurface.lockCanvas(dirty);
            }
            catch (Exception e) {
                Log.e(TAG, "Exception locking surface", e);
            }
        }
        if (c != null) {
            this.mLastLockTime = SystemClock.uptimeMillis();
            return c;
        }
        long nextTime = this.mLastLockTime + 100L;
        long now = SystemClock.uptimeMillis();
        if (nextTime > now) {
            try {
                Thread.sleep(nextTime - now);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = SystemClock.uptimeMillis();
        }
        this.mLastLockTime = now;
        this.mSurfaceLock.unlock();
        return null;
    }

    @Override
    public void unlockCanvasAndPost(Canvas canvas) {
        this.mSurface.unlockCanvasAndPost(canvas);
        this.mSurfaceLock.unlock();
    }

    @Override
    public Surface getSurface() {
        return this.mSurface;
    }

    @Override
    public Rect getSurfaceFrame() {
        return this.mSurfaceFrame;
    }

    public void setSurfaceFrameSize(int width, int height) {
        this.mSurfaceFrame.top = 0;
        this.mSurfaceFrame.left = 0;
        this.mSurfaceFrame.right = width;
        this.mSurfaceFrame.bottom = height;
    }
}

