/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.text.TextUtils;
import android.util.Base64;
import android.util.TypedXmlPullParser;
import com.android.internal.util.BinaryXmlSerializer;
import com.android.internal.util.FastDataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParserException;

public class BinaryXmlPullParser
implements TypedXmlPullParser {
    private static final int BUFFER_SIZE = 32768;
    private FastDataInput mIn;
    private int mCurrentToken = 0;
    private int mCurrentDepth = 0;
    private String mCurrentName;
    private String mCurrentText;
    private int mAttributeCount = 0;
    private Attribute[] mAttributes;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public void setInput(InputStream is, String encoding) throws XmlPullParserException {
        if (encoding != null && !StandardCharsets.UTF_8.name().equalsIgnoreCase(encoding)) {
            throw new UnsupportedOperationException();
        }
        this.mIn = new FastDataInput(is, 32768);
        this.mCurrentToken = 0;
        this.mCurrentDepth = 0;
        this.mCurrentName = null;
        this.mCurrentText = null;
        this.mAttributeCount = 0;
        this.mAttributes = new Attribute[8];
        for (int i = 0; i < this.mAttributes.length; ++i) {
            this.mAttributes[i] = new Attribute();
        }
        try {
            byte[] magic = new byte[4];
            this.mIn.readFully(magic);
            if (!Arrays.equals(magic, BinaryXmlSerializer.PROTOCOL_MAGIC_VERSION_0)) {
                throw new IOException("Unexpected magic " + BinaryXmlPullParser.bytesToHexString(magic));
            }
            if (this.peekNextExternalToken() == 0) {
                this.consumeToken();
            }
        }
        catch (IOException e) {
            throw new XmlPullParserException(e.toString());
        }
    }

    public void setInput(Reader in) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public int next() throws XmlPullParserException, IOException {
        block4: while (true) {
            int token = this.nextToken();
            switch (token) {
                case 1: 
                case 2: 
                case 3: {
                    return token;
                }
                case 4: {
                    this.consumeAdditionalText();
                    if (this.mCurrentText == null || this.mCurrentText.length() == 0) continue block4;
                    return 4;
                }
            }
        }
    }

    public int nextToken() throws XmlPullParserException, IOException {
        int token;
        if (this.mCurrentToken == 3) {
            --this.mCurrentDepth;
        }
        try {
            token = this.peekNextExternalToken();
            this.consumeToken();
        }
        catch (EOFException e) {
            token = 1;
        }
        switch (token) {
            case 2: {
                this.peekNextExternalToken();
                ++this.mCurrentDepth;
            }
        }
        this.mCurrentToken = token;
        return token;
    }

    private int peekNextExternalToken() throws IOException, XmlPullParserException {
        int token;
        block3: while (true) {
            token = this.peekNextToken();
            switch (token) {
                case 15: {
                    this.consumeToken();
                    continue block3;
                }
            }
            break;
        }
        return token;
    }

    private int peekNextToken() throws IOException {
        return this.mIn.peekByte() & 0xF;
    }

    private void consumeToken() throws IOException, XmlPullParserException {
        byte event = this.mIn.readByte();
        int token = event & 0xF;
        int type = event & 0xF0;
        block0 : switch (token) {
            case 15: {
                Attribute attr2 = this.obtainAttribute();
                attr2.name = this.mIn.readInternedUTF();
                attr2.type = type;
                switch (type) {
                    case 16: 
                    case 192: 
                    case 208: {
                        break block0;
                    }
                    case 32: {
                        attr2.valueString = this.mIn.readUTF();
                        break block0;
                    }
                    case 48: {
                        attr2.valueString = this.mIn.readInternedUTF();
                        break block0;
                    }
                    case 64: 
                    case 80: {
                        int len = this.mIn.readUnsignedShort();
                        byte[] res = new byte[len];
                        this.mIn.readFully(res);
                        attr2.valueBytes = res;
                        break block0;
                    }
                    case 96: 
                    case 112: {
                        attr2.valueInt = this.mIn.readInt();
                        break block0;
                    }
                    case 128: 
                    case 144: {
                        attr2.valueLong = this.mIn.readLong();
                        break block0;
                    }
                    case 160: {
                        attr2.valueFloat = this.mIn.readFloat();
                        break block0;
                    }
                    case 176: {
                        attr2.valueDouble = this.mIn.readDouble();
                        break block0;
                    }
                }
                throw new IOException("Unexpected data type " + type);
            }
            case 0: {
                this.mCurrentName = null;
                this.mCurrentText = null;
                if (this.mAttributeCount <= 0) break;
                this.resetAttributes();
                break;
            }
            case 1: {
                this.mCurrentName = null;
                this.mCurrentText = null;
                if (this.mAttributeCount <= 0) break;
                this.resetAttributes();
                break;
            }
            case 2: {
                this.mCurrentName = this.mIn.readInternedUTF();
                this.mCurrentText = null;
                if (this.mAttributeCount <= 0) break;
                this.resetAttributes();
                break;
            }
            case 3: {
                this.mCurrentName = this.mIn.readInternedUTF();
                this.mCurrentText = null;
                if (this.mAttributeCount <= 0) break;
                this.resetAttributes();
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.mCurrentName = null;
                this.mCurrentText = this.mIn.readUTF();
                if (this.mAttributeCount <= 0) break;
                this.resetAttributes();
                break;
            }
            case 6: {
                this.mCurrentName = this.mIn.readUTF();
                this.mCurrentText = BinaryXmlPullParser.resolveEntity(this.mCurrentName);
                if (this.mAttributeCount <= 0) break;
                this.resetAttributes();
                break;
            }
            default: {
                throw new IOException("Unknown token " + token + " with type " + type);
            }
        }
    }

    private void consumeAdditionalText() throws IOException, XmlPullParserException {
        String combinedText = this.mCurrentText;
        block4: while (true) {
            int token = this.peekNextExternalToken();
            switch (token) {
                case 8: 
                case 9: {
                    this.consumeToken();
                    continue block4;
                }
                case 4: 
                case 5: 
                case 6: {
                    this.consumeToken();
                    combinedText = combinedText + this.mCurrentText;
                    continue block4;
                }
            }
            break;
        }
        this.mCurrentToken = 4;
        this.mCurrentName = null;
        this.mCurrentText = combinedText;
    }

    static String resolveEntity(String entity) throws XmlPullParserException {
        switch (entity) {
            case "lt": {
                return "<";
            }
            case "gt": {
                return ">";
            }
            case "amp": {
                return "&";
            }
            case "apos": {
                return "'";
            }
            case "quot": {
                return "\"";
            }
        }
        if (entity.length() > 1 && entity.charAt(0) == '#') {
            char c = (char)Integer.parseInt(entity.substring(1));
            return new String(new char[]{c});
        }
        throw new XmlPullParserException("Unknown entity " + entity);
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        if (namespace != null && !namespace.isEmpty()) {
            throw BinaryXmlPullParser.illegalNamespace();
        }
        if (this.mCurrentToken != type || !Objects.equals(this.mCurrentName, name)) {
            throw new XmlPullParserException(this.getPositionDescription());
        }
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException(this.getPositionDescription());
        }
        int eventType = this.next();
        if (eventType == 4) {
            String result = this.getText();
            eventType = this.next();
            if (eventType != 3) {
                throw new XmlPullParserException(this.getPositionDescription());
            }
            return result;
        }
        if (eventType == 3) {
            return "";
        }
        throw new XmlPullParserException(this.getPositionDescription());
    }

    public int nextTag() throws XmlPullParserException, IOException {
        int eventType = this.next();
        if (eventType == 4 && this.isWhitespace()) {
            eventType = this.next();
        }
        if (eventType != 2 && eventType != 3) {
            throw new XmlPullParserException(this.getPositionDescription());
        }
        return eventType;
    }

    private Attribute obtainAttribute() {
        if (this.mAttributeCount == this.mAttributes.length) {
            int before = this.mAttributes.length;
            int after = before + (before >> 1);
            this.mAttributes = Arrays.copyOf(this.mAttributes, after);
            for (int i = before; i < after; ++i) {
                this.mAttributes[i] = new Attribute();
            }
        }
        return this.mAttributes[this.mAttributeCount++];
    }

    private void resetAttributes() {
        for (int i = 0; i < this.mAttributeCount; ++i) {
            this.mAttributes[i].reset();
        }
        this.mAttributeCount = 0;
    }

    @Override
    public int getAttributeIndex(String namespace, String name) {
        if (namespace != null && !namespace.isEmpty()) {
            throw BinaryXmlPullParser.illegalNamespace();
        }
        for (int i = 0; i < this.mAttributeCount; ++i) {
            if (!Objects.equals(this.mAttributes[i].name, name)) continue;
            return i;
        }
        return -1;
    }

    public String getAttributeValue(String namespace, String name) {
        int index = this.getAttributeIndex(namespace, name);
        if (index != -1) {
            return this.mAttributes[index].getValueString();
        }
        return null;
    }

    public String getAttributeValue(int index) {
        return this.mAttributes[index].getValueString();
    }

    @Override
    public byte[] getAttributeBytesHex(int index) throws XmlPullParserException {
        return this.mAttributes[index].getValueBytesHex();
    }

    @Override
    public byte[] getAttributeBytesBase64(int index) throws XmlPullParserException {
        return this.mAttributes[index].getValueBytesBase64();
    }

    @Override
    public int getAttributeInt(int index) throws XmlPullParserException {
        return this.mAttributes[index].getValueInt();
    }

    @Override
    public int getAttributeIntHex(int index) throws XmlPullParserException {
        return this.mAttributes[index].getValueIntHex();
    }

    @Override
    public long getAttributeLong(int index) throws XmlPullParserException {
        return this.mAttributes[index].getValueLong();
    }

    @Override
    public long getAttributeLongHex(int index) throws XmlPullParserException {
        return this.mAttributes[index].getValueLongHex();
    }

    @Override
    public float getAttributeFloat(int index) throws XmlPullParserException {
        return this.mAttributes[index].getValueFloat();
    }

    @Override
    public double getAttributeDouble(int index) throws XmlPullParserException {
        return this.mAttributes[index].getValueDouble();
    }

    @Override
    public boolean getAttributeBoolean(int index) throws XmlPullParserException {
        return this.mAttributes[index].getValueBoolean();
    }

    public String getText() {
        return this.mCurrentText;
    }

    public char[] getTextCharacters(int[] holderForStartAndLength) {
        char[] chars = this.mCurrentText.toCharArray();
        holderForStartAndLength[0] = 0;
        holderForStartAndLength[1] = chars.length;
        return chars;
    }

    public String getInputEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public int getDepth() {
        return this.mCurrentDepth;
    }

    public String getPositionDescription() {
        return "Token " + this.mCurrentToken + " at depth " + this.mCurrentDepth;
    }

    public int getLineNumber() {
        return -1;
    }

    public int getColumnNumber() {
        return -1;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        switch (this.mCurrentToken) {
            case 7: {
                return true;
            }
            case 4: 
            case 5: {
                return !TextUtils.isGraphic(this.mCurrentText);
            }
        }
        throw new XmlPullParserException("Not applicable for token " + this.mCurrentToken);
    }

    public String getNamespace() {
        switch (this.mCurrentToken) {
            case 2: 
            case 3: {
                return "";
            }
        }
        return null;
    }

    public String getName() {
        return this.mCurrentName;
    }

    public String getPrefix() {
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        switch (this.mCurrentToken) {
            case 2: {
                try {
                    return this.peekNextExternalToken() == 3;
                }
                catch (IOException e) {
                    throw new XmlPullParserException(e.toString());
                }
            }
        }
        throw new XmlPullParserException("Not at START_TAG");
    }

    public int getAttributeCount() {
        return this.mAttributeCount;
    }

    public String getAttributeNamespace(int index) {
        return "";
    }

    public String getAttributeName(int index) {
        return this.mAttributes[index].name;
    }

    public String getAttributePrefix(int index) {
        return null;
    }

    public String getAttributeType(int index) {
        return "CDATA";
    }

    public boolean isAttributeDefault(int index) {
        return false;
    }

    public int getEventType() throws XmlPullParserException {
        return this.mCurrentToken;
    }

    public int getNamespaceCount(int depth) throws XmlPullParserException {
        return 0;
    }

    public String getNamespacePrefix(int pos) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public String getNamespaceUri(int pos) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public String getNamespace(String prefix) {
        throw new UnsupportedOperationException();
    }

    public void defineEntityReplacementText(String entityName, String replacementText) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public void setFeature(String name, boolean state) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public boolean getFeature(String name) {
        throw new UnsupportedOperationException();
    }

    public void setProperty(String name, Object value) throws XmlPullParserException {
        throw new UnsupportedOperationException();
    }

    public Object getProperty(String name) {
        throw new UnsupportedOperationException();
    }

    private static IllegalArgumentException illegalNamespace() {
        throw new IllegalArgumentException("Namespaces are not supported");
    }

    private static int toByte(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new IllegalArgumentException("Invalid hex char '" + c + "'");
    }

    static String bytesToHexString(byte[] value) {
        int length = value.length;
        char[] buf = new char[length * 2];
        int bufIndex = 0;
        for (int i = 0; i < length; ++i) {
            byte b = value[i];
            buf[bufIndex++] = HEX_DIGITS[b >>> 4 & 0xF];
            buf[bufIndex++] = HEX_DIGITS[b & 0xF];
        }
        return new String(buf);
    }

    static byte[] hexStringToBytes(String value) {
        int length = value.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Invalid hex length " + length);
        }
        byte[] buffer = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            buffer[i / 2] = (byte)(BinaryXmlPullParser.toByte(value.charAt(i)) << 4 | BinaryXmlPullParser.toByte(value.charAt(i + 1)));
        }
        return buffer;
    }

    private static class Attribute {
        public String name;
        public int type;
        public String valueString;
        public byte[] valueBytes;
        public int valueInt;
        public long valueLong;
        public float valueFloat;
        public double valueDouble;

        private Attribute() {
        }

        public void reset() {
            this.name = null;
            this.valueString = null;
            this.valueBytes = null;
        }

        public String getValueString() {
            switch (this.type) {
                case 16: {
                    return null;
                }
                case 32: 
                case 48: {
                    return this.valueString;
                }
                case 64: {
                    return BinaryXmlPullParser.bytesToHexString(this.valueBytes);
                }
                case 80: {
                    return Base64.encodeToString(this.valueBytes, 2);
                }
                case 96: {
                    return Integer.toString(this.valueInt);
                }
                case 112: {
                    return Integer.toString(this.valueInt, 16);
                }
                case 128: {
                    return Long.toString(this.valueLong);
                }
                case 144: {
                    return Long.toString(this.valueLong, 16);
                }
                case 160: {
                    return Float.toString(this.valueFloat);
                }
                case 176: {
                    return Double.toString(this.valueDouble);
                }
                case 192: {
                    return "true";
                }
                case 208: {
                    return "false";
                }
            }
            return null;
        }

        public byte[] getValueBytesHex() throws XmlPullParserException {
            switch (this.type) {
                case 16: {
                    return null;
                }
                case 64: 
                case 80: {
                    return this.valueBytes;
                }
                case 32: 
                case 48: {
                    try {
                        return BinaryXmlPullParser.hexStringToBytes(this.valueString);
                    }
                    catch (Exception e) {
                        throw new XmlPullParserException("Invalid attribute " + this.name + ": " + e);
                    }
                }
            }
            throw new XmlPullParserException("Invalid conversion from " + this.type);
        }

        public byte[] getValueBytesBase64() throws XmlPullParserException {
            switch (this.type) {
                case 16: {
                    return null;
                }
                case 64: 
                case 80: {
                    return this.valueBytes;
                }
                case 32: 
                case 48: {
                    try {
                        return Base64.decode(this.valueString, 2);
                    }
                    catch (Exception e) {
                        throw new XmlPullParserException("Invalid attribute " + this.name + ": " + e);
                    }
                }
            }
            throw new XmlPullParserException("Invalid conversion from " + this.type);
        }

        public int getValueInt() throws XmlPullParserException {
            switch (this.type) {
                case 96: 
                case 112: {
                    return this.valueInt;
                }
                case 32: 
                case 48: {
                    try {
                        return Integer.parseInt(this.valueString);
                    }
                    catch (Exception e) {
                        throw new XmlPullParserException("Invalid attribute " + this.name + ": " + e);
                    }
                }
            }
            throw new XmlPullParserException("Invalid conversion from " + this.type);
        }

        public int getValueIntHex() throws XmlPullParserException {
            switch (this.type) {
                case 96: 
                case 112: {
                    return this.valueInt;
                }
                case 32: 
                case 48: {
                    try {
                        return Integer.parseInt(this.valueString, 16);
                    }
                    catch (Exception e) {
                        throw new XmlPullParserException("Invalid attribute " + this.name + ": " + e);
                    }
                }
            }
            throw new XmlPullParserException("Invalid conversion from " + this.type);
        }

        public long getValueLong() throws XmlPullParserException {
            switch (this.type) {
                case 128: 
                case 144: {
                    return this.valueLong;
                }
                case 32: 
                case 48: {
                    try {
                        return Long.parseLong(this.valueString);
                    }
                    catch (Exception e) {
                        throw new XmlPullParserException("Invalid attribute " + this.name + ": " + e);
                    }
                }
            }
            throw new XmlPullParserException("Invalid conversion from " + this.type);
        }

        public long getValueLongHex() throws XmlPullParserException {
            switch (this.type) {
                case 128: 
                case 144: {
                    return this.valueLong;
                }
                case 32: 
                case 48: {
                    try {
                        return Long.parseLong(this.valueString, 16);
                    }
                    catch (Exception e) {
                        throw new XmlPullParserException("Invalid attribute " + this.name + ": " + e);
                    }
                }
            }
            throw new XmlPullParserException("Invalid conversion from " + this.type);
        }

        public float getValueFloat() throws XmlPullParserException {
            switch (this.type) {
                case 160: {
                    return this.valueFloat;
                }
                case 32: 
                case 48: {
                    try {
                        return Float.parseFloat(this.valueString);
                    }
                    catch (Exception e) {
                        throw new XmlPullParserException("Invalid attribute " + this.name + ": " + e);
                    }
                }
            }
            throw new XmlPullParserException("Invalid conversion from " + this.type);
        }

        public double getValueDouble() throws XmlPullParserException {
            switch (this.type) {
                case 176: {
                    return this.valueDouble;
                }
                case 32: 
                case 48: {
                    try {
                        return Double.parseDouble(this.valueString);
                    }
                    catch (Exception e) {
                        throw new XmlPullParserException("Invalid attribute " + this.name + ": " + e);
                    }
                }
            }
            throw new XmlPullParserException("Invalid conversion from " + this.type);
        }

        public boolean getValueBoolean() throws XmlPullParserException {
            switch (this.type) {
                case 192: {
                    return true;
                }
                case 208: {
                    return false;
                }
                case 32: 
                case 48: {
                    if ("true".equalsIgnoreCase(this.valueString)) {
                        return true;
                    }
                    if ("false".equalsIgnoreCase(this.valueString)) {
                        return false;
                    }
                    throw new XmlPullParserException("Invalid attribute " + this.name + ": " + this.valueString);
                }
            }
            throw new XmlPullParserException("Invalid conversion from " + this.type);
        }
    }
}

