/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.power;

import android.os.Parcel;
import android.text.TextUtils;
import android.util.DebugUtils;
import android.util.Slog;
import android.view.Display;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.LongMultiStateCounter;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

@VisibleForTesting
public class MeasuredEnergyStats {
    private static final String TAG = "MeasuredEnergyStats";
    public static final int POWER_BUCKET_UNKNOWN = -1;
    public static final int POWER_BUCKET_SCREEN_ON = 0;
    public static final int POWER_BUCKET_SCREEN_DOZE = 1;
    public static final int POWER_BUCKET_SCREEN_OTHER = 2;
    public static final int POWER_BUCKET_CPU = 3;
    public static final int POWER_BUCKET_WIFI = 4;
    public static final int POWER_BUCKET_BLUETOOTH = 5;
    public static final int POWER_BUCKET_GNSS = 6;
    public static final int POWER_BUCKET_MOBILE_RADIO = 7;
    public static final int NUMBER_STANDARD_POWER_BUCKETS = 8;
    private static final int INVALID_STATE = -1;
    private final Config mConfig;
    private final long[] mAccumulatedChargeMicroCoulomb;
    private LongMultiStateCounter[] mAccumulatedMultiStateChargeMicroCoulomb;
    private int mState = -1;
    private long mStateChangeTimestampMs;

    public MeasuredEnergyStats(Config config) {
        this.mConfig = config;
        int numTotalBuckets = config.getNumberOfBuckets();
        this.mAccumulatedChargeMicroCoulomb = new long[numTotalBuckets];
        for (int stdBucket = 0; stdBucket < 8; ++stdBucket) {
            if (this.mConfig.mSupportedStandardBuckets[stdBucket]) continue;
            this.mAccumulatedChargeMicroCoulomb[stdBucket] = -1L;
        }
    }

    public static MeasuredEnergyStats createFromParcel(Config config, Parcel in) {
        if (!in.readBoolean()) {
            return null;
        }
        return new MeasuredEnergyStats(config, in);
    }

    public MeasuredEnergyStats(Config config, Parcel in) {
        this.mConfig = config;
        int size = in.readInt();
        this.mAccumulatedChargeMicroCoulomb = new long[size];
        in.readLongArray(this.mAccumulatedChargeMicroCoulomb);
        if (in.readBoolean()) {
            this.mAccumulatedMultiStateChargeMicroCoulomb = new LongMultiStateCounter[size];
            for (int i = 0; i < size; ++i) {
                if (!in.readBoolean()) continue;
                this.mAccumulatedMultiStateChargeMicroCoulomb[i] = LongMultiStateCounter.CREATOR.createFromParcel(in);
            }
        } else {
            this.mAccumulatedMultiStateChargeMicroCoulomb = null;
        }
    }

    public void writeToParcel(Parcel out) {
        out.writeInt(this.mAccumulatedChargeMicroCoulomb.length);
        out.writeLongArray(this.mAccumulatedChargeMicroCoulomb);
        if (this.mAccumulatedMultiStateChargeMicroCoulomb != null) {
            out.writeBoolean(true);
            for (LongMultiStateCounter counter : this.mAccumulatedMultiStateChargeMicroCoulomb) {
                if (counter != null) {
                    out.writeBoolean(true);
                    counter.writeToParcel(out, 0);
                    continue;
                }
                out.writeBoolean(false);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    private void readSummaryFromParcel(Parcel in) {
        int numWrittenEntries = in.readInt();
        for (int entry = 0; entry < numWrittenEntries; ++entry) {
            int index = in.readInt();
            long chargeUC = in.readLong();
            LongMultiStateCounter multiStateCounter = null;
            if (in.readBoolean()) {
                multiStateCounter = LongMultiStateCounter.CREATOR.createFromParcel(in);
                if (this.mConfig == null || multiStateCounter.getStateCount() != this.mConfig.getStateNames().length) {
                    multiStateCounter = null;
                }
            }
            if (index >= this.mAccumulatedChargeMicroCoulomb.length) continue;
            this.setValueIfSupported(index, chargeUC);
            if (multiStateCounter == null) continue;
            if (this.mAccumulatedMultiStateChargeMicroCoulomb == null) {
                this.mAccumulatedMultiStateChargeMicroCoulomb = new LongMultiStateCounter[this.mAccumulatedChargeMicroCoulomb.length];
            }
            this.mAccumulatedMultiStateChargeMicroCoulomb[index] = multiStateCounter;
        }
    }

    private void writeSummaryToParcel(Parcel out) {
        int posOfNumWrittenEntries = out.dataPosition();
        out.writeInt(0);
        int numWrittenEntries = 0;
        for (int index = 0; index < this.mAccumulatedChargeMicroCoulomb.length; ++index) {
            long charge = this.mAccumulatedChargeMicroCoulomb[index];
            if (charge <= 0L) continue;
            out.writeInt(index);
            out.writeLong(charge);
            if (this.mAccumulatedMultiStateChargeMicroCoulomb != null && this.mAccumulatedMultiStateChargeMicroCoulomb[index] != null) {
                out.writeBoolean(true);
                this.mAccumulatedMultiStateChargeMicroCoulomb[index].writeToParcel(out, 0);
            } else {
                out.writeBoolean(false);
            }
            ++numWrittenEntries;
        }
        int currPos = out.dataPosition();
        out.setDataPosition(posOfNumWrittenEntries);
        out.writeInt(numWrittenEntries);
        out.setDataPosition(currPos);
    }

    public void updateStandardBucket(int bucket, long chargeDeltaUC) {
        this.updateStandardBucket(bucket, chargeDeltaUC, 0L);
    }

    public void updateStandardBucket(int bucket, long chargeDeltaUC, long timestampMs) {
        MeasuredEnergyStats.checkValidStandardBucket(bucket);
        this.updateEntry(bucket, chargeDeltaUC, timestampMs);
    }

    public void updateCustomBucket(int customBucket, long chargeDeltaUC) {
        this.updateCustomBucket(customBucket, chargeDeltaUC, 0L);
    }

    public void updateCustomBucket(int customBucket, long chargeDeltaUC, long timestampMs) {
        if (!this.isValidCustomBucket(customBucket)) {
            Slog.e(TAG, "Attempted to update invalid custom bucket " + customBucket);
            return;
        }
        int index = MeasuredEnergyStats.customBucketToIndex(customBucket);
        this.updateEntry(index, chargeDeltaUC, timestampMs);
    }

    private void updateEntry(int index, long chargeDeltaUC, long timestampMs) {
        if (this.mAccumulatedChargeMicroCoulomb[index] >= 0L) {
            int n = index;
            this.mAccumulatedChargeMicroCoulomb[n] = this.mAccumulatedChargeMicroCoulomb[n] + chargeDeltaUC;
            if (this.mState != -1 && this.mConfig.isSupportedMultiStateBucket(index)) {
                LongMultiStateCounter counter;
                if (this.mAccumulatedMultiStateChargeMicroCoulomb == null) {
                    this.mAccumulatedMultiStateChargeMicroCoulomb = new LongMultiStateCounter[this.mAccumulatedChargeMicroCoulomb.length];
                }
                if ((counter = this.mAccumulatedMultiStateChargeMicroCoulomb[index]) == null) {
                    this.mAccumulatedMultiStateChargeMicroCoulomb[index] = counter = new LongMultiStateCounter(this.mConfig.mStateNames.length);
                    counter.setState(this.mState, this.mStateChangeTimestampMs);
                    counter.updateValue(0L, this.mStateChangeTimestampMs);
                }
                counter.updateValue(this.mAccumulatedChargeMicroCoulomb[index], timestampMs);
            }
        } else {
            Slog.wtf(TAG, "Attempting to add " + chargeDeltaUC + " to unavailable bucket " + this.mConfig.getBucketName(index) + " whose value was " + this.mAccumulatedChargeMicroCoulomb[index]);
        }
    }

    public void setState(int state, long timestampMs) {
        this.mState = state;
        this.mStateChangeTimestampMs = timestampMs;
        if (this.mAccumulatedMultiStateChargeMicroCoulomb == null) {
            this.mAccumulatedMultiStateChargeMicroCoulomb = new LongMultiStateCounter[this.mAccumulatedChargeMicroCoulomb.length];
        }
        for (int i = 0; i < this.mAccumulatedMultiStateChargeMicroCoulomb.length; ++i) {
            LongMultiStateCounter counter = this.mAccumulatedMultiStateChargeMicroCoulomb[i];
            if (counter == null && this.mConfig.isSupportedMultiStateBucket(i)) {
                counter = new LongMultiStateCounter(this.mConfig.mStateNames.length);
                counter.updateValue(0L, timestampMs);
                this.mAccumulatedMultiStateChargeMicroCoulomb[i] = counter;
            }
            if (counter == null) continue;
            counter.setState(state, timestampMs);
        }
    }

    public long getAccumulatedStandardBucketCharge(int bucket) {
        MeasuredEnergyStats.checkValidStandardBucket(bucket);
        return this.mAccumulatedChargeMicroCoulomb[bucket];
    }

    public long getAccumulatedStandardBucketCharge(int bucket, int state) {
        if (!this.mConfig.isSupportedMultiStateBucket(bucket)) {
            return -1L;
        }
        if (this.mAccumulatedMultiStateChargeMicroCoulomb == null) {
            return 0L;
        }
        LongMultiStateCounter counter = this.mAccumulatedMultiStateChargeMicroCoulomb[bucket];
        if (counter == null) {
            return 0L;
        }
        return counter.getCount(state);
    }

    @VisibleForTesting
    public long getAccumulatedCustomBucketCharge(int customBucket) {
        if (!this.isValidCustomBucket(customBucket)) {
            return -1L;
        }
        return this.mAccumulatedChargeMicroCoulomb[MeasuredEnergyStats.customBucketToIndex(customBucket)];
    }

    public long[] getAccumulatedCustomBucketCharges() {
        long[] charges = new long[this.getNumberCustomPowerBuckets()];
        for (int bucket = 0; bucket < charges.length; ++bucket) {
            charges[bucket] = this.mAccumulatedChargeMicroCoulomb[MeasuredEnergyStats.customBucketToIndex(bucket)];
        }
        return charges;
    }

    public static int getDisplayPowerBucket(int screenState) {
        if (Display.isOnState(screenState)) {
            return 0;
        }
        if (Display.isDozeState(screenState)) {
            return 1;
        }
        return 2;
    }

    public static MeasuredEnergyStats createAndReadSummaryFromParcel(Config config, Parcel in) {
        int arraySize = in.readInt();
        if (arraySize == 0) {
            return null;
        }
        if (config == null) {
            MeasuredEnergyStats mes = new MeasuredEnergyStats(new Config(new boolean[arraySize], null, new int[0], new String[]{""}));
            mes.readSummaryFromParcel(in);
            return null;
        }
        if (arraySize != config.getNumberOfBuckets()) {
            Slog.wtf(TAG, "Size of MeasuredEnergyStats parcel (" + arraySize + ") does not match config (" + config.getNumberOfBuckets() + ").");
            MeasuredEnergyStats mes = new MeasuredEnergyStats(config);
            mes.readSummaryFromParcel(in);
            return null;
        }
        MeasuredEnergyStats stats = new MeasuredEnergyStats(config);
        stats.readSummaryFromParcel(in);
        if (stats.containsInterestingData()) {
            return stats;
        }
        return null;
    }

    private boolean containsInterestingData() {
        for (int index = 0; index < this.mAccumulatedChargeMicroCoulomb.length; ++index) {
            if (this.mAccumulatedChargeMicroCoulomb[index] <= 0L) continue;
            return true;
        }
        return false;
    }

    public static void writeSummaryToParcel(MeasuredEnergyStats stats, Parcel dest) {
        if (stats == null) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(stats.mConfig.getNumberOfBuckets());
        stats.writeSummaryToParcel(dest);
    }

    private void reset() {
        int numIndices = this.mConfig.getNumberOfBuckets();
        for (int index = 0; index < numIndices; ++index) {
            this.setValueIfSupported(index, 0L);
            if (this.mAccumulatedMultiStateChargeMicroCoulomb == null || this.mAccumulatedMultiStateChargeMicroCoulomb[index] == null) continue;
            this.mAccumulatedMultiStateChargeMicroCoulomb[index].reset();
        }
    }

    public static void resetIfNotNull(MeasuredEnergyStats stats) {
        if (stats != null) {
            stats.reset();
        }
    }

    private void setValueIfSupported(int index, long value) {
        if (this.mAccumulatedChargeMicroCoulomb[index] != -1L) {
            this.mAccumulatedChargeMicroCoulomb[index] = value;
        }
    }

    public boolean isStandardBucketSupported(int bucket) {
        MeasuredEnergyStats.checkValidStandardBucket(bucket);
        return this.isIndexSupported(bucket);
    }

    private boolean isIndexSupported(int index) {
        return this.mAccumulatedChargeMicroCoulomb[index] != -1L;
    }

    public void dump(PrintWriter pw) {
        pw.print("   ");
        for (int index = 0; index < this.mAccumulatedChargeMicroCoulomb.length; ++index) {
            LongMultiStateCounter counter;
            pw.print(this.mConfig.getBucketName(index));
            pw.print(" : ");
            pw.print(this.mAccumulatedChargeMicroCoulomb[index]);
            if (!this.isIndexSupported(index)) {
                pw.print(" (unsupported)");
            }
            if (this.mAccumulatedMultiStateChargeMicroCoulomb != null && (counter = this.mAccumulatedMultiStateChargeMicroCoulomb[index]) != null) {
                pw.print(" [");
                for (int i = 0; i < this.mConfig.mStateNames.length; ++i) {
                    if (i != 0) {
                        pw.print(" ");
                    }
                    pw.print(this.mConfig.mStateNames[i]);
                    pw.print(": ");
                    pw.print(counter.getCount(i));
                }
                pw.print("]");
            }
            if (index == this.mAccumulatedChargeMicroCoulomb.length - 1) continue;
            pw.print(", ");
        }
        pw.println();
    }

    public int getNumberCustomPowerBuckets() {
        return this.mAccumulatedChargeMicroCoulomb.length - 8;
    }

    private static int customBucketToIndex(int customBucket) {
        return customBucket + 8;
    }

    private static int indexToCustomBucket(int index) {
        return index - 8;
    }

    private static void checkValidStandardBucket(int bucket) {
        if (!MeasuredEnergyStats.isValidStandardBucket(bucket)) {
            throw new IllegalArgumentException("Illegal StandardPowerBucket " + bucket);
        }
    }

    private static boolean isValidStandardBucket(int bucket) {
        return bucket >= 0 && bucket < 8;
    }

    @VisibleForTesting
    public boolean isValidCustomBucket(int customBucket) {
        return customBucket >= 0 && MeasuredEnergyStats.customBucketToIndex(customBucket) < this.mAccumulatedChargeMicroCoulomb.length;
    }

    public static class Config {
        private final boolean[] mSupportedStandardBuckets;
        private final String[] mCustomBucketNames;
        private final boolean[] mSupportedMultiStateBuckets;
        private final String[] mStateNames;

        public Config(boolean[] supportedStandardBuckets, String[] customBucketNames, int[] supportedMultiStateBuckets, String[] stateNames) {
            String[] stringArray;
            this.mSupportedStandardBuckets = supportedStandardBuckets;
            this.mCustomBucketNames = customBucketNames != null ? customBucketNames : new String[]{};
            this.mSupportedMultiStateBuckets = new boolean[supportedStandardBuckets.length + this.mCustomBucketNames.length];
            for (int bucket : supportedMultiStateBuckets) {
                if (!this.mSupportedStandardBuckets[bucket]) continue;
                this.mSupportedMultiStateBuckets[bucket] = true;
            }
            if (stateNames != null) {
                stringArray = stateNames;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "";
            }
            this.mStateNames = stringArray;
        }

        public boolean isCompatible(Config other) {
            return Arrays.equals(this.mSupportedStandardBuckets, other.mSupportedStandardBuckets) && Arrays.equals(this.mCustomBucketNames, other.mCustomBucketNames) && Arrays.equals(this.mSupportedMultiStateBuckets, other.mSupportedMultiStateBuckets) && Arrays.equals(this.mStateNames, other.mStateNames);
        }

        public static void writeToParcel(Config config, Parcel out) {
            if (config == null) {
                out.writeBoolean(false);
                return;
            }
            out.writeBoolean(true);
            out.writeInt(config.mSupportedStandardBuckets.length);
            out.writeBooleanArray(config.mSupportedStandardBuckets);
            out.writeStringArray(config.mCustomBucketNames);
            int multiStateBucketCount = 0;
            for (boolean supported : config.mSupportedMultiStateBuckets) {
                if (!supported) continue;
                ++multiStateBucketCount;
            }
            int[] supportedMultiStateBuckets = new int[multiStateBucketCount];
            int index = 0;
            for (int bucket = 0; bucket < config.mSupportedMultiStateBuckets.length; ++bucket) {
                if (!config.mSupportedMultiStateBuckets[bucket]) continue;
                supportedMultiStateBuckets[index++] = bucket;
            }
            out.writeInt(multiStateBucketCount);
            out.writeIntArray(supportedMultiStateBuckets);
            out.writeStringArray(config.mStateNames);
        }

        public static Config createFromParcel(Parcel in) {
            if (!in.readBoolean()) {
                return null;
            }
            int supportedStandardBucketCount = in.readInt();
            boolean[] supportedStandardBuckets = new boolean[supportedStandardBucketCount];
            in.readBooleanArray(supportedStandardBuckets);
            String[] customBucketNames = in.readStringArray();
            int supportedMultiStateBucketCount = in.readInt();
            int[] supportedMultiStateBuckets = new int[supportedMultiStateBucketCount];
            in.readIntArray(supportedMultiStateBuckets);
            String[] stateNames = in.readStringArray();
            return new Config(supportedStandardBuckets, customBucketNames, supportedMultiStateBuckets, stateNames);
        }

        private int getNumberOfBuckets() {
            return this.mSupportedStandardBuckets.length + this.mCustomBucketNames.length;
        }

        public boolean isSupportedBucket(int index) {
            return this.mSupportedStandardBuckets[index];
        }

        public String[] getCustomBucketNames() {
            return this.mCustomBucketNames;
        }

        public boolean isSupportedMultiStateBucket(int index) {
            return this.mSupportedMultiStateBuckets[index];
        }

        public String[] getStateNames() {
            return this.mStateNames;
        }

        private String getBucketName(int index) {
            if (MeasuredEnergyStats.isValidStandardBucket(index)) {
                return DebugUtils.valueToString(MeasuredEnergyStats.class, "POWER_BUCKET_", index);
            }
            int customBucket = MeasuredEnergyStats.indexToCustomBucket(index);
            StringBuilder name = new StringBuilder().append("CUSTOM_").append(customBucket);
            if (!TextUtils.isEmpty(this.mCustomBucketNames[customBucket])) {
                name.append('(').append(this.mCustomBucketNames[customBucket]).append(')');
            }
            return name.toString();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StandardPowerBucket {
    }
}

