/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.SparseArray;
import com.android.internal.os.CpuPowerCalculator;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;

public class SystemServicePowerCalculator
extends PowerCalculator {
    private static final boolean DEBUG = false;
    private static final String TAG = "SystemServicePowerCalc";
    private final UsageBasedPowerEstimator[] mPowerEstimators;
    private final CpuPowerCalculator mCpuPowerCalculator;

    public SystemServicePowerCalculator(PowerProfile powerProfile) {
        this.mCpuPowerCalculator = new CpuPowerCalculator(powerProfile);
        int numFreqs = 0;
        int numCpuClusters = powerProfile.getNumCpuClusters();
        for (int cluster = 0; cluster < numCpuClusters; ++cluster) {
            numFreqs += powerProfile.getNumSpeedStepsInCpuCluster(cluster);
        }
        this.mPowerEstimators = new UsageBasedPowerEstimator[numFreqs];
        int index = 0;
        for (int cluster = 0; cluster < numCpuClusters; ++cluster) {
            int numSpeeds = powerProfile.getNumSpeedStepsInCpuCluster(cluster);
            for (int speed = 0; speed < numSpeeds; ++speed) {
                this.mPowerEstimators[index++] = new UsageBasedPowerEstimator(powerProfile.getAveragePowerForCpuCore(cluster, speed));
            }
        }
    }

    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return powerComponent == 7;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        BatteryStats.Uid systemUid = batteryStats.getUidStats().get(1000);
        if (systemUid == null) {
            return;
        }
        long consumptionUC = systemUid.getCpuMeasuredBatteryConsumptionUC();
        int powerModel = SystemServicePowerCalculator.getPowerModel(consumptionUC, query);
        double systemServicePowerMah = powerModel == 2 ? this.calculatePowerUsingMeasuredConsumption(batteryStats, systemUid, consumptionUC) : this.calculatePowerUsingPowerProfile(batteryStats);
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        UidBatteryConsumer.Builder systemServerConsumer = uidBatteryConsumerBuilders.get(1000);
        if (systemServerConsumer != null) {
            systemServicePowerMah = Math.min(systemServicePowerMah, systemServerConsumer.getTotalPower());
            systemServerConsumer.setConsumedPower(17, -systemServicePowerMah, powerModel);
        }
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            if (app == systemServerConsumer) continue;
            BatteryStats.Uid uid = app.getBatteryStatsUid();
            app.setConsumedPower(7, systemServicePowerMah * uid.getProportionalSystemServiceUsage(), powerModel);
        }
        builder.getAggregateBatteryConsumerBuilder(0).setConsumedPower(7, systemServicePowerMah);
        builder.getAggregateBatteryConsumerBuilder(1).setConsumedPower(7, systemServicePowerMah);
    }

    private double calculatePowerUsingMeasuredConsumption(BatteryStats batteryStats, BatteryStats.Uid systemUid, long consumptionUC) {
        double systemServiceModeledPowerMah = this.calculatePowerUsingPowerProfile(batteryStats);
        double systemUidModeledPowerMah = this.mCpuPowerCalculator.calculateUidModeledPowerMah(systemUid, 0);
        if (systemUidModeledPowerMah > 0.0) {
            return SystemServicePowerCalculator.uCtoMah(consumptionUC) * systemServiceModeledPowerMah / systemUidModeledPowerMah;
        }
        return 0.0;
    }

    private double calculatePowerUsingPowerProfile(BatteryStats batteryStats) {
        long[] systemServiceTimeAtCpuSpeeds = batteryStats.getSystemServiceTimeAtCpuSpeeds();
        if (systemServiceTimeAtCpuSpeeds == null) {
            return 0.0;
        }
        double powerMah = 0.0;
        int size = Math.min(this.mPowerEstimators.length, systemServiceTimeAtCpuSpeeds.length);
        for (int i = 0; i < size; ++i) {
            powerMah += this.mPowerEstimators[i].calculatePower(systemServiceTimeAtCpuSpeeds[i] / 1000L);
        }
        return powerMah;
    }
}

