/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.annotation.optimization.FastNative;
import libcore.util.NativeAllocationRegistry;

public class LongMultiStateCounter
implements Parcelable {
    private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(LongMultiStateCounter.class.getClassLoader(), LongMultiStateCounter.native_getReleaseFunc());
    private final int mStateCount;
    final long mNativeObject;
    public static final Parcelable.Creator<LongMultiStateCounter> CREATOR = new Parcelable.Creator<LongMultiStateCounter>(){

        @Override
        public LongMultiStateCounter createFromParcel(Parcel in) {
            return new LongMultiStateCounter(in);
        }

        public LongMultiStateCounter[] newArray(int size) {
            return new LongMultiStateCounter[size];
        }
    };

    public LongMultiStateCounter(int stateCount) {
        Preconditions.checkArgumentPositive(stateCount, "stateCount must be greater than 0");
        this.mStateCount = stateCount;
        this.mNativeObject = LongMultiStateCounter.native_init(stateCount);
        sRegistry.registerNativeAllocation(this, this.mNativeObject);
    }

    private LongMultiStateCounter(Parcel in) {
        this.mNativeObject = LongMultiStateCounter.native_initFromParcel(in);
        sRegistry.registerNativeAllocation(this, this.mNativeObject);
        this.mStateCount = LongMultiStateCounter.native_getStateCount(this.mNativeObject);
    }

    public int getStateCount() {
        return this.mStateCount;
    }

    public void setEnabled(boolean enabled, long timestampMs) {
        LongMultiStateCounter.native_setEnabled(this.mNativeObject, enabled, timestampMs);
    }

    public void setState(int state, long timestampMs) {
        if (state < 0 || state >= this.mStateCount) {
            throw new IllegalArgumentException("State: " + state + ", outside the range: [0-" + (this.mStateCount - 1) + "]");
        }
        LongMultiStateCounter.native_setState(this.mNativeObject, state, timestampMs);
    }

    public long updateValue(long value, long timestampMs) {
        return LongMultiStateCounter.native_updateValue(this.mNativeObject, value, timestampMs);
    }

    public void incrementValue(long count, long timestampMs) {
        LongMultiStateCounter.native_incrementValue(this.mNativeObject, count, timestampMs);
    }

    public void addCount(long count) {
        LongMultiStateCounter.native_addCount(this.mNativeObject, count);
    }

    public void reset() {
        LongMultiStateCounter.native_reset(this.mNativeObject);
    }

    public long getCount(int state) {
        if (state < 0 || state >= this.mStateCount) {
            throw new IllegalArgumentException("State: " + state + ", outside the range: [0-" + this.mStateCount + "]");
        }
        return LongMultiStateCounter.native_getCount(this.mNativeObject, state);
    }

    public long getTotalCount() {
        long total = 0L;
        for (int state = 0; state < this.mStateCount; ++state) {
            total += LongMultiStateCounter.native_getCount(this.mNativeObject, state);
        }
        return total;
    }

    public String toString() {
        return this.native_toString(this.mNativeObject);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.native_writeToParcel(this.mNativeObject, dest, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @CriticalNative
    private static long native_init(int n) {
        return OverrideMethod.invokeL("com.android.internal.os.LongMultiStateCounter#native_init(I)J", true, null);
    }

    @CriticalNative
    private static long native_getReleaseFunc() {
        return OverrideMethod.invokeL("com.android.internal.os.LongMultiStateCounter#native_getReleaseFunc()J", true, null);
    }

    @CriticalNative
    private static void native_setEnabled(long l, boolean bl, long l2) {
        OverrideMethod.invokeV("com.android.internal.os.LongMultiStateCounter#native_setEnabled(JZJ)V", true, null);
    }

    @CriticalNative
    private static void native_setState(long l, int n, long l2) {
        OverrideMethod.invokeV("com.android.internal.os.LongMultiStateCounter#native_setState(JIJ)V", true, null);
    }

    @CriticalNative
    private static long native_updateValue(long l, long l2, long l3) {
        return OverrideMethod.invokeL("com.android.internal.os.LongMultiStateCounter#native_updateValue(JJJ)J", true, null);
    }

    @CriticalNative
    private static void native_incrementValue(long l, long l2, long l3) {
        OverrideMethod.invokeV("com.android.internal.os.LongMultiStateCounter#native_incrementValue(JJJ)V", true, null);
    }

    @CriticalNative
    private static void native_addCount(long l, long l2) {
        OverrideMethod.invokeV("com.android.internal.os.LongMultiStateCounter#native_addCount(JJ)V", true, null);
    }

    @CriticalNative
    private static void native_reset(long l) {
        OverrideMethod.invokeV("com.android.internal.os.LongMultiStateCounter#native_reset(J)V", true, null);
    }

    @CriticalNative
    private static long native_getCount(long l, int n) {
        return OverrideMethod.invokeL("com.android.internal.os.LongMultiStateCounter#native_getCount(JI)J", true, null);
    }

    @FastNative
    private String native_toString(long l) {
        return (String)OverrideMethod.invokeA("com.android.internal.os.LongMultiStateCounter#native_toString(J)Ljava/lang/String;", true, this);
    }

    @FastNative
    private void native_writeToParcel(long l, Parcel parcel, int n) {
        OverrideMethod.invokeV("com.android.internal.os.LongMultiStateCounter#native_writeToParcel(JLandroid/os/Parcel;I)V", true, this);
    }

    @FastNative
    private static long native_initFromParcel(Parcel parcel) {
        return OverrideMethod.invokeL("com.android.internal.os.LongMultiStateCounter#native_initFromParcel(Landroid/os/Parcel;)J", true, null);
    }

    @CriticalNative
    private static int native_getStateCount(long l) {
        return OverrideMethod.invokeI("com.android.internal.os.LongMultiStateCounter#native_getStateCount(J)I", true, null);
    }
}

