/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import com.android.internal.os.Clock;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class KernelCpuProcStringReader {
    private static final String TAG = KernelCpuProcStringReader.class.getSimpleName();
    private static final int ERROR_THRESHOLD = 5;
    private static final long FRESHNESS = 500L;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final String PROC_UID_FREQ_TIME = "/proc/uid_time_in_state";
    private static final String PROC_UID_ACTIVE_TIME = "/proc/uid_concurrent_active_time";
    private static final String PROC_UID_CLUSTER_TIME = "/proc/uid_concurrent_policy_time";
    private static final String PROC_UID_USER_SYS_TIME = "/proc/uid_cputime/show_uid_stat";
    private static final KernelCpuProcStringReader FREQ_TIME_READER = new KernelCpuProcStringReader("/proc/uid_time_in_state");
    private static final KernelCpuProcStringReader ACTIVE_TIME_READER = new KernelCpuProcStringReader("/proc/uid_concurrent_active_time");
    private static final KernelCpuProcStringReader CLUSTER_TIME_READER = new KernelCpuProcStringReader("/proc/uid_concurrent_policy_time");
    private static final KernelCpuProcStringReader USER_SYS_TIME_READER = new KernelCpuProcStringReader("/proc/uid_cputime/show_uid_stat");
    private int mErrors = 0;
    private final Path mFile;
    private final Clock mClock;
    private char[] mBuf;
    private int mSize;
    private long mLastReadTime = 0L;
    private final ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock mReadLock = this.mLock.readLock();
    private final ReentrantReadWriteLock.WriteLock mWriteLock = this.mLock.writeLock();

    static KernelCpuProcStringReader getFreqTimeReaderInstance() {
        return FREQ_TIME_READER;
    }

    static KernelCpuProcStringReader getActiveTimeReaderInstance() {
        return ACTIVE_TIME_READER;
    }

    static KernelCpuProcStringReader getClusterTimeReaderInstance() {
        return CLUSTER_TIME_READER;
    }

    static KernelCpuProcStringReader getUserSysTimeReaderInstance() {
        return USER_SYS_TIME_READER;
    }

    public KernelCpuProcStringReader(String file) {
        this(file, Clock.SYSTEM_CLOCK);
    }

    public KernelCpuProcStringReader(String file, Clock clock) {
        this.mFile = Paths.get(file, new String[0]);
        this.mClock = clock;
    }

    public ProcFileIterator open() {
        return this.open(false);
    }

    /*
     * Exception decompiling
     */
    public ProcFileIterator open(boolean ignoreCache) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean dataValid() {
        return this.mSize > 0 && this.mClock.elapsedRealtime() - this.mLastReadTime < 500L;
    }

    public static int asLongs(CharBuffer buf, long[] array2) {
        if (buf == null) {
            return -1;
        }
        int initialPos = buf.position();
        int count = 0;
        long num = -1L;
        while (buf.remaining() > 0 && count < array2.length) {
            char c = buf.get();
            if (!KernelCpuProcStringReader.isNumber(c) && c != ' ' && c != ':') {
                buf.position(initialPos);
                return -2;
            }
            if (num < 0L) {
                if (!KernelCpuProcStringReader.isNumber(c)) continue;
                num = c - 48;
                continue;
            }
            if (KernelCpuProcStringReader.isNumber(c)) {
                if ((num = num * 10L + (long)c - 48L) >= 0L) continue;
                buf.position(initialPos);
                return -3;
            }
            array2[count++] = num;
            num = -1L;
        }
        if (num >= 0L) {
            array2[count++] = num;
        }
        buf.position(initialPos);
        return count;
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public class ProcFileIterator
    implements AutoCloseable {
        private final int mSize;
        private int mPos;

        public ProcFileIterator(int size) {
            this.mSize = size;
        }

        public boolean hasNextLine() {
            return this.mPos < this.mSize;
        }

        public CharBuffer nextLine() {
            int i;
            if (this.mPos >= this.mSize) {
                return null;
            }
            for (i = this.mPos; i < this.mSize && KernelCpuProcStringReader.this.mBuf[i] != '\n'; ++i) {
            }
            int start = this.mPos;
            this.mPos = i + 1;
            return CharBuffer.wrap(KernelCpuProcStringReader.this.mBuf, start, i - start);
        }

        public int size() {
            return this.mSize;
        }

        @Override
        public void close() {
            KernelCpuProcStringReader.this.mReadLock.unlock();
        }
    }
}

