/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.SystemClock;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import java.util.ArrayList;

public class CachedDeviceState {
    private volatile boolean mScreenInteractive;
    private volatile boolean mCharging;
    private final Object mStopwatchesLock = new Object();
    @GuardedBy(value={"mStopwatchLock"})
    private final ArrayList<TimeInStateStopwatch> mOnBatteryStopwatches = new ArrayList();

    public CachedDeviceState() {
        this.mCharging = true;
        this.mScreenInteractive = false;
    }

    @VisibleForTesting
    public CachedDeviceState(boolean isCharging, boolean isScreenInteractive) {
        this.mCharging = isCharging;
        this.mScreenInteractive = isScreenInteractive;
    }

    public void setScreenInteractive(boolean screenInteractive) {
        this.mScreenInteractive = screenInteractive;
    }

    public void setCharging(boolean charging) {
        if (this.mCharging != charging) {
            this.mCharging = charging;
            this.updateStopwatches(!charging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStopwatches(boolean shouldStart) {
        Object object = this.mStopwatchesLock;
        synchronized (object) {
            int size = this.mOnBatteryStopwatches.size();
            for (int i = 0; i < size; ++i) {
                if (shouldStart) {
                    this.mOnBatteryStopwatches.get(i).start();
                    continue;
                }
                this.mOnBatteryStopwatches.get(i).stop();
            }
        }
    }

    public Readonly getReadonlyClient() {
        return new Readonly();
    }

    public class TimeInStateStopwatch
    implements AutoCloseable {
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private long mStartTimeMillis;
        @GuardedBy(value={"mLock"})
        private long mTotalTimeMillis;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getMillis() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mTotalTimeMillis + this.elapsedTime();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.mLock;
            synchronized (object) {
                this.mTotalTimeMillis = 0L;
                this.mStartTimeMillis = this.isRunning() ? SystemClock.elapsedRealtime() : 0L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void start() {
            Object object = this.mLock;
            synchronized (object) {
                if (!this.isRunning()) {
                    this.mStartTimeMillis = SystemClock.elapsedRealtime();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stop() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.isRunning()) {
                    this.mTotalTimeMillis += this.elapsedTime();
                    this.mStartTimeMillis = 0L;
                }
            }
        }

        private long elapsedTime() {
            return this.isRunning() ? SystemClock.elapsedRealtime() - this.mStartTimeMillis : 0L;
        }

        @VisibleForTesting
        public boolean isRunning() {
            return this.mStartTimeMillis > 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = CachedDeviceState.this.mStopwatchesLock;
            synchronized (object) {
                CachedDeviceState.this.mOnBatteryStopwatches.remove(this);
            }
        }
    }

    public class Readonly {
        public boolean isCharging() {
            return CachedDeviceState.this.mCharging;
        }

        public boolean isScreenInteractive() {
            return CachedDeviceState.this.mScreenInteractive;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimeInStateStopwatch createTimeOnBatteryStopwatch() {
            Object object = CachedDeviceState.this.mStopwatchesLock;
            synchronized (object) {
                TimeInStateStopwatch stopwatch = new TimeInStateStopwatch();
                CachedDeviceState.this.mOnBatteryStopwatches.add(stopwatch);
                if (!CachedDeviceState.this.mCharging) {
                    stopwatch.start();
                }
                return stopwatch;
            }
        }
    }
}

