/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.IntArray;
import android.util.KeyValueListParser;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.lang.System_Delegate;
import com.android.internal.os.AppIdToPackageMap;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BinderInternal;
import com.android.internal.os.BinderLatencyObserver;
import com.android.internal.os.BinderTransactionNameResolver;
import com.android.internal.os.CachedDeviceState;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.ToDoubleFunction;

public class BinderCallsStats
implements BinderInternal.Observer {
    public static final boolean ENABLED_DEFAULT = true;
    public static final boolean DETAILED_TRACKING_DEFAULT = true;
    public static final int PERIODIC_SAMPLING_INTERVAL_DEFAULT = 1000;
    public static final boolean DEFAULT_TRACK_SCREEN_INTERACTIVE = false;
    public static final boolean DEFAULT_TRACK_DIRECT_CALLING_UID = true;
    public static final boolean DEFAULT_IGNORE_BATTERY_STATUS = false;
    public static final boolean DEFAULT_COLLECT_LATENCY_DATA = true;
    public static final int MAX_BINDER_CALL_STATS_COUNT_DEFAULT = 1500;
    public static final int SHARDING_MODULO_DEFAULT = 1;
    private static final String DEBUG_ENTRY_PREFIX = "__DEBUG_";
    private static final String TAG = "BinderCallsStats";
    private static final int CALL_SESSIONS_POOL_SIZE = 100;
    private static final int MAX_EXCEPTION_COUNT_SIZE = 50;
    private static final String EXCEPTION_COUNT_OVERFLOW_NAME = "overflow";
    private static final Class<? extends Binder> OVERFLOW_BINDER = OverflowBinder.class;
    private static final boolean OVERFLOW_SCREEN_INTERACTIVE = false;
    private static final int OVERFLOW_DIRECT_CALLING_UID = -1;
    private static final int OVERFLOW_TRANSACTION_CODE = -1;
    private boolean mDetailedTracking = true;
    private boolean mRecordingAllTransactionsForUid;
    private int mPeriodicSamplingInterval = 1000;
    private int mMaxBinderCallStatsCount = 1500;
    @GuardedBy(value={"mLock"})
    private final SparseArray<UidEntry> mUidEntries = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final ArrayMap<String, Integer> mExceptionCounts = new ArrayMap();
    private final Queue<BinderInternal.CallSession> mCallSessionsPool = new ConcurrentLinkedQueue<BinderInternal.CallSession>();
    private final Object mLock = new Object();
    private final Random mRandom;
    private long mStartCurrentTime = System_Delegate.currentTimeMillis();
    private long mStartElapsedTime = SystemClock.elapsedRealtime();
    private long mCallStatsCount = 0L;
    private boolean mAddDebugEntries = false;
    private boolean mTrackDirectCallingUid = true;
    private boolean mTrackScreenInteractive = false;
    private boolean mIgnoreBatteryStatus = false;
    private boolean mCollectLatencyData = true;
    private int mShardingModulo = 1;
    private int mShardingOffset;
    private CachedDeviceState.Readonly mDeviceState;
    private CachedDeviceState.TimeInStateStopwatch mBatteryStopwatch;
    private static final int CALL_STATS_OBSERVER_DEBOUNCE_MILLIS = 5000;
    private BinderLatencyObserver mLatencyObserver;
    private BinderInternal.CallStatsObserver mCallStatsObserver;
    private ArraySet<Integer> mSendUidsToObserver = new ArraySet(32);
    private final Handler mCallStatsObserverHandler;
    private Runnable mCallStatsObserverRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (BinderCallsStats.this.mCallStatsObserver == null) {
                return;
            }
            BinderCallsStats.this.noteCallsStatsDelayed();
            Object object = BinderCallsStats.this.mLock;
            synchronized (object) {
                int size = BinderCallsStats.this.mSendUidsToObserver.size();
                for (int i = 0; i < size; ++i) {
                    int j;
                    UidEntry uidEntry = BinderCallsStats.this.mUidEntries.get(BinderCallsStats.this.mSendUidsToObserver.valueAt(i));
                    if (uidEntry == null) continue;
                    ArrayMap<CallStatKey, CallStat> callStats = uidEntry.mCallStats;
                    int csize = callStats.size();
                    ArrayList<CallStat> tmpCallStats = new ArrayList<CallStat>(csize);
                    for (j = 0; j < csize; ++j) {
                        tmpCallStats.add(callStats.valueAt(j).clone());
                    }
                    BinderCallsStats.this.mCallStatsObserver.noteCallStats(uidEntry.workSourceUid, uidEntry.incrementalCallCount, tmpCallStats);
                    uidEntry.incrementalCallCount = 0L;
                    for (j = callStats.size() - 1; j >= 0; --j) {
                        callStats.valueAt((int)j).incrementalCallCount = 0L;
                    }
                }
                BinderCallsStats.this.mSendUidsToObserver.clear();
            }
        }
    };
    private final Object mNativeTidsLock = new Object();
    private volatile IntArray mNativeTids = new IntArray(0);

    public BinderCallsStats(Injector injector) {
        this(injector, 1);
    }

    public BinderCallsStats(Injector injector, int processSource) {
        this.mRandom = injector.getRandomGenerator();
        this.mCallStatsObserverHandler = injector.getHandler();
        this.mLatencyObserver = injector.getLatencyObserver(processSource);
        this.mShardingOffset = this.mRandom.nextInt(this.mShardingModulo);
    }

    public void setDeviceState(CachedDeviceState.Readonly deviceState) {
        if (this.mBatteryStopwatch != null) {
            this.mBatteryStopwatch.close();
        }
        this.mDeviceState = deviceState;
        this.mBatteryStopwatch = deviceState.createTimeOnBatteryStopwatch();
    }

    public void setCallStatsObserver(BinderInternal.CallStatsObserver callStatsObserver) {
        this.mCallStatsObserver = callStatsObserver;
        this.noteBinderThreadNativeIds();
        this.noteCallsStatsDelayed();
    }

    private void noteCallsStatsDelayed() {
        this.mCallStatsObserverHandler.removeCallbacks(this.mCallStatsObserverRunnable);
        if (this.mCallStatsObserver != null) {
            this.mCallStatsObserverHandler.postDelayed(this.mCallStatsObserverRunnable, 5000L);
        }
    }

    @Override
    public BinderInternal.CallSession callStarted(Binder binder, int code, int workSourceUid) {
        this.noteNativeThreadId();
        boolean collectCpu = this.canCollect();
        if (!this.mCollectLatencyData && !collectCpu) {
            return null;
        }
        BinderInternal.CallSession s = this.obtainCallSession();
        s.binderClass = binder.getClass();
        s.transactionCode = code;
        s.exceptionThrown = false;
        s.cpuTimeStarted = -1L;
        s.timeStarted = -1L;
        s.recordedCall = this.shouldRecordDetailedData();
        if (collectCpu && (this.mRecordingAllTransactionsForUid || s.recordedCall)) {
            s.cpuTimeStarted = this.getThreadTimeMicro();
            s.timeStarted = this.getElapsedRealtimeMicro();
        } else if (this.mCollectLatencyData) {
            s.timeStarted = this.getElapsedRealtimeMicro();
        }
        return s;
    }

    private BinderInternal.CallSession obtainCallSession() {
        BinderInternal.CallSession s = this.mCallSessionsPool.poll();
        return s == null ? new BinderInternal.CallSession() : s;
    }

    @Override
    public void callEnded(BinderInternal.CallSession s, int parcelRequestSize, int parcelReplySize, int workSourceUid) {
        if (s == null) {
            return;
        }
        this.processCallEnded(s, parcelRequestSize, parcelReplySize, workSourceUid);
        if (this.mCallSessionsPool.size() < 100) {
            this.mCallSessionsPool.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCallEnded(BinderInternal.CallSession s, int parcelRequestSize, int parcelReplySize, int workSourceUid) {
        long latencyDuration;
        long duration;
        boolean recordCall;
        if (this.mCollectLatencyData) {
            this.mLatencyObserver.callEnded(s);
        }
        if (!this.canCollect()) {
            return;
        }
        UidEntry uidEntry = null;
        if (s.recordedCall) {
            recordCall = true;
        } else if (this.mRecordingAllTransactionsForUid) {
            uidEntry = this.getUidEntry(workSourceUid);
            recordCall = uidEntry.recordAllTransactions;
        } else {
            recordCall = false;
        }
        if (recordCall) {
            duration = this.getThreadTimeMicro() - s.cpuTimeStarted;
            latencyDuration = this.getElapsedRealtimeMicro() - s.timeStarted;
        } else {
            duration = 0L;
            latencyDuration = 0L;
        }
        boolean screenInteractive = this.mTrackScreenInteractive ? this.mDeviceState.isScreenInteractive() : false;
        int callingUid = this.mTrackDirectCallingUid ? this.getCallingUid() : -1;
        Object object = this.mLock;
        synchronized (object) {
            if (!this.canCollect()) {
                return;
            }
            if (uidEntry == null) {
                uidEntry = this.getUidEntry(workSourceUid);
            }
            ++uidEntry.callCount;
            ++uidEntry.incrementalCallCount;
            if (recordCall) {
                boolean isNewCallStat;
                uidEntry.cpuTimeMicros += duration;
                ++uidEntry.recordedCallCount;
                CallStat callStat = uidEntry.getOrCreate(callingUid, s.binderClass, s.transactionCode, screenInteractive, this.mCallStatsCount >= (long)this.mMaxBinderCallStatsCount);
                boolean bl = isNewCallStat = callStat.callCount == 0L;
                if (isNewCallStat) {
                    ++this.mCallStatsCount;
                }
                ++callStat.callCount;
                ++callStat.incrementalCallCount;
                ++callStat.recordedCallCount;
                callStat.cpuTimeMicros += duration;
                callStat.maxCpuTimeMicros = Math.max(callStat.maxCpuTimeMicros, duration);
                callStat.latencyMicros += latencyDuration;
                callStat.maxLatencyMicros = Math.max(callStat.maxLatencyMicros, latencyDuration);
                if (this.mDetailedTracking) {
                    callStat.exceptionCount = callStat.exceptionCount + (s.exceptionThrown ? 1L : 0L);
                    callStat.maxRequestSizeBytes = Math.max(callStat.maxRequestSizeBytes, (long)parcelRequestSize);
                    callStat.maxReplySizeBytes = Math.max(callStat.maxReplySizeBytes, (long)parcelReplySize);
                }
            } else {
                CallStat callStat = uidEntry.get(callingUid, s.binderClass, s.transactionCode, screenInteractive);
                if (callStat != null) {
                    ++callStat.callCount;
                    ++callStat.incrementalCallCount;
                }
            }
            if (this.mCallStatsObserver != null && !UserHandle.isCore(workSourceUid)) {
                this.mSendUidsToObserver.add(workSourceUid);
            }
        }
    }

    private boolean shouldExport(ExportedCallStat e, boolean applySharding) {
        if (!applySharding) {
            return true;
        }
        int hash = e.binderClass.hashCode();
        hash = 31 * hash + e.transactionCode;
        hash = 31 * hash + e.callingUid;
        hash = 31 * hash + (e.screenInteractive ? 1231 : 1237);
        return (hash + this.mShardingOffset) % this.mShardingModulo == 0;
    }

    private UidEntry getUidEntry(int uid) {
        UidEntry uidEntry = this.mUidEntries.get(uid);
        if (uidEntry == null) {
            uidEntry = new UidEntry(uid);
            this.mUidEntries.put(uid, uidEntry);
        }
        return uidEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callThrewException(BinderInternal.CallSession s, Exception exception) {
        if (s == null) {
            return;
        }
        s.exceptionThrown = true;
        try {
            String className = exception.getClass().getName();
            Object object = this.mLock;
            synchronized (object) {
                Integer count;
                if (this.mExceptionCounts.size() >= 50) {
                    className = EXCEPTION_COUNT_OVERFLOW_NAME;
                }
                this.mExceptionCounts.put(className, (count = this.mExceptionCounts.get(className)) == null ? 1 : count + 1);
            }
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unexpected exception while updating mExceptionCounts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteNativeThreadId() {
        int tid = this.getNativeTid();
        int index = this.mNativeTids.binarySearch(tid);
        if (index >= 0) {
            return;
        }
        Object object = this.mNativeTidsLock;
        synchronized (object) {
            IntArray nativeTids = this.mNativeTids;
            index = nativeTids.binarySearch(tid);
            if (index < 0) {
                IntArray copyOnWriteArray = new IntArray(nativeTids.size() + 1);
                copyOnWriteArray.addAll(nativeTids);
                copyOnWriteArray.add(-index - 1, tid);
                this.mNativeTids = copyOnWriteArray;
            }
        }
        this.noteBinderThreadNativeIds();
    }

    private void noteBinderThreadNativeIds() {
        if (this.mCallStatsObserver == null) {
            return;
        }
        this.mCallStatsObserver.noteBinderThreadNativeIds(this.getNativeTids());
    }

    private boolean canCollect() {
        if (this.mRecordingAllTransactionsForUid) {
            return true;
        }
        if (this.mIgnoreBatteryStatus) {
            return true;
        }
        if (this.mDeviceState == null) {
            return false;
        }
        return !this.mDeviceState.isCharging();
    }

    public ArrayList<ExportedCallStat> getExportedCallStats() {
        return this.getExportedCallStats(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public ArrayList<ExportedCallStat> getExportedCallStats(boolean applySharding) {
        if (!this.mDetailedTracking) {
            return new ArrayList<ExportedCallStat>();
        }
        ArrayList<ExportedCallStat> resultCallStats = new ArrayList<ExportedCallStat>();
        Object object = this.mLock;
        synchronized (object) {
            int uidEntriesSize = this.mUidEntries.size();
            for (int entryIdx = 0; entryIdx < uidEntriesSize; ++entryIdx) {
                UidEntry entry = this.mUidEntries.valueAt(entryIdx);
                for (CallStat stat : entry.getCallStatsList()) {
                    ExportedCallStat e = this.getExportedCallStat(entry.workSourceUid, stat);
                    if (!this.shouldExport(e, applySharding)) continue;
                    resultCallStats.add(e);
                }
            }
        }
        this.resolveBinderMethodNames(resultCallStats);
        if (this.mAddDebugEntries && this.mBatteryStopwatch != null) {
            resultCallStats.add(this.createDebugEntry("start_time_millis", this.mStartElapsedTime));
            resultCallStats.add(this.createDebugEntry("end_time_millis", SystemClock.elapsedRealtime()));
            resultCallStats.add(this.createDebugEntry("battery_time_millis", this.mBatteryStopwatch.getMillis()));
            resultCallStats.add(this.createDebugEntry("sampling_interval", this.mPeriodicSamplingInterval));
            resultCallStats.add(this.createDebugEntry("sharding_modulo", this.mShardingModulo));
        }
        return resultCallStats;
    }

    public ArrayList<ExportedCallStat> getExportedCallStats(int workSourceUid) {
        return this.getExportedCallStats(workSourceUid, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public ArrayList<ExportedCallStat> getExportedCallStats(int workSourceUid, boolean applySharding) {
        ArrayList<ExportedCallStat> resultCallStats = new ArrayList<ExportedCallStat>();
        Object object = this.mLock;
        synchronized (object) {
            UidEntry entry = this.getUidEntry(workSourceUid);
            for (CallStat stat : entry.getCallStatsList()) {
                ExportedCallStat e = this.getExportedCallStat(workSourceUid, stat);
                if (!this.shouldExport(e, applySharding)) continue;
                resultCallStats.add(e);
            }
        }
        this.resolveBinderMethodNames(resultCallStats);
        return resultCallStats;
    }

    private ExportedCallStat getExportedCallStat(int workSourceUid, CallStat stat) {
        ExportedCallStat exported = new ExportedCallStat();
        exported.workSourceUid = workSourceUid;
        exported.callingUid = stat.callingUid;
        exported.className = stat.binderClass.getName();
        exported.binderClass = stat.binderClass;
        exported.transactionCode = stat.transactionCode;
        exported.screenInteractive = stat.screenInteractive;
        exported.cpuTimeMicros = stat.cpuTimeMicros;
        exported.maxCpuTimeMicros = stat.maxCpuTimeMicros;
        exported.latencyMicros = stat.latencyMicros;
        exported.maxLatencyMicros = stat.maxLatencyMicros;
        exported.recordedCallCount = stat.recordedCallCount;
        exported.callCount = stat.callCount;
        exported.maxRequestSizeBytes = stat.maxRequestSizeBytes;
        exported.maxReplySizeBytes = stat.maxReplySizeBytes;
        exported.exceptionCount = stat.exceptionCount;
        return exported;
    }

    private void resolveBinderMethodNames(ArrayList<ExportedCallStat> resultCallStats) {
        ExportedCallStat previous = null;
        String previousMethodName = null;
        resultCallStats.sort(BinderCallsStats::compareByBinderClassAndCode);
        BinderTransactionNameResolver resolver = new BinderTransactionNameResolver();
        for (ExportedCallStat exported : resultCallStats) {
            boolean isClassDifferent = previous == null || !previous.className.equals(exported.className);
            boolean isCodeDifferent = previous == null || previous.transactionCode != exported.transactionCode;
            String methodName = isClassDifferent || isCodeDifferent ? resolver.getMethodName(exported.binderClass, exported.transactionCode) : previousMethodName;
            previousMethodName = methodName;
            exported.methodName = methodName;
            previous = exported;
        }
    }

    private ExportedCallStat createDebugEntry(String variableName, long value) {
        int uid = Process.myUid();
        ExportedCallStat callStat = new ExportedCallStat();
        callStat.className = "";
        callStat.workSourceUid = uid;
        callStat.callingUid = uid;
        callStat.recordedCallCount = 1L;
        callStat.callCount = 1L;
        callStat.methodName = DEBUG_ENTRY_PREFIX + variableName;
        callStat.latencyMicros = value;
        return callStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayMap<String, Integer> getExportedExceptionStats() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayMap<String, Integer>(this.mExceptionCounts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, AppIdToPackageMap packageMap, int workSourceUid, boolean verbose) {
        Object object = this.mLock;
        synchronized (object) {
            this.dumpLocked(pw, packageMap, workSourceUid, verbose);
        }
    }

    private void dumpLocked(PrintWriter pw, AppIdToPackageMap packageMap, int workSourceUid, boolean verbose) {
        if (workSourceUid != -1) {
            verbose = true;
        }
        pw.print("Start time: ");
        pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", this.mStartCurrentTime));
        pw.print("On battery time (ms): ");
        pw.println(this.mBatteryStopwatch != null ? this.mBatteryStopwatch.getMillis() : 0L);
        pw.println("Sampling interval period: " + this.mPeriodicSamplingInterval);
        pw.println("Sharding modulo: " + this.mShardingModulo);
        String datasetSizeDesc = verbose ? "" : "(top 90% by cpu time) ";
        StringBuilder sb = new StringBuilder();
        pw.println("Per-UID raw data " + datasetSizeDesc + "(package/uid, worksource, call_desc, screen_interactive, cpu_time_micros, max_cpu_time_micros, latency_time_micros, max_latency_time_micros, exception_count, max_request_size_bytes, max_reply_size_bytes, recorded_call_count, call_count):");
        ArrayList<ExportedCallStat> exportedCallStats = workSourceUid != -1 ? this.getExportedCallStats(workSourceUid, true) : this.getExportedCallStats(true);
        exportedCallStats.sort(BinderCallsStats::compareByCpuDesc);
        for (ExportedCallStat e3 : exportedCallStats) {
            if (e3.methodName != null && e3.methodName.startsWith(DEBUG_ENTRY_PREFIX)) continue;
            sb.setLength(0);
            sb.append("    ").append(packageMap.mapUid(e3.callingUid)).append(',').append(packageMap.mapUid(e3.workSourceUid)).append(',').append(e3.className).append('#').append(e3.methodName).append(',').append(e3.screenInteractive).append(',').append(e3.cpuTimeMicros).append(',').append(e3.maxCpuTimeMicros).append(',').append(e3.latencyMicros).append(',').append(e3.maxLatencyMicros).append(',').append(this.mDetailedTracking ? e3.exceptionCount : 95L).append(',').append(this.mDetailedTracking ? e3.maxRequestSizeBytes : 95L).append(',').append(this.mDetailedTracking ? e3.maxReplySizeBytes : 95L).append(',').append(e3.recordedCallCount).append(',').append(e3.callCount);
            pw.println(sb);
        }
        pw.println();
        ArrayList<UidEntry> entries = new ArrayList<UidEntry>();
        long totalCallsCount = 0L;
        long totalRecordedCallsCount = 0L;
        long totalCpuTime = 0L;
        if (workSourceUid != -1) {
            UidEntry e4 = this.getUidEntry(workSourceUid);
            entries.add(e4);
            totalCpuTime += e4.cpuTimeMicros;
            totalRecordedCallsCount += e4.recordedCallCount;
            totalCallsCount += e4.callCount;
        } else {
            int uidEntriesSize = this.mUidEntries.size();
            for (int i = 0; i < uidEntriesSize; ++i) {
                UidEntry e5 = this.mUidEntries.valueAt(i);
                entries.add(e5);
                totalCpuTime += e5.cpuTimeMicros;
                totalRecordedCallsCount += e5.recordedCallCount;
                totalCallsCount += e5.callCount;
            }
            entries.sort(Comparator.comparingDouble(value -> value.cpuTimeMicros).reversed());
        }
        pw.println("Per-UID Summary " + datasetSizeDesc + "(cpu_time, % of total cpu_time, recorded_call_count, call_count, package/uid):");
        ArrayList<UidEntry> summaryEntries = verbose ? entries : BinderCallsStats.getHighestValues(entries, value -> value.cpuTimeMicros, 0.9);
        for (UidEntry entry : summaryEntries) {
            String uidStr = packageMap.mapUid(entry.workSourceUid);
            pw.println(String.format("  %10d %3.0f%% %8d %8d %s", entry.cpuTimeMicros, 100.0 * (double)entry.cpuTimeMicros / (double)totalCpuTime, entry.recordedCallCount, entry.callCount, uidStr));
        }
        pw.println();
        if (workSourceUid == -1) {
            pw.println(String.format("  Summary: total_cpu_time=%d, calls_count=%d, avg_call_cpu_time=%.0f", totalCpuTime, totalCallsCount, (double)totalCpuTime / (double)totalRecordedCallsCount));
            pw.println();
        }
        pw.println("Exceptions thrown (exception_count, class_name):");
        ArrayList exceptionEntries = new ArrayList();
        this.mExceptionCounts.entrySet().iterator().forEachRemaining(e -> exceptionEntries.add(Pair.create((String)e.getKey(), (Integer)e.getValue())));
        exceptionEntries.sort((e1, e2) -> Integer.compare((Integer)e2.second, (Integer)e1.second));
        for (Pair entry : exceptionEntries) {
            pw.println(String.format("  %6d %s", entry.second, entry.first));
        }
        if (this.mPeriodicSamplingInterval != 1) {
            pw.println("");
            pw.println("/!\\ Displayed data is sampled. See sampling interval at the top.");
        }
    }

    protected long getThreadTimeMicro() {
        return SystemClock.currentThreadTimeMicro();
    }

    protected int getCallingUid() {
        return Binder.getCallingUid();
    }

    protected int getNativeTid() {
        return Process.myTid();
    }

    public int[] getNativeTids() {
        return this.mNativeTids.toArray();
    }

    protected long getElapsedRealtimeMicro() {
        return SystemClock.elapsedRealtimeNanos() / 1000L;
    }

    protected boolean shouldRecordDetailedData() {
        return this.mRandom.nextInt() % this.mPeriodicSamplingInterval == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDetailedTracking(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (enabled != this.mDetailedTracking) {
                this.mDetailedTracking = enabled;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackScreenInteractive(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (enabled != this.mTrackScreenInteractive) {
                this.mTrackScreenInteractive = enabled;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrackDirectCallerUid(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            if (enabled != this.mTrackDirectCallingUid) {
                this.mTrackDirectCallingUid = enabled;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnoreBatteryStatus(boolean ignored) {
        Object object = this.mLock;
        synchronized (object) {
            if (ignored != this.mIgnoreBatteryStatus) {
                this.mIgnoreBatteryStatus = ignored;
                this.reset();
            }
        }
    }

    public void recordAllCallsForWorkSourceUid(int workSourceUid) {
        this.setDetailedTracking(true);
        Slog.i(TAG, "Recording all Binder calls for UID: " + workSourceUid);
        UidEntry uidEntry = this.getUidEntry(workSourceUid);
        uidEntry.recordAllTransactions = true;
        this.mRecordingAllTransactionsForUid = true;
    }

    public void setAddDebugEntries(boolean addDebugEntries) {
        this.mAddDebugEntries = addDebugEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBinderCallStats(int maxKeys) {
        if (maxKeys <= 0) {
            Slog.w(TAG, "Ignored invalid max value (value must be positive): " + maxKeys);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (maxKeys != this.mMaxBinderCallStatsCount) {
                this.mMaxBinderCallStatsCount = maxKeys;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSamplingInterval(int samplingInterval) {
        if (samplingInterval <= 0) {
            Slog.w(TAG, "Ignored invalid sampling interval (value must be positive): " + samplingInterval);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (samplingInterval != this.mPeriodicSamplingInterval) {
                this.mPeriodicSamplingInterval = samplingInterval;
                this.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShardingModulo(int shardingModulo) {
        if (shardingModulo <= 0) {
            Slog.w(TAG, "Ignored invalid sharding modulo (value must be positive): " + shardingModulo);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (shardingModulo != this.mShardingModulo) {
                this.mShardingModulo = shardingModulo;
                this.mShardingOffset = this.mRandom.nextInt(shardingModulo);
                this.reset();
            }
        }
    }

    public void setCollectLatencyData(boolean collectLatencyData) {
        this.mCollectLatencyData = collectLatencyData;
    }

    @VisibleForTesting
    public boolean getCollectLatencyData() {
        return this.mCollectLatencyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCallStatsCount = 0L;
            this.mUidEntries.clear();
            this.mExceptionCounts.clear();
            this.mStartCurrentTime = System_Delegate.currentTimeMillis();
            this.mStartElapsedTime = SystemClock.elapsedRealtime();
            if (this.mBatteryStopwatch != null) {
                this.mBatteryStopwatch.reset();
            }
            this.mRecordingAllTransactionsForUid = false;
        }
    }

    @VisibleForTesting
    public SparseArray<UidEntry> getUidEntries() {
        return this.mUidEntries;
    }

    @VisibleForTesting
    public ArrayMap<String, Integer> getExceptionCounts() {
        return this.mExceptionCounts;
    }

    public BinderLatencyObserver getLatencyObserver() {
        return this.mLatencyObserver;
    }

    @VisibleForTesting
    public static <T> List<T> getHighestValues(List<T> list, ToDoubleFunction<T> toDouble, double percentile) {
        ArrayList<T> sortedList = new ArrayList<T>(list);
        sortedList.sort(Comparator.comparingDouble(toDouble).reversed());
        double total = 0.0;
        for (T item : list) {
            total += toDouble.applyAsDouble(item);
        }
        ArrayList result = new ArrayList();
        double runningSum = 0.0;
        for (Object item : sortedList) {
            if (runningSum > percentile * total) break;
            result.add(item);
            runningSum += toDouble.applyAsDouble(item);
        }
        return result;
    }

    private static int compareByCpuDesc(ExportedCallStat a, ExportedCallStat b) {
        return Long.compare(b.cpuTimeMicros, a.cpuTimeMicros);
    }

    private static int compareByBinderClassAndCode(ExportedCallStat a, ExportedCallStat b) {
        int result = a.className.compareTo(b.className);
        return result != 0 ? result : Integer.compare(a.transactionCode, b.transactionCode);
    }

    public static void startForBluetooth(Context context) {
        new SettingsObserver(context, new BinderCallsStats(new Injector(), 3));
    }

    public static class SettingsObserver
    extends ContentObserver {
        public static final String SETTINGS_ENABLED_KEY = "enabled";
        public static final String SETTINGS_DETAILED_TRACKING_KEY = "detailed_tracking";
        public static final String SETTINGS_UPLOAD_DATA_KEY = "upload_data";
        public static final String SETTINGS_SAMPLING_INTERVAL_KEY = "sampling_interval";
        public static final String SETTINGS_TRACK_SCREEN_INTERACTIVE_KEY = "track_screen_state";
        public static final String SETTINGS_TRACK_DIRECT_CALLING_UID_KEY = "track_calling_uid";
        public static final String SETTINGS_MAX_CALL_STATS_KEY = "max_call_stats_count";
        public static final String SETTINGS_IGNORE_BATTERY_STATUS_KEY = "ignore_battery_status";
        public static final String SETTINGS_SHARDING_MODULO_KEY = "sharding_modulo";
        public static final String SETTINGS_COLLECT_LATENCY_DATA_KEY = "collect_latency_data";
        public static final String SETTINGS_LATENCY_OBSERVER_SAMPLING_INTERVAL_KEY = "latency_observer_sampling_interval";
        public static final String SETTINGS_LATENCY_OBSERVER_SHARDING_MODULO_KEY = "latency_observer_sharding_modulo";
        public static final String SETTINGS_LATENCY_OBSERVER_PUSH_INTERVAL_MINUTES_KEY = "latency_observer_push_interval_minutes";
        public static final String SETTINGS_LATENCY_HISTOGRAM_BUCKET_COUNT_KEY = "latency_histogram_bucket_count";
        public static final String SETTINGS_LATENCY_HISTOGRAM_FIRST_BUCKET_SIZE_KEY = "latency_histogram_first_bucket_size";
        public static final String SETTINGS_LATENCY_HISTOGRAM_BUCKET_SCALE_FACTOR_KEY = "latency_histogram_bucket_scale_factor";
        private boolean mEnabled;
        private final Uri mUri = Settings.Global.getUriFor("binder_calls_stats");
        private final Context mContext;
        private final KeyValueListParser mParser = new KeyValueListParser(',');
        private final BinderCallsStats mBinderCallsStats;

        public SettingsObserver(Context context, BinderCallsStats binderCallsStats) {
            super(BackgroundThread.getHandler());
            this.mContext = context;
            context.getContentResolver().registerContentObserver(this.mUri, false, this);
            this.mBinderCallsStats = binderCallsStats;
            this.onChange();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (this.mUri.equals(uri)) {
                this.onChange();
            }
        }

        void onChange() {
            try {
                this.mParser.setString(Settings.Global.getString(this.mContext.getContentResolver(), "binder_calls_stats"));
            }
            catch (IllegalArgumentException e) {
                Slog.e(BinderCallsStats.TAG, "Bad binder call stats settings", e);
            }
            this.mBinderCallsStats.setDetailedTracking(false);
            this.mBinderCallsStats.setTrackScreenInteractive(false);
            this.mBinderCallsStats.setTrackDirectCallerUid(false);
            this.mBinderCallsStats.setIgnoreBatteryStatus(this.mParser.getBoolean(SETTINGS_IGNORE_BATTERY_STATUS_KEY, false));
            this.mBinderCallsStats.setCollectLatencyData(this.mParser.getBoolean(SETTINGS_COLLECT_LATENCY_DATA_KEY, true));
            SettingsObserver.configureLatencyObserver(this.mParser, this.mBinderCallsStats.getLatencyObserver());
            boolean enabled = this.mParser.getBoolean(SETTINGS_ENABLED_KEY, true);
            if (this.mEnabled != enabled) {
                if (enabled) {
                    Binder.setObserver(this.mBinderCallsStats);
                } else {
                    Binder.setObserver(null);
                }
                this.mEnabled = enabled;
                this.mBinderCallsStats.reset();
                this.mBinderCallsStats.setAddDebugEntries(enabled);
                this.mBinderCallsStats.getLatencyObserver().reset();
            }
        }

        public static void configureLatencyObserver(KeyValueListParser mParser, BinderLatencyObserver binderLatencyObserver) {
            binderLatencyObserver.setSamplingInterval(mParser.getInt(SETTINGS_LATENCY_OBSERVER_SAMPLING_INTERVAL_KEY, 10));
            binderLatencyObserver.setShardingModulo(mParser.getInt(SETTINGS_LATENCY_OBSERVER_SHARDING_MODULO_KEY, 1));
            binderLatencyObserver.setHistogramBucketsParams(mParser.getInt(SETTINGS_LATENCY_HISTOGRAM_BUCKET_COUNT_KEY, 100), mParser.getInt(SETTINGS_LATENCY_HISTOGRAM_FIRST_BUCKET_SIZE_KEY, 5), mParser.getFloat(SETTINGS_LATENCY_HISTOGRAM_BUCKET_SCALE_FACTOR_KEY, 1.125f));
            binderLatencyObserver.setPushInterval(mParser.getInt(SETTINGS_LATENCY_OBSERVER_PUSH_INTERVAL_MINUTES_KEY, 360));
        }
    }

    @VisibleForTesting
    public static class UidEntry {
        public int workSourceUid;
        public long recordedCallCount;
        public long callCount;
        public long cpuTimeMicros;
        public long incrementalCallCount;
        public boolean recordAllTransactions;
        private ArrayMap<CallStatKey, CallStat> mCallStats = new ArrayMap();
        private CallStatKey mTempKey = new CallStatKey();

        UidEntry(int uid) {
            this.workSourceUid = uid;
        }

        CallStat get(int callingUid, Class<? extends Binder> binderClass, int transactionCode, boolean screenInteractive) {
            this.mTempKey.callingUid = callingUid;
            this.mTempKey.binderClass = binderClass;
            this.mTempKey.transactionCode = transactionCode;
            this.mTempKey.screenInteractive = screenInteractive;
            return this.mCallStats.get(this.mTempKey);
        }

        CallStat getOrCreate(int callingUid, Class<? extends Binder> binderClass, int transactionCode, boolean screenInteractive, boolean maxCallStatsReached) {
            CallStat mapCallStat = this.get(callingUid, binderClass, transactionCode, screenInteractive);
            if (mapCallStat == null) {
                if (maxCallStatsReached) {
                    mapCallStat = this.get(-1, OVERFLOW_BINDER, -1, false);
                    if (mapCallStat != null) {
                        return mapCallStat;
                    }
                    callingUid = -1;
                    binderClass = OVERFLOW_BINDER;
                    transactionCode = -1;
                    screenInteractive = false;
                }
                mapCallStat = new CallStat(callingUid, binderClass, transactionCode, screenInteractive);
                CallStatKey key = new CallStatKey();
                key.callingUid = callingUid;
                key.binderClass = binderClass;
                key.transactionCode = transactionCode;
                key.screenInteractive = screenInteractive;
                this.mCallStats.put(key, mapCallStat);
            }
            return mapCallStat;
        }

        public Collection<CallStat> getCallStatsList() {
            return this.mCallStats.values();
        }

        public String toString() {
            return "UidEntry{cpuTimeMicros=" + this.cpuTimeMicros + ", callCount=" + this.callCount + ", mCallStats=" + this.mCallStats + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            UidEntry uidEntry = (UidEntry)o;
            return this.workSourceUid == uidEntry.workSourceUid;
        }

        public int hashCode() {
            return this.workSourceUid;
        }
    }

    public static class CallStatKey {
        public int callingUid;
        public Class<? extends Binder> binderClass;
        public int transactionCode;
        private boolean screenInteractive;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            CallStatKey key = (CallStatKey)o;
            return this.callingUid == key.callingUid && this.transactionCode == key.transactionCode && this.screenInteractive == key.screenInteractive && this.binderClass.equals(key.binderClass);
        }

        public int hashCode() {
            int result = this.binderClass.hashCode();
            result = 31 * result + this.transactionCode;
            result = 31 * result + this.callingUid;
            result = 31 * result + (this.screenInteractive ? 1231 : 1237);
            return result;
        }
    }

    @VisibleForTesting
    public static class CallStat {
        public final int callingUid;
        public final Class<? extends Binder> binderClass;
        public final int transactionCode;
        public final boolean screenInteractive;
        public long recordedCallCount;
        public long callCount;
        public long cpuTimeMicros;
        public long maxCpuTimeMicros;
        public long latencyMicros;
        public long maxLatencyMicros;
        public long maxRequestSizeBytes;
        public long maxReplySizeBytes;
        public long exceptionCount;
        public long incrementalCallCount;

        public CallStat(int callingUid, Class<? extends Binder> binderClass, int transactionCode, boolean screenInteractive) {
            this.callingUid = callingUid;
            this.binderClass = binderClass;
            this.transactionCode = transactionCode;
            this.screenInteractive = screenInteractive;
        }

        public CallStat clone() {
            CallStat clone = new CallStat(this.callingUid, this.binderClass, this.transactionCode, this.screenInteractive);
            clone.recordedCallCount = this.recordedCallCount;
            clone.callCount = this.callCount;
            clone.cpuTimeMicros = this.cpuTimeMicros;
            clone.maxCpuTimeMicros = this.maxCpuTimeMicros;
            clone.latencyMicros = this.latencyMicros;
            clone.maxLatencyMicros = this.maxLatencyMicros;
            clone.maxRequestSizeBytes = this.maxRequestSizeBytes;
            clone.maxReplySizeBytes = this.maxReplySizeBytes;
            clone.exceptionCount = this.exceptionCount;
            clone.incrementalCallCount = this.incrementalCallCount;
            return clone;
        }

        public String toString() {
            String methodName = new BinderTransactionNameResolver().getMethodName(this.binderClass, this.transactionCode);
            return "CallStat{callingUid=" + this.callingUid + ", transaction=" + this.binderClass.getSimpleName() + '.' + methodName + ", callCount=" + this.callCount + ", incrementalCallCount=" + this.incrementalCallCount + ", recordedCallCount=" + this.recordedCallCount + ", cpuTimeMicros=" + this.cpuTimeMicros + ", latencyMicros=" + this.latencyMicros + '}';
        }
    }

    public static class ExportedCallStat {
        public int callingUid;
        public int workSourceUid;
        public String className;
        public String methodName;
        public boolean screenInteractive;
        public long cpuTimeMicros;
        public long maxCpuTimeMicros;
        public long latencyMicros;
        public long maxLatencyMicros;
        public long callCount;
        public long recordedCallCount;
        public long maxRequestSizeBytes;
        public long maxReplySizeBytes;
        public long exceptionCount;
        Class<? extends Binder> binderClass;
        int transactionCode;
    }

    public static class Injector {
        public Random getRandomGenerator() {
            return new Random();
        }

        public Handler getHandler() {
            return new Handler(Looper.getMainLooper());
        }

        public BinderLatencyObserver getLatencyObserver(int processSource) {
            return new BinderLatencyObserver(new BinderLatencyObserver.Injector(), processSource);
        }
    }

    private static class OverflowBinder
    extends Binder {
        private OverflowBinder() {
        }
    }
}

