/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import com.android.internal.os.PowerCalculator;

public class BatteryChargeCalculator
extends PowerCalculator {
    @Override
    public boolean isPowerComponentSupported(int powerComponent) {
        return true;
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        long dischargeMah;
        long chargeTimeRemainingMs;
        builder.setDischargePercentage(batteryStats.getDischargeAmount(0));
        int batteryCapacityMah = batteryStats.getLearnedBatteryCapacity() / 1000;
        if (batteryCapacityMah <= 0 && (batteryCapacityMah = batteryStats.getMinLearnedBatteryCapacity() / 1000) <= 0) {
            batteryCapacityMah = batteryStats.getEstimatedBatteryCapacity();
        }
        builder.setBatteryCapacity(batteryCapacityMah);
        double dischargedPowerLowerBoundMah = (double)(batteryStats.getLowDischargeAmountSinceCharge() * batteryCapacityMah) / 100.0;
        double dischargedPowerUpperBoundMah = (double)(batteryStats.getHighDischargeAmountSinceCharge() * batteryCapacityMah) / 100.0;
        builder.setDischargePercentage(batteryStats.getDischargeAmount(0)).setDischargedPowerRange(dischargedPowerLowerBoundMah, dischargedPowerUpperBoundMah).setDischargeDurationMs(batteryStats.getBatteryRealtime(rawRealtimeUs) / 1000L);
        long batteryTimeRemainingMs = batteryStats.computeBatteryTimeRemaining(rawRealtimeUs);
        if (batteryTimeRemainingMs != -1L) {
            builder.setBatteryTimeRemainingMs(batteryTimeRemainingMs / 1000L);
        }
        if ((chargeTimeRemainingMs = batteryStats.computeChargeTimeRemaining(rawRealtimeUs)) != -1L) {
            builder.setChargeTimeRemainingMs(chargeTimeRemainingMs / 1000L);
        }
        if ((dischargeMah = batteryStats.getUahDischarge(0) / 1000L) == 0L) {
            dischargeMah = (long)((dischargedPowerLowerBoundMah + dischargedPowerUpperBoundMah) / 2.0 + 0.5);
        }
        builder.getAggregateBatteryConsumerBuilder(0).setConsumedPower(dischargeMah);
    }
}

