/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.org.bouncycastle.asn1;

import com.android.internal.org.bouncycastle.asn1.ASN1Encodable;
import com.android.internal.org.bouncycastle.asn1.ASN1EncodableVector;
import com.android.internal.org.bouncycastle.asn1.ASN1OutputStream;
import com.android.internal.org.bouncycastle.asn1.ASN1Primitive;
import com.android.internal.org.bouncycastle.asn1.ASN1Set;
import com.android.internal.org.bouncycastle.asn1.DEROutputStream;
import com.android.internal.org.bouncycastle.asn1.StreamUtil;
import java.io.IOException;

public class DERSet
extends ASN1Set {
    private int bodyLength = -1;

    public static DERSet convert(ASN1Set set) {
        return (DERSet)set.toDERObject();
    }

    public DERSet() {
    }

    public DERSet(ASN1Encodable element) {
        super(element);
    }

    public DERSet(ASN1EncodableVector elementVector) {
        super(elementVector, true);
    }

    public DERSet(ASN1Encodable[] elements) {
        super(elements, true);
    }

    DERSet(boolean isSorted, ASN1Encodable[] elements) {
        super(DERSet.checkSorted(isSorted), elements);
    }

    private int getBodyLength() throws IOException {
        if (this.bodyLength < 0) {
            int count = this.elements.length;
            int totalLength = 0;
            for (int i = 0; i < count; ++i) {
                ASN1Primitive derObject = this.elements[i].toASN1Primitive().toDERObject();
                totalLength += derObject.encodedLength();
            }
            this.bodyLength = totalLength;
        }
        return this.bodyLength;
    }

    @Override
    int encodedLength() throws IOException {
        int length = this.getBodyLength();
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    @Override
    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        if (withTag) {
            out.write(49);
        }
        DEROutputStream derOut = out.getDERSubStream();
        int count = this.elements.length;
        if (this.bodyLength >= 0 || count > 16) {
            out.writeLength(this.getBodyLength());
            for (int i = 0; i < count; ++i) {
                ASN1Primitive derObject = this.elements[i].toASN1Primitive().toDERObject();
                derObject.encode(derOut, true);
            }
        } else {
            int i;
            int totalLength = 0;
            ASN1Primitive[] derObjects = new ASN1Primitive[count];
            for (i = 0; i < count; ++i) {
                ASN1Primitive derObject;
                derObjects[i] = derObject = this.elements[i].toASN1Primitive().toDERObject();
                totalLength += derObject.encodedLength();
            }
            this.bodyLength = totalLength;
            out.writeLength(totalLength);
            for (i = 0; i < count; ++i) {
                derObjects[i].encode(derOut, true);
            }
        }
    }

    @Override
    ASN1Primitive toDERObject() {
        return this.isSorted ? this : super.toDERObject();
    }

    @Override
    ASN1Primitive toDLObject() {
        return this;
    }

    private static boolean checkSorted(boolean isSorted) {
        if (!isSorted) {
            throw new IllegalStateException("DERSet elements should always be in sorted order");
        }
        return isSorted;
    }
}

