/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.system.Os;
import android.system.OsConstants;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;

public class NetworkUtilsInternal {
    private static final int[] ADDRESS_FAMILIES = new int[]{OsConstants.AF_INET, OsConstants.AF_INET6};

    public static void setAllowNetworkingForProcess(boolean bl) {
        OverrideMethod.invokeV("com.android.internal.net.NetworkUtilsInternal#setAllowNetworkingForProcess(Z)V", true, null);
    }

    public static boolean protectFromVpn(FileDescriptor fileDescriptor) {
        return OverrideMethod.invokeI("com.android.internal.net.NetworkUtilsInternal#protectFromVpn(Ljava/io/FileDescriptor;)Z", true, null) != 0;
    }

    public static boolean protectFromVpn(int n) {
        return OverrideMethod.invokeI("com.android.internal.net.NetworkUtilsInternal#protectFromVpn(I)Z", true, null) != 0;
    }

    public static boolean isWeaklyValidatedHostname(String hostname) {
        String weakHostnameRegex = "^[a-zA-Z0-9_.-]+$";
        if (!hostname.matches("^[a-zA-Z0-9_.-]+$")) {
            return false;
        }
        for (int address_family : ADDRESS_FAMILIES) {
            if (Os.inet_pton(address_family, hostname) == null) continue;
            return false;
        }
        return true;
    }
}

