/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.logging;

import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.InstanceId;
import java.security.SecureRandom;
import java.util.Random;

public class InstanceIdSequence {
    protected final int mInstanceIdMax;
    private final Random mRandom = new SecureRandom();

    public InstanceIdSequence(int instanceIdMax) {
        this.mInstanceIdMax = Math.min(Math.max(1, instanceIdMax), 0x100000);
    }

    public InstanceId newInstanceId() {
        return this.newInstanceIdInternal(1 + this.mRandom.nextInt(this.mInstanceIdMax));
    }

    @VisibleForTesting
    protected InstanceId newInstanceIdInternal(int id2) {
        return new InstanceId(id2);
    }
}

