/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.inputmethod.SurroundingText;
import android.view.inputmethod.TextAttribute;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.inputmethod.IRemoteAccessibilityInputConnection;
import com.android.internal.inputmethod.InputConnectionCommandHeader;
import java.util.Objects;

class IRemoteAccessibilityInputConnectionInvoker {
    private final IRemoteAccessibilityInputConnection mConnection;
    private final int mSessionId;

    private IRemoteAccessibilityInputConnectionInvoker(IRemoteAccessibilityInputConnection inputContext, int sessionId) {
        this.mConnection = inputContext;
        this.mSessionId = sessionId;
    }

    public static IRemoteAccessibilityInputConnectionInvoker create(IRemoteAccessibilityInputConnection connection) {
        Objects.requireNonNull(connection);
        return new IRemoteAccessibilityInputConnectionInvoker(connection, 0);
    }

    public IRemoteAccessibilityInputConnectionInvoker cloneWithSessionId(int sessionId) {
        return new IRemoteAccessibilityInputConnectionInvoker(this.mConnection, sessionId);
    }

    public boolean isSameConnection(IRemoteAccessibilityInputConnection connection) {
        if (connection == null) {
            return false;
        }
        return this.mConnection.asBinder() == connection.asBinder();
    }

    InputConnectionCommandHeader createHeader() {
        return new InputConnectionCommandHeader(this.mSessionId);
    }

    public void commitText(CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        try {
            this.mConnection.commitText(this.createHeader(), text, newCursorPosition, textAttribute);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setSelection(int start, int end) {
        try {
            this.mConnection.setSelection(this.createHeader(), start, end);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public AndroidFuture<SurroundingText> getSurroundingText(int beforeLength, int afterLength, int flags) {
        AndroidFuture<SurroundingText> future = new AndroidFuture<SurroundingText>();
        try {
            this.mConnection.getSurroundingText(this.createHeader(), beforeLength, afterLength, flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void deleteSurroundingText(int beforeLength, int afterLength) {
        try {
            this.mConnection.deleteSurroundingText(this.createHeader(), beforeLength, afterLength);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void sendKeyEvent(KeyEvent event) {
        try {
            this.mConnection.sendKeyEvent(this.createHeader(), event);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void performEditorAction(int actionCode) {
        try {
            this.mConnection.performEditorAction(this.createHeader(), actionCode);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void performContextMenuAction(int id2) {
        try {
            this.mConnection.performContextMenuAction(this.createHeader(), id2);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public AndroidFuture<Integer> getCursorCapsMode(int reqModes) {
        AndroidFuture<Integer> future = new AndroidFuture<Integer>();
        try {
            this.mConnection.getCursorCapsMode(this.createHeader(), reqModes, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public void clearMetaKeyStates(int states) {
        try {
            this.mConnection.clearMetaKeyStates(this.createHeader(), states);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

