/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.os.Bundle;
import android.os.RemoteException;
import android.view.KeyEvent;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputContentInfo;
import android.view.inputmethod.SurroundingText;
import android.view.inputmethod.TextAttribute;
import com.android.internal.infra.AndroidFuture;
import com.android.internal.inputmethod.InputConnectionCommandHeader;
import com.android.internal.view.IInputContext;
import java.util.Objects;

public class IInputContextInvoker {
    private final IInputContext mIInputContext;
    private final int mSessionId;

    private IInputContextInvoker(IInputContext inputContext, int sessionId) {
        this.mIInputContext = inputContext;
        this.mSessionId = sessionId;
    }

    public static IInputContextInvoker create(IInputContext inputContext) {
        Objects.requireNonNull(inputContext);
        return new IInputContextInvoker(inputContext, 0);
    }

    public IInputContextInvoker cloneWithSessionId(int sessionId) {
        return new IInputContextInvoker(this.mIInputContext, sessionId);
    }

    public boolean isSameConnection(IInputContext inputContext) {
        if (inputContext == null) {
            return false;
        }
        return this.mIInputContext.asBinder() == inputContext.asBinder();
    }

    InputConnectionCommandHeader createHeader() {
        return new InputConnectionCommandHeader(this.mSessionId);
    }

    public AndroidFuture<CharSequence> getTextAfterCursor(int length, int flags) {
        AndroidFuture<CharSequence> future = new AndroidFuture<CharSequence>();
        try {
            this.mIInputContext.getTextAfterCursor(this.createHeader(), length, flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public AndroidFuture<CharSequence> getTextBeforeCursor(int length, int flags) {
        AndroidFuture<CharSequence> future = new AndroidFuture<CharSequence>();
        try {
            this.mIInputContext.getTextBeforeCursor(this.createHeader(), length, flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public AndroidFuture<CharSequence> getSelectedText(int flags) {
        AndroidFuture<CharSequence> future = new AndroidFuture<CharSequence>();
        try {
            this.mIInputContext.getSelectedText(this.createHeader(), flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public AndroidFuture<SurroundingText> getSurroundingText(int beforeLength, int afterLength, int flags) {
        AndroidFuture<SurroundingText> future = new AndroidFuture<SurroundingText>();
        try {
            this.mIInputContext.getSurroundingText(this.createHeader(), beforeLength, afterLength, flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public AndroidFuture<Integer> getCursorCapsMode(int reqModes) {
        AndroidFuture<Integer> future = new AndroidFuture<Integer>();
        try {
            this.mIInputContext.getCursorCapsMode(this.createHeader(), reqModes, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public AndroidFuture<ExtractedText> getExtractedText(ExtractedTextRequest request, int flags) {
        AndroidFuture<ExtractedText> future = new AndroidFuture<ExtractedText>();
        try {
            this.mIInputContext.getExtractedText(this.createHeader(), request, flags, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        try {
            this.mIInputContext.commitText(this.createHeader(), text, newCursorPosition);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean commitText(CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        try {
            this.mIInputContext.commitTextWithTextAttribute(this.createHeader(), text, newCursorPosition, textAttribute);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean commitCompletion(CompletionInfo text) {
        try {
            this.mIInputContext.commitCompletion(this.createHeader(), text);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean commitCorrection(CorrectionInfo correctionInfo) {
        try {
            this.mIInputContext.commitCorrection(this.createHeader(), correctionInfo);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setSelection(int start, int end) {
        try {
            this.mIInputContext.setSelection(this.createHeader(), start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean performEditorAction(int actionCode) {
        try {
            this.mIInputContext.performEditorAction(this.createHeader(), actionCode);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean performContextMenuAction(int id2) {
        try {
            this.mIInputContext.performContextMenuAction(this.createHeader(), id2);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setComposingRegion(int start, int end) {
        try {
            this.mIInputContext.setComposingRegion(this.createHeader(), start, end);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setComposingRegion(int start, int end, TextAttribute textAttribute) {
        try {
            this.mIInputContext.setComposingRegionWithTextAttribute(this.createHeader(), start, end, textAttribute);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        try {
            this.mIInputContext.setComposingText(this.createHeader(), text, newCursorPosition);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition, TextAttribute textAttribute) {
        try {
            this.mIInputContext.setComposingTextWithTextAttribute(this.createHeader(), text, newCursorPosition, textAttribute);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean finishComposingText() {
        try {
            this.mIInputContext.finishComposingText(this.createHeader());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean beginBatchEdit() {
        try {
            this.mIInputContext.beginBatchEdit(this.createHeader());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean endBatchEdit() {
        try {
            this.mIInputContext.endBatchEdit(this.createHeader());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean sendKeyEvent(KeyEvent event) {
        try {
            this.mIInputContext.sendKeyEvent(this.createHeader(), event);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean clearMetaKeyStates(int states) {
        try {
            this.mIInputContext.clearMetaKeyStates(this.createHeader(), states);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        try {
            this.mIInputContext.deleteSurroundingText(this.createHeader(), beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean deleteSurroundingTextInCodePoints(int beforeLength, int afterLength) {
        try {
            this.mIInputContext.deleteSurroundingTextInCodePoints(this.createHeader(), beforeLength, afterLength);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean performSpellCheck() {
        try {
            this.mIInputContext.performSpellCheck(this.createHeader());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public boolean performPrivateCommand(String action, Bundle data) {
        try {
            this.mIInputContext.performPrivateCommand(this.createHeader(), action, data);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public AndroidFuture<Boolean> requestCursorUpdates(int cursorUpdateMode, int imeDisplayId) {
        AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
        try {
            this.mIInputContext.requestCursorUpdates(this.createHeader(), cursorUpdateMode, imeDisplayId, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public AndroidFuture<Boolean> requestCursorUpdates(int cursorUpdateMode, int cursorUpdateFilter, int imeDisplayId) {
        AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
        try {
            this.mIInputContext.requestCursorUpdatesWithFilter(this.createHeader(), cursorUpdateMode, cursorUpdateFilter, imeDisplayId, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public AndroidFuture<Boolean> commitContent(InputContentInfo inputContentInfo, int flags, Bundle opts) {
        AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
        try {
            this.mIInputContext.commitContent(this.createHeader(), inputContentInfo, flags, opts, future);
        }
        catch (RemoteException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public boolean setImeConsumesInput(boolean imeConsumesInput) {
        try {
            this.mIInputContext.setImeConsumesInput(this.createHeader(), imeConsumesInput);
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }
}

