/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.compat;

import android.os.Parcel;
import android.os.Parcelable;

public class CompatibilityChangeInfo
implements Parcelable {
    private final long mChangeId;
    private final String mName;
    private final int mEnableSinceTargetSdk;
    private final boolean mDisabled;
    private final boolean mLoggingOnly;
    private final String mDescription;
    private final boolean mOverridable;
    public static final Parcelable.Creator<CompatibilityChangeInfo> CREATOR = new Parcelable.Creator<CompatibilityChangeInfo>(){

        @Override
        public CompatibilityChangeInfo createFromParcel(Parcel in) {
            return new CompatibilityChangeInfo(in);
        }

        public CompatibilityChangeInfo[] newArray(int size) {
            return new CompatibilityChangeInfo[size];
        }
    };

    public long getId() {
        return this.mChangeId;
    }

    public String getName() {
        return this.mName;
    }

    public int getEnableSinceTargetSdk() {
        return this.mEnableSinceTargetSdk;
    }

    public boolean getDisabled() {
        return this.mDisabled;
    }

    public boolean getLoggingOnly() {
        return this.mLoggingOnly;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean getOverridable() {
        return this.mOverridable;
    }

    public CompatibilityChangeInfo(Long changeId, String name, int enableAfterTargetSdk, int enableSinceTargetSdk, boolean disabled, boolean loggingOnly, String description, boolean overridable) {
        this.mChangeId = changeId;
        this.mName = name;
        this.mEnableSinceTargetSdk = enableAfterTargetSdk > 0 ? enableAfterTargetSdk + 1 : (enableSinceTargetSdk > 0 ? enableSinceTargetSdk : -1);
        this.mDisabled = disabled;
        this.mLoggingOnly = loggingOnly;
        this.mDescription = description;
        this.mOverridable = overridable;
    }

    public CompatibilityChangeInfo(CompatibilityChangeInfo other) {
        this.mChangeId = other.mChangeId;
        this.mName = other.mName;
        this.mEnableSinceTargetSdk = other.mEnableSinceTargetSdk;
        this.mDisabled = other.mDisabled;
        this.mLoggingOnly = other.mLoggingOnly;
        this.mDescription = other.mDescription;
        this.mOverridable = other.mOverridable;
    }

    private CompatibilityChangeInfo(Parcel in) {
        this.mChangeId = in.readLong();
        this.mName = in.readString();
        this.mEnableSinceTargetSdk = in.readInt();
        this.mDisabled = in.readBoolean();
        this.mLoggingOnly = in.readBoolean();
        this.mDescription = in.readString();
        this.mOverridable = in.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mChangeId);
        dest.writeString(this.mName);
        dest.writeInt(this.mEnableSinceTargetSdk);
        dest.writeBoolean(this.mDisabled);
        dest.writeBoolean(this.mLoggingOnly);
        dest.writeString(this.mDescription);
        dest.writeBoolean(this.mOverridable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CompatibilityChangeInfo(").append(this.getId());
        if (this.getName() != null) {
            sb.append("; name=").append(this.getName());
        }
        if (this.getEnableSinceTargetSdk() != -1) {
            sb.append("; enableSinceTargetSdk=").append(this.getEnableSinceTargetSdk());
        }
        if (this.getDisabled()) {
            sb.append("; disabled");
        }
        if (this.getLoggingOnly()) {
            sb.append("; loggingOnly");
        }
        if (this.getOverridable()) {
            sb.append("; overridable");
        }
        return sb.append(")").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof CompatibilityChangeInfo)) {
            return false;
        }
        CompatibilityChangeInfo that = (CompatibilityChangeInfo)o;
        return this.mChangeId == that.mChangeId && this.mName.equals(that.mName) && this.mEnableSinceTargetSdk == that.mEnableSinceTargetSdk && this.mDisabled == that.mDisabled && this.mLoggingOnly == that.mLoggingOnly && this.mDescription.equals(that.mDescription) && this.mOverridable == that.mOverridable;
    }
}

