/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ListFragment;
import android.content.Context;
import android.os.Bundle;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.SearchView;
import com.android.internal.app.AppLocaleStore;
import com.android.internal.app.LocaleHelper;
import com.android.internal.app.LocalePicker;
import com.android.internal.app.LocaleStore;
import com.android.internal.app.SuggestedLocaleAdapter;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class LocalePickerWithRegion
extends ListFragment
implements SearchView.OnQueryTextListener {
    private static final String TAG = LocalePickerWithRegion.class.getSimpleName();
    private static final String PARENT_FRAGMENT_NAME = "localeListEditor";
    private SuggestedLocaleAdapter mAdapter;
    private LocaleSelectedListener mListener;
    private Set<LocaleStore.LocaleInfo> mLocaleList;
    private LocaleStore.LocaleInfo mParentLocale;
    private boolean mTranslatedOnly = false;
    private SearchView mSearchView = null;
    private CharSequence mPreviousSearch = null;
    private boolean mPreviousSearchHadFocus = false;
    private int mFirstVisiblePosition = 0;
    private int mTopDistance = 0;
    private String mAppPackageName;
    private CharSequence mTitle = null;
    private MenuItem.OnActionExpandListener mOnActionExpandListener;

    private static LocalePickerWithRegion createCountryPicker(Context context, LocaleSelectedListener listener, LocaleStore.LocaleInfo parent, boolean translatedOnly, String appPackageName, MenuItem.OnActionExpandListener onActionExpandListener) {
        LocalePickerWithRegion localePicker = new LocalePickerWithRegion();
        localePicker.setOnActionExpandListener(onActionExpandListener);
        boolean shouldShowTheList = localePicker.setListener(context, listener, parent, translatedOnly, appPackageName);
        return shouldShowTheList ? localePicker : null;
    }

    public static LocalePickerWithRegion createLanguagePicker(Context context, LocaleSelectedListener listener, boolean translatedOnly) {
        LocalePickerWithRegion localePicker = new LocalePickerWithRegion();
        localePicker.setListener(context, listener, null, translatedOnly, null);
        return localePicker;
    }

    public static LocalePickerWithRegion createLanguagePicker(Context context, LocaleSelectedListener listener, boolean translatedOnly, String appPackageName, MenuItem.OnActionExpandListener onActionExpandListener) {
        LocalePickerWithRegion localePicker = new LocalePickerWithRegion();
        localePicker.setOnActionExpandListener(onActionExpandListener);
        localePicker.setListener(context, listener, null, translatedOnly, appPackageName);
        return localePicker;
    }

    private boolean setListener(Context context, LocaleSelectedListener listener, LocaleStore.LocaleInfo parent, boolean translatedOnly, String appPackageName) {
        boolean isForCountryMode;
        this.mParentLocale = parent;
        this.mListener = listener;
        this.mTranslatedOnly = translatedOnly;
        this.mAppPackageName = appPackageName;
        this.setRetainInstance(true);
        HashSet<String> langTagsToIgnore = new HashSet<String>();
        LocaleStore.LocaleInfo appCurrentLocale = LocaleStore.getAppCurrentLocaleInfo(context, appPackageName);
        boolean bl = isForCountryMode = parent != null;
        if (!TextUtils.isEmpty(appPackageName) && !isForCountryMode) {
            LocaleList systemLangList = LocaleList.getDefault();
            for (int i = 0; i < systemLangList.size(); ++i) {
                langTagsToIgnore.add(systemLangList.get(i).toLanguageTag());
            }
            if (appCurrentLocale != null) {
                Log.d(TAG, "appCurrentLocale: " + appCurrentLocale.getLocale().toLanguageTag());
                langTagsToIgnore.add(appCurrentLocale.getLocale().toLanguageTag());
            } else {
                Log.d(TAG, "appCurrentLocale is null");
            }
        } else if (!translatedOnly) {
            LocaleList userLocales = LocalePicker.getLocales();
            String[] langTags = userLocales.toLanguageTags().split(",");
            Collections.addAll(langTagsToIgnore, langTags);
        }
        if (isForCountryMode) {
            this.mLocaleList = LocaleStore.getLevelLocales(context, langTagsToIgnore, parent, translatedOnly);
            if (this.mLocaleList.size() <= 1) {
                if (listener != null && this.mLocaleList.size() == 1) {
                    listener.onLocaleSelected(this.mLocaleList.iterator().next());
                }
                return false;
            }
        } else {
            this.mLocaleList = LocaleStore.getLevelLocales(context, langTagsToIgnore, null, translatedOnly);
        }
        Log.d(TAG, "mLocaleList size:  " + this.mLocaleList.size());
        if (!TextUtils.isEmpty(appPackageName)) {
            if (appCurrentLocale != null && !isForCountryMode) {
                this.mLocaleList.add(appCurrentLocale);
            }
            AppLocaleStore.AppLocaleResult result = AppLocaleStore.getAppSupportedLocales(context, appPackageName);
            boolean shouldShowList = result.mLocaleStatus == AppLocaleStore.AppLocaleResult.LocaleStatus.GET_SUPPORTED_LANGUAGE_FROM_LOCAL_CONFIG || result.mLocaleStatus == AppLocaleStore.AppLocaleResult.LocaleStatus.GET_SUPPORTED_LANGUAGE_FROM_ASSET;
            for (LocaleStore.LocaleInfo localeInfo : LocaleStore.getSystemCurrentLocaleInfo()) {
                boolean isNotCurrentLocale;
                boolean bl2 = isNotCurrentLocale = appCurrentLocale == null || !localeInfo.getLocale().equals(appCurrentLocale.getLocale());
                if (isForCountryMode || !isNotCurrentLocale) continue;
                this.mLocaleList.add(localeInfo);
            }
            this.mLocaleList = this.filterTheLanguagesNotSupportedInApp(shouldShowList, result.mAppSupportedLocales);
            Log.d(TAG, "mLocaleList after app-supported filter:  " + this.mLocaleList.size());
            if (!isForCountryMode && shouldShowList) {
                this.mLocaleList.add(LocaleStore.getSystemDefaultLocaleInfo(appCurrentLocale == null));
            }
        }
        return true;
    }

    private Set<LocaleStore.LocaleInfo> filterTheLanguagesNotSupportedInApp(boolean shouldShowList, HashSet<Locale> supportedLocales) {
        HashSet<LocaleStore.LocaleInfo> filteredList = new HashSet<LocaleStore.LocaleInfo>();
        if (!shouldShowList) {
            return filteredList;
        }
        block0: for (LocaleStore.LocaleInfo li : this.mLocaleList) {
            if (supportedLocales.contains(li.getLocale())) {
                filteredList.add(li);
                continue;
            }
            for (Locale l : supportedLocales) {
                if (!LocaleList.matchesLanguageAndScript(li.getLocale(), l)) continue;
                filteredList.add(li);
                continue block0;
            }
        }
        return filteredList;
    }

    private void returnToParentFrame() {
        this.getFragmentManager().popBackStack(PARENT_FRAGMENT_NAME, 1);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        if (this.mLocaleList == null) {
            this.returnToParentFrame();
            return;
        }
        this.mTitle = this.getActivity().getTitle();
        boolean countryMode = this.mParentLocale != null;
        Locale sortingLocale = countryMode ? this.mParentLocale.getLocale() : AndroidLocale.getDefault();
        this.mAdapter = new SuggestedLocaleAdapter(this.mLocaleList, countryMode, this.mAppPackageName);
        LocaleHelper.LocaleInfoComparator comp = new LocaleHelper.LocaleInfoComparator(sortingLocale, countryMode);
        this.mAdapter.sort(comp);
        this.setListAdapter(this.mAdapter);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.getListView().setNestedScrollingEnabled(true);
        this.getListView().setDivider(null);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        int id2 = menuItem.getItemId();
        switch (id2) {
            case 16908332: {
                this.getFragmentManager().popBackStack();
                return true;
            }
        }
        return super.onOptionsItemSelected(menuItem);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (this.mParentLocale != null) {
            this.getActivity().setTitle(this.mParentLocale.getFullNameNative());
        } else {
            this.getActivity().setTitle(this.mTitle);
        }
        this.getListView().requestFocus();
    }

    @Override
    public void onPause() {
        super.onPause();
        if (this.mSearchView != null) {
            this.mPreviousSearchHadFocus = this.mSearchView.hasFocus();
            this.mPreviousSearch = this.mSearchView.getQuery();
        } else {
            this.mPreviousSearchHadFocus = false;
            this.mPreviousSearch = null;
        }
        ListView list = this.getListView();
        View firstChild = list.getChildAt(0);
        this.mFirstVisiblePosition = list.getFirstVisiblePosition();
        this.mTopDistance = firstChild == null ? 0 : firstChild.getTop() - list.getPaddingTop();
    }

    @Override
    public void onListItemClick(ListView parent, View v, int position, long id2) {
        boolean isRegionLocale;
        LocaleStore.LocaleInfo locale = (LocaleStore.LocaleInfo)parent.getAdapter().getItem(position);
        boolean isSystemLocale = locale.isSystemLocale();
        boolean bl = isRegionLocale = locale.getParent() != null;
        if (isSystemLocale || isRegionLocale) {
            if (this.mListener != null) {
                this.mListener.onLocaleSelected(locale);
            }
            this.returnToParentFrame();
        } else {
            LocalePickerWithRegion selector = LocalePickerWithRegion.createCountryPicker(this.getContext(), this.mListener, locale, this.mTranslatedOnly, this.mAppPackageName, this.mOnActionExpandListener);
            if (selector != null) {
                this.getFragmentManager().beginTransaction().setTransition(4097).replace(this.getId(), selector).addToBackStack(null).commit();
            } else {
                this.returnToParentFrame();
            }
        }
    }

    @Override
    public void onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        if (this.mParentLocale == null) {
            inflater.inflate(0x1140000, menu2);
            MenuItem searchMenuItem = menu2.findItem(16909187);
            if (!TextUtils.isEmpty(this.mAppPackageName) && this.mOnActionExpandListener != null) {
                searchMenuItem.setOnActionExpandListener(this.mOnActionExpandListener);
            }
            this.mSearchView = (SearchView)searchMenuItem.getActionView();
            this.mSearchView.setQueryHint(this.getText(17041457));
            this.mSearchView.setOnQueryTextListener(this);
            if (!TextUtils.isEmpty(this.mPreviousSearch)) {
                searchMenuItem.expandActionView();
                this.mSearchView.setIconified(false);
                this.mSearchView.setActivated(true);
                if (this.mPreviousSearchHadFocus) {
                    this.mSearchView.requestFocus();
                }
                this.mSearchView.setQuery(this.mPreviousSearch, true);
            } else {
                this.mSearchView.setQuery(null, false);
            }
            this.getListView().setSelectionFromTop(this.mFirstVisiblePosition, this.mTopDistance);
        }
    }

    @Override
    public boolean onQueryTextSubmit(String query) {
        return false;
    }

    @Override
    public boolean onQueryTextChange(String newText) {
        if (this.mAdapter != null) {
            this.mAdapter.getFilter().filter(newText);
        }
        return false;
    }

    public void setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        this.mOnActionExpandListener = onActionExpandListener;
    }

    public static interface LocaleSelectedListener {
        public void onLocaleSelected(LocaleStore.LocaleInfo var1);
    }
}

