/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone;

import android.system.ErrnoException;
import com.android.i18n.timezone.TimeZoneDataFiles;
import com.android.i18n.timezone.ZoneInfoData;
import com.android.i18n.timezone.internal.BasicLruCache;
import com.android.i18n.timezone.internal.BufferIterator;
import com.android.i18n.timezone.internal.MemoryMappedFile;
import dalvik.annotation.optimization.ReachabilitySensitive;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;

public class ZoneInfoDb {
    public static final String TZDATA_FILE_NAME = "tzdata";
    private static final ZoneInfoDb DATA = ZoneInfoDb.loadTzDataWithFallback(TimeZoneDataFiles.getTimeZoneFilePaths("tzdata"));
    private static final int SIZEOF_TZNAME = 40;
    private static final int SIZEOF_TZINT = 4;
    public static final int SIZEOF_INDEX_ENTRY = 52;
    private boolean closed;
    @ReachabilitySensitive
    private MemoryMappedFile mappedFile;
    private String version;
    private String[] ids;
    private int[] byteOffsets;
    private int[] rawUtcOffsetsCache;
    private static final int CACHE_SIZE = 1;
    private final BasicLruCache<String, ZoneInfoData> cache = new BasicLruCache<String, ZoneInfoData>(1){

        @Override
        protected ZoneInfoData create(String id2) {
            try {
                return ZoneInfoDb.this.makeZoneInfoDataUncached(id2);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load timezone for ID=" + id2, e);
            }
        }
    };

    public static ZoneInfoDb getInstance() {
        return DATA;
    }

    public static ZoneInfoDb loadTzDataWithFallback(String ... paths) {
        String[] stringArray = paths;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            ZoneInfoDb tzData = new ZoneInfoDb();
            String path = stringArray[i];
            if (!tzData.loadData(path)) continue;
            return tzData;
        }
        return ZoneInfoDb.createFallback();
    }

    public static ZoneInfoDb loadTzData(String path) {
        ZoneInfoDb tzData = new ZoneInfoDb();
        if (tzData.loadData(path)) {
            return tzData;
        }
        return null;
    }

    private static ZoneInfoDb createFallback() {
        ZoneInfoDb tzData = new ZoneInfoDb();
        tzData.populateFallback();
        return tzData;
    }

    private ZoneInfoDb() {
    }

    public BufferIterator getBufferIterator(String id2) {
        this.checkNotClosed();
        int index = Arrays.binarySearch(this.ids, id2);
        if (index < 0) {
            return null;
        }
        int byteOffset = this.byteOffsets[index];
        BufferIterator it = this.mappedFile.bigEndianIterator();
        it.skip(byteOffset);
        return it;
    }

    private void populateFallback() {
        this.version = "missing";
        this.ids = new String[]{"GMT"};
        this.rawUtcOffsetsCache = new int[1];
        this.byteOffsets = this.rawUtcOffsetsCache;
    }

    private boolean loadData(String path) {
        try {
            this.mappedFile = MemoryMappedFile.mmapRO(path);
        }
        catch (ErrnoException errnoException) {
            return false;
        }
        try {
            this.readHeader();
            return true;
        }
        catch (Exception ex) {
            this.close();
            return false;
        }
    }

    private void readHeader() throws IOException {
        BufferIterator it = this.mappedFile.bigEndianIterator();
        try {
            byte[] tzdata_version = new byte[12];
            it.readByteArray(tzdata_version, 0, tzdata_version.length);
            String magic = new String(tzdata_version, 0, 6, StandardCharsets.US_ASCII);
            if (!magic.equals(TZDATA_FILE_NAME) || tzdata_version[11] != 0) {
                throw new IOException("bad tzdata magic: " + Arrays.toString(tzdata_version));
            }
            this.version = new String(tzdata_version, 6, 5, StandardCharsets.US_ASCII);
            int fileSize = this.mappedFile.size();
            int index_offset = it.readInt();
            int data_offset = it.readInt();
            int final_offset = it.readInt();
            if (index_offset >= data_offset || data_offset >= final_offset || final_offset > fileSize) {
                throw new IOException("Invalid offset: index_offset=" + index_offset + ", data_offset=" + data_offset + ", final_offset=" + final_offset + ", fileSize=" + fileSize);
            }
            this.readIndex(it, index_offset, data_offset);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException("Invalid read from data file", e);
        }
    }

    private void readIndex(BufferIterator it, int indexOffset, int dataOffset) throws IOException {
        it.seek(indexOffset);
        byte[] idBytes = new byte[40];
        int indexSize = dataOffset - indexOffset;
        if (indexSize % 52 != 0) {
            throw new IOException("Index size is not divisible by 52, indexSize=" + indexSize);
        }
        int entryCount = indexSize / 52;
        this.byteOffsets = new int[entryCount];
        this.ids = new String[entryCount];
        for (int i = 0; i < entryCount; ++i) {
            int len;
            it.readByteArray(idBytes, 0, idBytes.length);
            this.byteOffsets[i] = it.readInt();
            int n = i;
            this.byteOffsets[n] = this.byteOffsets[n] + dataOffset;
            int length = it.readInt();
            if (length < 44) {
                throw new IOException("length in index file < sizeof(tzhead)");
            }
            it.skip(4);
            for (len = 0; len < idBytes.length && idBytes[len] != 0; ++len) {
            }
            if (len == 0) {
                throw new IOException("Invalid ID at index=" + i);
            }
            String zoneId = new String(idBytes, 0, len, StandardCharsets.US_ASCII);
            this.ids[i] = zoneId.intern();
            if (i <= 0 || this.ids[i].compareTo(this.ids[i - 1]) > 0) continue;
            throw new IOException("Index not sorted or contains multiple entries with the same ID, index=" + i + ", ids[i]=" + this.ids[i] + ", ids[i - 1]=" + this.ids[i - 1]);
        }
    }

    public static void validateTzData(String path) throws IOException {
        ZoneInfoDb tzData = ZoneInfoDb.loadTzData(path);
        if (tzData == null) {
            throw new IOException("failed to read tzData at " + path);
        }
        try {
            tzData.validate();
        }
        finally {
            tzData.close();
        }
    }

    private void validate() throws IOException {
        this.checkNotClosed();
        for (String id2 : this.getAvailableIDs()) {
            ZoneInfoData zoneInfoData = this.makeZoneInfoDataUncached(id2);
            if (zoneInfoData != null) continue;
            throw new IOException("Unable to find data for ID=" + id2);
        }
    }

    ZoneInfoData makeZoneInfoDataUncached(String id2) throws IOException {
        BufferIterator it = this.getBufferIterator(id2);
        if (it == null) {
            return null;
        }
        return ZoneInfoData.readTimeZone(id2, it);
    }

    public String[] getAvailableIDs() {
        this.checkNotClosed();
        return (String[])this.ids.clone();
    }

    public String[] getAvailableIDs(int rawUtcOffset) {
        this.checkNotClosed();
        ArrayList<String> matches = new ArrayList<String>();
        int[] rawUtcOffsets = this.getRawUtcOffsets();
        for (int i = 0; i < rawUtcOffsets.length; ++i) {
            if (rawUtcOffsets[i] != rawUtcOffset) continue;
            matches.add(this.ids[i]);
        }
        return matches.toArray(new String[matches.size()]);
    }

    private synchronized int[] getRawUtcOffsets() {
        if (this.rawUtcOffsetsCache != null) {
            return this.rawUtcOffsetsCache;
        }
        this.rawUtcOffsetsCache = new int[this.ids.length];
        for (int i = 0; i < this.ids.length; ++i) {
            this.rawUtcOffsetsCache[i] = this.cache.get(this.ids[i]).getRawOffset();
        }
        return this.rawUtcOffsetsCache;
    }

    public String getVersion() {
        this.checkNotClosed();
        return this.version;
    }

    public ZoneInfoData makeZoneInfoData(String id2) {
        this.checkNotClosed();
        ZoneInfoData zoneInfoData = this.cache.get(id2);
        return zoneInfoData;
    }

    public boolean hasTimeZone(String id2) {
        this.checkNotClosed();
        return Arrays.binarySearch(this.ids, id2) >= 0;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.ids = null;
            this.byteOffsets = null;
            this.rawUtcOffsetsCache = null;
            this.cache.evictAll();
            if (this.mappedFile != null) {
                try {
                    this.mappedFile.close();
                }
                catch (ErrnoException errnoException) {
                    // empty catch block
                }
                this.mappedFile = null;
            }
        }
    }

    private void checkNotClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("ZoneInfoDB instance is closed");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

