/*
 * Decompiled with CFR 0.152.
 */
package com.android.adservices;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.android.adservices.LogUtil;
import com.android.adservices.ServiceBinder;
import com.android.internal.annotations.GuardedBy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

class AndroidServiceBinder<T>
extends ServiceBinder<T> {
    private static final int BIND_FLAGS = 65;
    private static final int BINDER_CONNECTION_TIMEOUT_MS = 5000;
    private final Object mLock = new Object();
    private final String mServiceIntentAction;
    private final Function<IBinder, T> mBinderConverter;
    private final Context mContext;
    private CountDownLatch mCountDownLatch;
    @GuardedBy(value={"mLock"})
    private T mService;
    @GuardedBy(value={"mLock"})
    private ServiceConnection mServiceConnection;

    protected AndroidServiceBinder(Context context, String serviceIntentAction, Function<IBinder, T> converter) {
        this.mServiceIntentAction = serviceIntentAction;
        this.mContext = context;
        this.mBinderConverter = converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getService() {
        Object object = this.mLock;
        synchronized (object) {
            return this.bindServiceLocked();
        }
    }

    @GuardedBy(value={"mLock"})
    private T bindServiceLocked() {
        Intent intent = new Intent("android.adservices.TOPICS_SERVICE");
        intent.setPackage("com.android.adservices.apk");
        if (this.mService != null) {
            return this.mService;
        }
        LogUtil.d("bindService: " + this.mServiceIntentAction);
        this.mCountDownLatch = new CountDownLatch(1);
        this.mServiceConnection = new AdServicesServiceConnection();
        boolean success = this.mContext.bindService(intent, 65, Runnable::run, this.mServiceConnection);
        if (!success) {
            LogUtil.e("Failed to bindService: " + intent);
            this.mServiceConnection = null;
            return null;
        }
        try {
            this.mCountDownLatch.await(5000L, TimeUnit.MILLISECONDS);
            if (this.mService == null) {
                throw new RuntimeException("Failed to connect to the service");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Thread interrupted");
        }
        return this.mService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFromService() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mService == null || this.mServiceConnection == null) {
                return;
            }
            LogUtil.d("unbinding...");
            this.mContext.unbindService(this.mServiceConnection);
            this.mServiceConnection = null;
            this.mService = null;
        }
    }

    private class AdServicesServiceConnection
    implements ServiceConnection {
        private AdServicesServiceConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            LogUtil.d("onServiceConnected " + AndroidServiceBinder.this.mServiceIntentAction);
            Object object = AndroidServiceBinder.this.mLock;
            synchronized (object) {
                AndroidServiceBinder.this.mService = AndroidServiceBinder.this.mBinderConverter.apply(service);
            }
            AndroidServiceBinder.this.mCountDownLatch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceDisconnected(ComponentName name) {
            LogUtil.d("onServiceDisconnected " + AndroidServiceBinder.this.mServiceIntentAction);
            Object object = AndroidServiceBinder.this.mLock;
            synchronized (object) {
                AndroidServiceBinder.this.mService = null;
            }
            AndroidServiceBinder.this.mCountDownLatch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onBindingDied(ComponentName name) {
            LogUtil.d("onBindingDied " + AndroidServiceBinder.this.mServiceIntentAction);
            Object object = AndroidServiceBinder.this.mLock;
            synchronized (object) {
                AndroidServiceBinder.this.mService = null;
            }
            AndroidServiceBinder.this.mCountDownLatch.countDown();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNullBinding(ComponentName name) {
            LogUtil.e("onNullBinding shouldn't happen: " + AndroidServiceBinder.this.mServiceIntentAction);
            Object object = AndroidServiceBinder.this.mLock;
            synchronized (object) {
                AndroidServiceBinder.this.mService = null;
            }
            AndroidServiceBinder.this.mCountDownLatch.countDown();
        }
    }
}

