/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.content.Intent;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.window.TaskFragmentInfo;

public interface ITaskFragmentOrganizer
extends IInterface {
    public static final String DESCRIPTOR = "android.window.ITaskFragmentOrganizer";

    public void onTaskFragmentAppeared(TaskFragmentInfo var1) throws RemoteException;

    public void onTaskFragmentInfoChanged(TaskFragmentInfo var1) throws RemoteException;

    public void onTaskFragmentVanished(TaskFragmentInfo var1) throws RemoteException;

    public void onTaskFragmentParentInfoChanged(IBinder var1, Configuration var2) throws RemoteException;

    public void onTaskFragmentError(IBinder var1, Bundle var2) throws RemoteException;

    public void onActivityReparentToTask(int var1, Intent var2, IBinder var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskFragmentOrganizer {
        static final int TRANSACTION_onTaskFragmentAppeared = 1;
        static final int TRANSACTION_onTaskFragmentInfoChanged = 2;
        static final int TRANSACTION_onTaskFragmentVanished = 3;
        static final int TRANSACTION_onTaskFragmentParentInfoChanged = 4;
        static final int TRANSACTION_onTaskFragmentError = 5;
        static final int TRANSACTION_onActivityReparentToTask = 6;

        public Stub() {
            this.attachInterface(this, ITaskFragmentOrganizer.DESCRIPTOR);
        }

        public static ITaskFragmentOrganizer asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITaskFragmentOrganizer.DESCRIPTOR);
            if (iin != null && iin instanceof ITaskFragmentOrganizer) {
                return (ITaskFragmentOrganizer)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTaskFragmentAppeared";
                }
                case 2: {
                    return "onTaskFragmentInfoChanged";
                }
                case 3: {
                    return "onTaskFragmentVanished";
                }
                case 4: {
                    return "onTaskFragmentParentInfoChanged";
                }
                case 5: {
                    return "onTaskFragmentError";
                }
                case 6: {
                    return "onActivityReparentToTask";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITaskFragmentOrganizer.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    TaskFragmentInfo _arg0 = data.readTypedObject(TaskFragmentInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskFragmentAppeared(_arg0);
                    break;
                }
                case 2: {
                    TaskFragmentInfo _arg0 = data.readTypedObject(TaskFragmentInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskFragmentInfoChanged(_arg0);
                    break;
                }
                case 3: {
                    TaskFragmentInfo _arg0 = data.readTypedObject(TaskFragmentInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskFragmentVanished(_arg0);
                    break;
                }
                case 4: {
                    IBinder _arg0 = data.readStrongBinder();
                    Configuration _arg1 = data.readTypedObject(Configuration.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskFragmentParentInfoChanged(_arg0, _arg1);
                    break;
                }
                case 5: {
                    IBinder _arg0 = data.readStrongBinder();
                    Bundle _arg1 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTaskFragmentError(_arg0, _arg1);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    Intent _arg1 = data.readTypedObject(Intent.CREATOR);
                    IBinder _arg2 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.onActivityReparentToTask(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 5;
        }

        private static class Proxy
        implements ITaskFragmentOrganizer {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITaskFragmentOrganizer.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskFragmentAppeared(TaskFragmentInfo taskFragmentInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(taskFragmentInfo, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskFragmentInfoChanged(TaskFragmentInfo taskFragmentInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(taskFragmentInfo, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskFragmentVanished(TaskFragmentInfo taskFragmentInfo) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizer.DESCRIPTOR);
                    _data.writeTypedObject(taskFragmentInfo, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskFragmentParentInfoChanged(IBinder fragmentToken, Configuration parentConfig) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizer.DESCRIPTOR);
                    _data.writeStrongBinder(fragmentToken);
                    _data.writeTypedObject(parentConfig, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTaskFragmentError(IBinder errorCallbackToken, Bundle exceptionBundle) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizer.DESCRIPTOR);
                    _data.writeStrongBinder(errorCallbackToken);
                    _data.writeTypedObject(exceptionBundle, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityReparentToTask(int taskId, Intent activityIntent, IBinder activityToken) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITaskFragmentOrganizer.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeTypedObject(activityIntent, 0);
                    _data.writeStrongBinder(activityToken);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITaskFragmentOrganizer {
        @Override
        public void onTaskFragmentAppeared(TaskFragmentInfo taskFragmentInfo) throws RemoteException {
        }

        @Override
        public void onTaskFragmentInfoChanged(TaskFragmentInfo taskFragmentInfo) throws RemoteException {
        }

        @Override
        public void onTaskFragmentVanished(TaskFragmentInfo taskFragmentInfo) throws RemoteException {
        }

        @Override
        public void onTaskFragmentParentInfoChanged(IBinder fragmentToken, Configuration parentConfig) throws RemoteException {
        }

        @Override
        public void onTaskFragmentError(IBinder errorCallbackToken, Bundle exceptionBundle) throws RemoteException {
        }

        @Override
        public void onActivityReparentToTask(int taskId, Intent activityIntent, IBinder activityToken) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

