/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.WindowContainerTransaction;

public interface IRemoteTransitionFinishedCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.window.IRemoteTransitionFinishedCallback";

    public void onTransitionFinished(WindowContainerTransaction var1, SurfaceControl.Transaction var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRemoteTransitionFinishedCallback {
        static final int TRANSACTION_onTransitionFinished = 1;

        public Stub() {
            this.attachInterface(this, IRemoteTransitionFinishedCallback.DESCRIPTOR);
        }

        public static IRemoteTransitionFinishedCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRemoteTransitionFinishedCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IRemoteTransitionFinishedCallback) {
                return (IRemoteTransitionFinishedCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTransitionFinished";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRemoteTransitionFinishedCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    WindowContainerTransaction _arg0 = data.readTypedObject(WindowContainerTransaction.CREATOR);
                    SurfaceControl.Transaction _arg1 = data.readTypedObject(SurfaceControl.Transaction.CREATOR);
                    data.enforceNoDataAvail();
                    this.onTransitionFinished(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IRemoteTransitionFinishedCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRemoteTransitionFinishedCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTransitionFinished(WindowContainerTransaction wct, SurfaceControl.Transaction sct) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRemoteTransitionFinishedCallback.DESCRIPTOR);
                    _data.writeTypedObject(wct, 0);
                    _data.writeTypedObject(sct, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRemoteTransitionFinishedCallback {
        @Override
        public void onTransitionFinished(WindowContainerTransaction wct, SurfaceControl.Transaction sct) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

