/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.compat.Compatibility;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Context;
import android.net.Uri;
import android.text.Editable;
import android.text.Selection;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.util.Log;
import android.view.ContentInfo;
import android.view.OnReceiveContentListener;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputContentInfo;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;

@VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
public class TextViewOnReceiveContentListener
implements OnReceiveContentListener {
    private static final String LOG_TAG = "ReceiveContent";
    private InputConnectionInfo mInputConnectionInfo;
    private static final long AUTOFILL_NON_TEXT_REQUIRES_ON_RECEIVE_CONTENT_LISTENER = 163400105L;

    @Override
    public ContentInfo onReceiveContent(View view, ContentInfo payload) {
        int source;
        if (Log.isLoggable(LOG_TAG, 3)) {
            Log.d(LOG_TAG, "onReceive: " + payload);
        }
        if ((source = payload.getSource()) == 2) {
            return payload;
        }
        if (source == 4) {
            this.onReceiveForAutofill((TextView)view, payload);
            return null;
        }
        ClipData clip = payload.getClip();
        int flags = payload.getFlags();
        Editable editable = (Editable)((TextView)view).getText();
        Context context = view.getContext();
        boolean didFirst = false;
        for (int i = 0; i < clip.getItemCount(); ++i) {
            CharSequence itemText;
            itemText = (flags & 1) != 0 ? ((itemText = clip.getItemAt(i).coerceToText(context)) instanceof Spanned ? itemText.toString() : itemText) : clip.getItemAt(i).coerceToStyledText(context);
            if (itemText == null) continue;
            if (!didFirst) {
                TextViewOnReceiveContentListener.replaceSelection(editable, itemText);
                didFirst = true;
                continue;
            }
            editable.insert(Selection.getSelectionEnd(editable), "\n");
            editable.insert(Selection.getSelectionEnd(editable), itemText);
        }
        return null;
    }

    private static void replaceSelection(Editable editable, CharSequence replacement) {
        int selStart = Selection.getSelectionStart(editable);
        int selEnd = Selection.getSelectionEnd(editable);
        int start = Math.max(0, Math.min(selStart, selEnd));
        int end = Math.max(0, Math.max(selStart, selEnd));
        Selection.setSelection(editable, end);
        editable.replace(start, end, replacement);
    }

    private void onReceiveForAutofill(TextView view, ContentInfo payload) {
        ClipData clip = payload.getClip();
        if (TextViewOnReceiveContentListener.isUsageOfImeCommitContentEnabled(view) && (clip = this.handleNonTextViaImeCommitContent(clip)) == null) {
            if (Log.isLoggable(LOG_TAG, 2)) {
                Log.v(LOG_TAG, "onReceive: Handled via IME");
            }
            return;
        }
        CharSequence text = TextViewOnReceiveContentListener.coerceToText(clip, view.getContext(), payload.getFlags());
        view.setText(text);
        Editable editable = (Editable)view.getText();
        Selection.setSelection(editable, editable.length());
    }

    private static CharSequence coerceToText(ClipData clip, Context context, int flags) {
        SpannableStringBuilder ssb = new SpannableStringBuilder();
        for (int i = 0; i < clip.getItemCount(); ++i) {
            CharSequence itemText;
            itemText = (flags & 1) != 0 ? ((itemText = clip.getItemAt(i).coerceToText(context)) instanceof Spanned ? itemText.toString() : itemText) : clip.getItemAt(i).coerceToStyledText(context);
            if (itemText == null) continue;
            ssb.append(itemText);
        }
        return ssb;
    }

    private static boolean isUsageOfImeCommitContentEnabled(View view) {
        if (view.getReceiveContentMimeTypes() != null) {
            return false;
        }
        return !Compatibility.isChangeEnabled(163400105L);
    }

    void setInputConnectionInfo(TextView view, InputConnection ic, EditorInfo editorInfo) {
        if (!TextViewOnReceiveContentListener.isUsageOfImeCommitContentEnabled(view)) {
            this.mInputConnectionInfo = null;
            return;
        }
        String[] contentMimeTypes = editorInfo.contentMimeTypes;
        this.mInputConnectionInfo = contentMimeTypes == null || contentMimeTypes.length == 0 ? null : new InputConnectionInfo(ic, contentMimeTypes);
    }

    void clearInputConnectionInfo() {
        this.mInputConnectionInfo = null;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public String[] getFallbackMimeTypesForAutofill(TextView view) {
        if (!TextViewOnReceiveContentListener.isUsageOfImeCommitContentEnabled(view)) {
            return null;
        }
        InputConnectionInfo icInfo = this.mInputConnectionInfo;
        if (icInfo == null) {
            return null;
        }
        return icInfo.mEditorInfoContentMimeTypes;
    }

    private ClipData handleNonTextViaImeCommitContent(ClipData clip) {
        InputConnection inputConnection;
        ClipDescription description = clip.getDescription();
        if (!TextViewOnReceiveContentListener.containsUri(clip) || TextViewOnReceiveContentListener.containsOnlyText(clip)) {
            if (Log.isLoggable(LOG_TAG, 2)) {
                Log.v(LOG_TAG, "onReceive: Clip doesn't contain any non-text URIs: " + description);
            }
            return clip;
        }
        InputConnectionInfo icInfo = this.mInputConnectionInfo;
        InputConnection inputConnection2 = inputConnection = icInfo != null ? (InputConnection)icInfo.mInputConnection.get() : null;
        if (inputConnection == null) {
            if (Log.isLoggable(LOG_TAG, 3)) {
                Log.d(LOG_TAG, "onReceive: No usable EditorInfo/InputConnection");
            }
            return clip;
        }
        String[] editorInfoContentMimeTypes = icInfo.mEditorInfoContentMimeTypes;
        if (!TextViewOnReceiveContentListener.isClipMimeTypeSupported(editorInfoContentMimeTypes, clip.getDescription())) {
            if (Log.isLoggable(LOG_TAG, 3)) {
                Log.d(LOG_TAG, "onReceive: MIME type is not supported by the app's commitContent impl");
            }
            return clip;
        }
        if (Log.isLoggable(LOG_TAG, 2)) {
            Log.v(LOG_TAG, "onReceive: Trying to insert via IME: " + description);
        }
        ArrayList<ClipData.Item> remainingItems = new ArrayList<ClipData.Item>(0);
        for (int i = 0; i < clip.getItemCount(); ++i) {
            InputContentInfo contentInfo;
            ClipData.Item item = clip.getItemAt(i);
            Uri uri = item.getUri();
            if (uri == null || !"content".equals(uri.getScheme())) {
                if (Log.isLoggable(LOG_TAG, 2)) {
                    Log.v(LOG_TAG, "onReceive: No content URI in item: uri=" + uri);
                }
                remainingItems.add(item);
                continue;
            }
            if (Log.isLoggable(LOG_TAG, 2)) {
                Log.v(LOG_TAG, "onReceive: Calling commitContent: uri=" + uri);
            }
            if (inputConnection.commitContent(contentInfo = new InputContentInfo(uri, description), 0, null)) continue;
            if (Log.isLoggable(LOG_TAG, 2)) {
                Log.v(LOG_TAG, "onReceive: Call to commitContent returned false: uri=" + uri);
            }
            remainingItems.add(item);
        }
        if (remainingItems.isEmpty()) {
            return null;
        }
        return new ClipData(description, remainingItems);
    }

    private static boolean isClipMimeTypeSupported(String[] supportedMimeTypes, ClipDescription description) {
        for (String imeSupportedMimeType : supportedMimeTypes) {
            if (!description.hasMimeType(imeSupportedMimeType)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsUri(ClipData clip) {
        for (int i = 0; i < clip.getItemCount(); ++i) {
            ClipData.Item item = clip.getItemAt(i);
            if (item.getUri() == null) continue;
            return true;
        }
        return false;
    }

    private static boolean containsOnlyText(ClipData clip) {
        ClipDescription description = clip.getDescription();
        for (int i = 0; i < description.getMimeTypeCount(); ++i) {
            String mimeType = description.getMimeType(i);
            if (mimeType.startsWith("text/")) continue;
            return false;
        }
        return true;
    }

    private static class InputConnectionInfo {
        private final WeakReference<InputConnection> mInputConnection;
        private final String[] mEditorInfoContentMimeTypes;

        private InputConnectionInfo(InputConnection inputConnection, String[] editorInfoContentMimeTypes) {
            this.mInputConnection = new WeakReference<InputConnection>(inputConnection);
            this.mEditorInfoContentMimeTypes = editorInfoContentMimeTypes;
        }

        public String toString() {
            return "InputConnectionInfo{mimeTypes=" + Arrays.toString(this.mEditorInfoContentMimeTypes) + ", ic=" + this.mInputConnection + '}';
        }
    }
}

