/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RemoteViews;
import java.util.stream.IntStream;

class RemoteCollectionItemsAdapter
extends BaseAdapter {
    private final int mViewTypeCount;
    private RemoteViews.RemoteCollectionItems mItems;
    private RemoteViews.InteractionHandler mInteractionHandler;
    private RemoteViews.ColorResources mColorResources;
    private SparseIntArray mLayoutIdToViewType;

    RemoteCollectionItemsAdapter(RemoteViews.RemoteCollectionItems items, RemoteViews.InteractionHandler interactionHandler, RemoteViews.ColorResources colorResources) {
        this.mViewTypeCount = items.getViewTypeCount();
        this.mItems = items;
        this.mInteractionHandler = interactionHandler;
        this.mColorResources = colorResources;
        this.initLayoutIdToViewType();
    }

    void setData(RemoteViews.RemoteCollectionItems items, RemoteViews.InteractionHandler interactionHandler, RemoteViews.ColorResources colorResources) {
        if (this.mViewTypeCount < items.getViewTypeCount()) {
            throw new IllegalArgumentException("RemoteCollectionItemsAdapter cannot increase view type count after creation");
        }
        this.mItems = items;
        this.mInteractionHandler = interactionHandler;
        this.mColorResources = colorResources;
        this.initLayoutIdToViewType();
        this.notifyDataSetChanged();
    }

    private void initLayoutIdToViewType() {
        SparseIntArray previousLayoutIdToViewType = this.mLayoutIdToViewType;
        this.mLayoutIdToViewType = new SparseIntArray(this.mViewTypeCount);
        int[] layoutIds = IntStream.range(0, this.mItems.getItemCount()).map(position -> this.mItems.getItemView(position).getLayoutId()).distinct().toArray();
        if (layoutIds.length > this.mViewTypeCount) {
            throw new IllegalArgumentException("Collection items uses " + layoutIds.length + " distinct layouts, which is more than view type count of " + this.mViewTypeCount);
        }
        boolean[] processedLayoutIdIndices = new boolean[layoutIds.length];
        boolean[] assignedViewTypes = new boolean[this.mViewTypeCount];
        if (previousLayoutIdToViewType != null) {
            for (int i = 0; i < layoutIds.length; ++i) {
                int layoutId = layoutIds[i];
                int previousViewType = previousLayoutIdToViewType.get(layoutId, -1);
                if (previousViewType < 0) continue;
                this.mLayoutIdToViewType.put(layoutId, previousViewType);
                processedLayoutIdIndices[i] = true;
                assignedViewTypes[previousViewType] = true;
            }
        }
        int lastViewType = -1;
        for (int i = 0; i < layoutIds.length; ++i) {
            if (processedLayoutIdIndices[i]) continue;
            int layoutId = layoutIds[i];
            int viewType = IntStream.range(lastViewType + 1, layoutIds.length).filter(type -> !assignedViewTypes[type]).findFirst().orElseThrow(() -> new IllegalStateException("RemoteCollectionItems has more distinct layout ids than its view type count"));
            this.mLayoutIdToViewType.put(layoutId, viewType);
            processedLayoutIdIndices[i] = true;
            assignedViewTypes[viewType] = true;
            lastViewType = viewType;
        }
    }

    @Override
    public int getCount() {
        return this.mItems.getItemCount();
    }

    @Override
    public RemoteViews getItem(int position) {
        return this.mItems.getItemView(position);
    }

    @Override
    public long getItemId(int position) {
        return this.mItems.getItemId(position);
    }

    @Override
    public int getItemViewType(int position) {
        return this.mLayoutIdToViewType.get(this.mItems.getItemView(position).getLayoutId());
    }

    @Override
    public int getViewTypeCount() {
        return this.mViewTypeCount;
    }

    @Override
    public boolean hasStableIds() {
        return this.mItems.hasStableIds();
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        if (position >= this.getCount()) {
            return null;
        }
        RemoteViews item = this.mItems.getItemView(position);
        item.addFlags(2);
        View reapplyView = RemoteCollectionItemsAdapter.getViewToReapply(convertView, item);
        if (reapplyView != null) {
            try {
                item.reapply(parent.getContext(), reapplyView, this.mInteractionHandler, null, this.mColorResources);
                return reapplyView;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return item.apply(parent.getContext(), parent, this.mInteractionHandler, null, this.mColorResources);
    }

    private static View getViewToReapply(View convertView, RemoteViews item) {
        if (convertView == null) {
            return null;
        }
        Object layoutIdTag = convertView.getTag(16908312);
        if (!(layoutIdTag instanceof Integer)) {
            return null;
        }
        return item.getLayoutId() == ((Integer)layoutIdTag).intValue() ? convertView : null;
    }
}

