/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.RemoteException;
import android.service.translation.ITranslationCallback;
import android.util.Log;
import android.view.translation.ITranslationDirectManager;
import android.view.translation.ITranslationManager;
import android.view.translation.TranslationContext;
import android.view.translation.TranslationManager;
import android.view.translation.TranslationRequest;
import android.view.translation.TranslationResponse;
import android.view.translation.UiTranslationController;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.IResultReceiver;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

@SuppressLint(value={"NotCloseable"})
public class Translator {
    private static final String TAG = "Translator";
    private final Object mLock = new Object();
    private int mId;
    private final Context mContext;
    private final TranslationContext mTranslationContext;
    private final TranslationManager mManager;
    private final Handler mHandler;
    private ITranslationManager mSystemServerBinder;
    private ITranslationDirectManager mDirectServiceBinder;
    private final ServiceBinderReceiver mServiceBinderReceiver;
    @GuardedBy(value={"mLock"})
    private boolean mDestroyed;
    public static final String EXTRA_SERVICE_BINDER = "binder";
    public static final String EXTRA_SESSION_ID = "sessionId";

    public Translator(Context context, TranslationContext translationContext, int sessionId, TranslationManager translationManager, Handler handler, ITranslationManager systemServerBinder, Consumer<Translator> callback) {
        this.mContext = context;
        this.mTranslationContext = translationContext;
        this.mId = sessionId;
        this.mManager = translationManager;
        this.mHandler = handler;
        this.mSystemServerBinder = systemServerBinder;
        this.mServiceBinderReceiver = new ServiceBinderReceiver(this, callback);
        try {
            this.mSystemServerBinder.onSessionCreated(this.mTranslationContext, this.mId, this.mServiceBinderReceiver, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            Log.w(TAG, "RemoteException calling startSession(): " + e);
        }
    }

    public Translator(Context context, TranslationContext translationContext, int sessionId, TranslationManager translationManager, Handler handler, ITranslationManager systemServerBinder) {
        this.mContext = context;
        this.mTranslationContext = translationContext;
        this.mId = sessionId;
        this.mManager = translationManager;
        this.mHandler = handler;
        this.mSystemServerBinder = systemServerBinder;
        this.mServiceBinderReceiver = new ServiceBinderReceiver(this);
    }

    void start() {
        try {
            this.mSystemServerBinder.onSessionCreated(this.mTranslationContext, this.mId, this.mServiceBinderReceiver, this.mContext.getUserId());
        }
        catch (RemoteException e) {
            Log.w(TAG, "RemoteException calling startSession(): " + e);
        }
    }

    boolean isSessionCreated() throws ServiceBinderReceiver.TimeoutException {
        int receivedId = this.mServiceBinderReceiver.getSessionStateResult();
        return receivedId > 0;
    }

    private int getNextRequestId() {
        return this.mManager.getAvailableRequestId().getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServiceBinder(IBinder binder) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDirectServiceBinder != null) {
                return;
            }
            if (binder != null) {
                this.mDirectServiceBinder = ITranslationDirectManager.Stub.asInterface(binder);
            }
        }
    }

    public TranslationContext getTranslationContext() {
        return this.mTranslationContext;
    }

    public int getTranslatorId() {
        return this.mId;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("translationContext: ");
        pw.println(this.mTranslationContext);
    }

    @Deprecated
    public void translate(TranslationRequest request, Executor executor, Consumer<TranslationResponse> callback) {
        Objects.requireNonNull(request, "Translation request cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        if (this.isDestroyed()) {
            throw new IllegalStateException("This translator has been destroyed");
        }
        TranslationResponseCallbackImpl responseCallback = new TranslationResponseCallbackImpl(callback, executor);
        try {
            this.mDirectServiceBinder.onTranslationRequest(request, this.mId, CancellationSignal.createTransport(), responseCallback);
        }
        catch (RemoteException e) {
            Log.w(TAG, "RemoteException calling requestTranslate(): " + e);
        }
    }

    public void translate(TranslationRequest request, CancellationSignal cancellationSignal, Executor executor, Consumer<TranslationResponse> callback) {
        Objects.requireNonNull(request, "Translation request cannot be null");
        Objects.requireNonNull(executor, "Executor cannot be null");
        Objects.requireNonNull(callback, "Callback cannot be null");
        if (this.isDestroyed()) {
            throw new IllegalStateException("This translator has been destroyed");
        }
        ICancellationSignal transport = null;
        if (cancellationSignal != null) {
            transport = CancellationSignal.createTransport();
            cancellationSignal.setRemote(transport);
        }
        TranslationResponseCallbackImpl responseCallback = new TranslationResponseCallbackImpl(callback, executor);
        try {
            this.mDirectServiceBinder.onTranslationRequest(request, this.mId, transport, responseCallback);
        }
        catch (RemoteException e) {
            Log.w(TAG, "RemoteException calling requestTranslate(): " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            this.mDestroyed = true;
            try {
                this.mDirectServiceBinder.onFinishTranslationSession(this.mId);
            }
            catch (RemoteException e) {
                Log.w(TAG, "RemoteException calling onSessionFinished");
            }
            this.mDirectServiceBinder = null;
            this.mManager.removeTranslator(this.mId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDestroyed;
        }
    }

    public void requestUiTranslate(TranslationRequest request, Executor executor, Consumer<TranslationResponse> callback) {
        if (this.mDirectServiceBinder == null) {
            Log.wtf(TAG, "Translator created without proper initialization.");
            return;
        }
        TranslationResponseCallbackImpl translationCallback = new TranslationResponseCallbackImpl(callback, executor);
        try {
            this.mDirectServiceBinder.onTranslationRequest(request, this.mId, CancellationSignal.createTransport(), translationCallback);
        }
        catch (RemoteException e) {
            Log.w(TAG, "RemoteException calling flushRequest");
        }
    }

    private static class TranslationResponseCallbackImpl
    extends ITranslationCallback.Stub {
        private final Consumer<TranslationResponse> mCallback;
        private final Executor mExecutor;

        TranslationResponseCallbackImpl(Consumer<TranslationResponse> callback, Executor executor) {
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTranslationResponse(TranslationResponse response) throws RemoteException {
            if (UiTranslationController.DEBUG) {
                Log.i(Translator.TAG, "onTranslationResponse called.");
            }
            Runnable runnable = () -> this.mCallback.accept(response);
            long token = Binder.clearCallingIdentity();
            try {
                this.mExecutor.execute(runnable);
            }
            finally {
                TranslationResponseCallbackImpl.restoreCallingIdentity(token);
            }
        }
    }

    static class ServiceBinderReceiver
    extends IResultReceiver.Stub {
        private final Translator mTranslator;
        private final CountDownLatch mLatch = new CountDownLatch(1);
        private int mSessionId;
        private Consumer<Translator> mCallback;

        ServiceBinderReceiver(Translator translator, Consumer<Translator> callback) {
            this.mTranslator = translator;
            this.mCallback = callback;
        }

        ServiceBinderReceiver(Translator translator) {
            this.mTranslator = translator;
        }

        int getSessionStateResult() throws TimeoutException {
            try {
                if (!this.mLatch.await(60000L, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException("Session not created in 60000ms");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TimeoutException("Session not created because interrupted");
            }
            return this.mSessionId;
        }

        @Override
        public void send(int resultCode, Bundle resultData) {
            IBinder binder;
            if (resultCode == 2) {
                this.mLatch.countDown();
                if (this.mCallback != null) {
                    this.mCallback.accept(null);
                }
                return;
            }
            if (resultData != null) {
                this.mSessionId = resultData.getInt(Translator.EXTRA_SESSION_ID);
                binder = resultData.getBinder(Translator.EXTRA_SERVICE_BINDER);
                if (binder == null) {
                    Log.wtf(Translator.TAG, "No binder extra result");
                    return;
                }
            } else {
                binder = null;
            }
            this.mTranslator.setServiceBinder(binder);
            this.mLatch.countDown();
            if (this.mCallback != null) {
                this.mCallback.accept(this.mTranslator);
            }
        }

        static class TimeoutException
        extends Exception {
            private TimeoutException(String msg) {
                super(msg);
            }
        }
    }
}

