/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.os.Binder;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.translation.ITranslationCallback;
import android.view.translation.TranslationRequest;

public interface ITranslationDirectManager
extends IInterface {
    public static final String DESCRIPTOR = "android.view.translation.ITranslationDirectManager";

    public void onTranslationRequest(TranslationRequest var1, int var2, ICancellationSignal var3, ITranslationCallback var4) throws RemoteException;

    public void onFinishTranslationSession(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITranslationDirectManager {
        static final int TRANSACTION_onTranslationRequest = 1;
        static final int TRANSACTION_onFinishTranslationSession = 2;

        public Stub() {
            this.attachInterface(this, ITranslationDirectManager.DESCRIPTOR);
        }

        public static ITranslationDirectManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITranslationDirectManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITranslationDirectManager) {
                return (ITranslationDirectManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTranslationRequest";
                }
                case 2: {
                    return "onFinishTranslationSession";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITranslationDirectManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    TranslationRequest _arg0 = data.readTypedObject(TranslationRequest.CREATOR);
                    int _arg1 = data.readInt();
                    ICancellationSignal _arg2 = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    ITranslationCallback _arg3 = ITranslationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onTranslationRequest(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onFinishTranslationSession(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ITranslationDirectManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITranslationDirectManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTranslationRequest(TranslationRequest request, int sessionId, ICancellationSignal transport, ITranslationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationDirectManager.DESCRIPTOR);
                    _data.writeTypedObject(request, 0);
                    _data.writeInt(sessionId);
                    _data.writeStrongInterface(transport);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFinishTranslationSession(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationDirectManager.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITranslationDirectManager {
        @Override
        public void onTranslationRequest(TranslationRequest request, int sessionId, ICancellationSignal transport, ITranslationCallback callback) throws RemoteException {
        }

        @Override
        public void onFinishTranslationSession(int sessionId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

