/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.view.inputmethod.InputMethodManager;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import com.android.internal.textservice.ITextServicesManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executor;

public class _Original_TextServicesManager {
    private static final String TAG = _Original_TextServicesManager.class.getSimpleName();
    private static final boolean DBG = false;
    @Deprecated
    private static _Original_TextServicesManager sInstance;
    private final ITextServicesManager mService = ITextServicesManager.Stub.asInterface(ServiceManager.getServiceOrThrow("textservices"));
    private final int mUserId;
    private final InputMethodManager mInputMethodManager;

    private _Original_TextServicesManager(int userId, InputMethodManager inputMethodManager) throws ServiceManager.ServiceNotFoundException {
        this.mUserId = userId;
        this.mInputMethodManager = inputMethodManager;
    }

    public static _Original_TextServicesManager createInstance(Context context) throws ServiceManager.ServiceNotFoundException {
        return new _Original_TextServicesManager(context.getUserId(), context.getSystemService(InputMethodManager.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static _Original_TextServicesManager getInstance() {
        Class<_Original_TextServicesManager> clazz = _Original_TextServicesManager.class;
        synchronized (_Original_TextServicesManager.class) {
            if (sInstance == null) {
                try {
                    sInstance = new _Original_TextServicesManager(UserHandle.myUserId(), null);
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public InputMethodManager getInputMethodManager() {
        return this.mInputMethodManager;
    }

    private static String parseLanguageFromLocaleString(String locale) {
        int idx = locale.indexOf(95);
        if (idx < 0) {
            return locale;
        }
        return locale.substring(0, idx);
    }

    public SpellCheckerSession newSpellCheckerSession(Bundle bundle, Locale locale, SpellCheckerSession.SpellCheckerSessionListener listener, boolean referToSpellCheckerLanguageSettings) {
        int supportedAttributes = 7;
        SpellCheckerSession.SpellCheckerSessionParams.Builder paramsBuilder = new SpellCheckerSession.SpellCheckerSessionParams.Builder().setLocale(locale).setShouldReferToSpellCheckerLanguageSettings(referToSpellCheckerLanguageSettings).setSupportedAttributes(supportedAttributes);
        if (bundle != null) {
            paramsBuilder.setExtras(bundle);
        }
        HandlerExecutor executor = new HandlerExecutor(new Handler());
        return this.newSpellCheckerSession(paramsBuilder.build(), executor, listener);
    }

    public SpellCheckerSession newSpellCheckerSession(SpellCheckerSession.SpellCheckerSessionParams params, Executor executor, SpellCheckerSession.SpellCheckerSessionListener listener) {
        SpellCheckerInfo sci;
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        Locale locale = params.getLocale();
        if (!params.shouldReferToSpellCheckerLanguageSettings() && locale == null) {
            throw new IllegalArgumentException("Locale should not be null if you don't refer settings.");
        }
        if (params.shouldReferToSpellCheckerLanguageSettings() && !this.isSpellCheckerEnabled()) {
            return null;
        }
        try {
            sci = this.mService.getCurrentSpellChecker(this.mUserId, null);
        }
        catch (RemoteException e) {
            return null;
        }
        if (sci == null) {
            return null;
        }
        SpellCheckerSubtype subtypeInUse = null;
        if (params.shouldReferToSpellCheckerLanguageSettings()) {
            String subtypeLocale;
            String subtypeLanguage;
            subtypeInUse = this.getCurrentSpellCheckerSubtype(true);
            if (subtypeInUse == null) {
                return null;
            }
            if (!(locale == null || (subtypeLanguage = _Original_TextServicesManager.parseLanguageFromLocaleString(subtypeLocale = subtypeInUse.getLocale())).length() >= 2 && locale.getLanguage().equals(subtypeLanguage))) {
                return null;
            }
        } else {
            String localeStr = locale.toString();
            for (int i = 0; i < sci.getSubtypeCount(); ++i) {
                SpellCheckerSubtype subtype = sci.getSubtypeAt(i);
                String tempSubtypeLocale = subtype.getLocale();
                String tempSubtypeLanguage = _Original_TextServicesManager.parseLanguageFromLocaleString(tempSubtypeLocale);
                if (tempSubtypeLocale.equals(localeStr)) {
                    subtypeInUse = subtype;
                    break;
                }
                if (tempSubtypeLanguage.length() < 2 || !locale.getLanguage().equals(tempSubtypeLanguage)) continue;
                subtypeInUse = subtype;
            }
        }
        if (subtypeInUse == null) {
            return null;
        }
        SpellCheckerSession session = new SpellCheckerSession(sci, this, listener, executor);
        try {
            this.mService.getSpellCheckerService(this.mUserId, sci.getId(), subtypeInUse.getLocale(), session.getTextServicesSessionListener(), session.getSpellCheckerSessionListener(), params.getExtras(), params.getSupportedAttributes());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return session;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, publicAlternatives="Use {@link #getEnabledSpellCheckerInfos()} instead.")
    public SpellCheckerInfo[] getEnabledSpellCheckers() {
        try {
            SpellCheckerInfo[] retval = this.mService.getEnabledSpellCheckers(this.mUserId);
            return retval;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<SpellCheckerInfo> getEnabledSpellCheckerInfos() {
        SpellCheckerInfo[] enabledSpellCheckers = this.getEnabledSpellCheckers();
        return enabledSpellCheckers != null ? Arrays.asList(enabledSpellCheckers) : Collections.emptyList();
    }

    public SpellCheckerInfo getCurrentSpellCheckerInfo() {
        try {
            return this.mService.getCurrentSpellChecker(this.mUserId, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, publicAlternatives="Use {@link #getCurrentSpellCheckerInfo()} instead.")
    public SpellCheckerInfo getCurrentSpellChecker() {
        return this.getCurrentSpellCheckerInfo();
    }

    @UnsupportedAppUsage
    public SpellCheckerSubtype getCurrentSpellCheckerSubtype(boolean allowImplicitlySelectedSubtype) {
        try {
            return this.mService.getCurrentSpellCheckerSubtype(this.mUserId, allowImplicitlySelectedSubtype);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isSpellCheckerEnabled() {
        try {
            return this.mService.isSpellCheckerEnabled(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void finishSpellCheckerService(ISpellCheckerSessionListener listener) {
        try {
            this.mService.finishSpellCheckerService(this.mUserId, listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

